/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import java.util.HashMap;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.store.ByteArrayUtil;
import org.apache.drill.exec.store.parquet.FieldInfo;
import org.apache.drill.exec.store.parquet.ParquetTestProperties;
import org.apache.drill.exec.store.parquet.WrapAroundCounter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import parquet.bytes.ByteBufferAllocator;
import parquet.bytes.BytesInput;
import parquet.bytes.DirectByteBufferAllocator;
import parquet.column.ColumnDescriptor;
import parquet.column.Encoding;
import parquet.column.values.rle.RunLengthBitPackingHybridValuesWriter;
import parquet.hadoop.ParquetFileWriter;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;

public class TestFileGenerator {
    static final Logger logger = LoggerFactory.getLogger(TestFileGenerator.class);
    static int bytesPerPage = 0x100000;
    static byte[] bitFields = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    static final byte allBitsTrue = -1;
    static final byte allBitsFalse = 0;
    static final byte[] varLen1 = new byte[]{50, 51, 52, 53, 54, 55, 56};
    static final byte[] varLen2 = new byte[]{15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1};
    static final byte[] varLen3 = new byte[]{100, 99, 98};
    static final Object[] intVals = new Object[]{-200, 100, Integer.MAX_VALUE};
    static final Object[] longVals = new Object[]{-5000L, 5000L, Long.MAX_VALUE};
    static final Object[] floatVals = new Object[]{Float.valueOf(1.74f), Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MIN_VALUE)};
    static final Object[] doubleVals = new Object[]{100.45, Double.MAX_VALUE, Double.MIN_VALUE};
    static final Object[] boolVals = new Object[]{false, false, true};
    static final Object[] binVals = new Object[]{varLen1, varLen2, varLen3};
    static final Object[] bin2Vals = new Object[]{varLen3, varLen2, varLen1};
    public static final int MAX_EXPECTED_BIT_WIDTH_FOR_DEFINITION_LEVELS = 16;

    static void populateDrill_418_fields(ParquetTestProperties props) {
        props.fields.put("cust_key", new FieldInfo("int32", "integer", 32, intVals, TypeProtos.MinorType.INT, props));
        props.fields.put("nation_key", new FieldInfo("int32", "integer", 32, intVals, TypeProtos.MinorType.INT, props));
        props.fields.put("acctbal", new FieldInfo("int32", "integer", 32, intVals, TypeProtos.MinorType.INT, props));
        props.fields.put("name", new FieldInfo("int32", "integer", 32, intVals, TypeProtos.MinorType.INT, props));
        props.fields.put("address", new FieldInfo("int32", "integer", 32, intVals, TypeProtos.MinorType.INT, props));
        props.fields.put("phone", new FieldInfo("int32", "integer", 32, intVals, TypeProtos.MinorType.INT, props));
        props.fields.put("mktsegment", new FieldInfo("int32", "integer", 32, intVals, TypeProtos.MinorType.INT, props));
        props.fields.put("comment_col", new FieldInfo("int32", "integer", 32, intVals, TypeProtos.MinorType.INT, props));
    }

    static void populateFieldInfoMap(ParquetTestProperties props) {
        props.fields.put("integer", new FieldInfo("int32", "integer", 32, intVals, TypeProtos.MinorType.INT, props));
        props.fields.put("bigInt", new FieldInfo("int64", "bigInt", 64, longVals, TypeProtos.MinorType.BIGINT, props));
        props.fields.put("f", new FieldInfo("float", "f", 32, floatVals, TypeProtos.MinorType.FLOAT4, props));
        props.fields.put("d", new FieldInfo("double", "d", 64, doubleVals, TypeProtos.MinorType.FLOAT8, props));
        props.fields.put("b", new FieldInfo("boolean", "b", 1, boolVals, TypeProtos.MinorType.BIT, props));
        props.fields.put("bin", new FieldInfo("binary", "bin", -1, binVals, TypeProtos.MinorType.VARBINARY, props));
        props.fields.put("bin2", new FieldInfo("binary", "bin2", -1, bin2Vals, TypeProtos.MinorType.VARBINARY, props));
    }

    static void populatePigTPCHCustomerFields(ParquetTestProperties props) {
        props.fields.put("C_CUSTKEY", new FieldInfo("int32", "integer", 32, intVals, TypeProtos.MinorType.INT, props));
        props.fields.put("C_NATIONKEY", new FieldInfo("int64", "bigInt", 64, longVals, TypeProtos.MinorType.BIGINT, props));
        props.fields.put("C_ACCTBAL", new FieldInfo("float", "f", 32, floatVals, TypeProtos.MinorType.FLOAT4, props));
        props.fields.put("C_NAME", new FieldInfo("double", "d", 64, doubleVals, TypeProtos.MinorType.FLOAT8, props));
        props.fields.put("C_ADDRESS", new FieldInfo("boolean", "b", 1, boolVals, TypeProtos.MinorType.BIT, props));
        props.fields.put("C_PHONE", new FieldInfo("binary", "bin", -1, binVals, TypeProtos.MinorType.VARBINARY, props));
        props.fields.put("C_MKTSEGMENT", new FieldInfo("binary", "bin2", -1, bin2Vals, TypeProtos.MinorType.VARBINARY, props));
        props.fields.put("C_COMMENT", new FieldInfo("binary", "bin2", -1, bin2Vals, TypeProtos.MinorType.VARBINARY, props));
    }

    static void populatePigTPCHSupplierFields(ParquetTestProperties props) {
        props.fields.put("S_SUPPKEY", new FieldInfo("int32", "integer", 32, intVals, TypeProtos.MinorType.INT, props));
        props.fields.put("S_NATIONKEY", new FieldInfo("int64", "bigInt", 64, longVals, TypeProtos.MinorType.BIGINT, props));
        props.fields.put("S_ACCTBAL", new FieldInfo("float", "f", 32, floatVals, TypeProtos.MinorType.FLOAT4, props));
        props.fields.put("S_NAME", new FieldInfo("double", "d", 64, doubleVals, TypeProtos.MinorType.FLOAT8, props));
        props.fields.put("S_ADDRESS", new FieldInfo("boolean", "b", 1, boolVals, TypeProtos.MinorType.BIT, props));
        props.fields.put("S_PHONE", new FieldInfo("binary", "bin", -1, binVals, TypeProtos.MinorType.VARBINARY, props));
        props.fields.put("S_COMMENT", new FieldInfo("binary", "bin2", -1, bin2Vals, TypeProtos.MinorType.VARBINARY, props));
    }

    public static void generateParquetFile(String filename, ParquetTestProperties props) throws Exception {
        int currentBooleanByte = 0;
        WrapAroundCounter booleanBitCounter = new WrapAroundCounter(7);
        Configuration configuration = new Configuration();
        configuration.set("fs.defaultFS", "file:///");
        FileSystem fs = FileSystem.get((Configuration)configuration);
        Path path = new Path(filename);
        if (fs.exists(path)) {
            fs.delete(path, false);
        }
        String messageSchema = "message m {";
        for (FieldInfo fieldInfo : props.fields.values()) {
            messageSchema = messageSchema + " required " + fieldInfo.parquetType + " " + fieldInfo.name + ";";
        }
        messageSchema = messageSchema + "}";
        MessageType schema = MessageTypeParser.parseMessageType((String)messageSchema);
        CompressionCodecName codec = CompressionCodecName.UNCOMPRESSED;
        ParquetFileWriter w = new ParquetFileWriter(configuration, schema, path);
        w.start();
        HashMap<String, Integer> columnValuesWritten = new HashMap<String, Integer>();
        for (int k = 0; k < props.numberRowGroups; ++k) {
            w.startBlock((long)props.recordsPerRowGroup);
            currentBooleanByte = 0;
            booleanBitCounter.reset();
            for (FieldInfo fieldInfo : props.fields.values()) {
                byte[] bytes;
                int valsWritten;
                if (!columnValuesWritten.containsKey(fieldInfo.name)) {
                    columnValuesWritten.put(fieldInfo.name, 0);
                    valsWritten = 0;
                } else {
                    valsWritten = (Integer)columnValuesWritten.get(fieldInfo.name);
                }
                String[] path1 = new String[]{fieldInfo.name};
                ColumnDescriptor c1 = schema.getColumnDescription(path1);
                w.startColumn(c1, (long)props.recordsPerRowGroup, codec);
                int valsPerPage = (int)Math.ceil((float)props.recordsPerRowGroup / (float)fieldInfo.numberOfPages);
                RunLengthBitPackingHybridValuesWriter defLevels = new RunLengthBitPackingHybridValuesWriter(16, valsPerPage, (ByteBufferAllocator)new DirectByteBufferAllocator());
                RunLengthBitPackingHybridValuesWriter repLevels = new RunLengthBitPackingHybridValuesWriter(16, valsPerPage, (ByteBufferAllocator)new DirectByteBufferAllocator());
                int bytesNeededToEncodeLength = 4;
                if (fieldInfo.bitLength > 0) {
                    bytes = new byte[(int)Math.ceil((double)(valsPerPage * fieldInfo.bitLength) / 8.0)];
                } else {
                    int totalValLength = ((byte[])fieldInfo.values[0]).length + ((byte[])fieldInfo.values[1]).length + ((byte[])fieldInfo.values[2]).length + 3 * bytesNeededToEncodeLength;
                    int leftOverBytes = 0;
                    if (valsPerPage % 3 > 0) {
                        leftOverBytes += ((byte[])fieldInfo.values[1]).length + bytesNeededToEncodeLength;
                    }
                    if (valsPerPage % 3 > 1) {
                        leftOverBytes += ((byte[])fieldInfo.values[2]).length + bytesNeededToEncodeLength;
                    }
                    bytes = new byte[valsPerPage / 3 * totalValLength + leftOverBytes];
                }
                int bytesPerPage = (int)((double)valsPerPage * ((double)fieldInfo.bitLength / 8.0));
                int bytesWritten = 0;
                for (int z = 0; z < fieldInfo.numberOfPages; ++z) {
                    for (int i = 0; i < valsPerPage; ++i) {
                        repLevels.writeInteger(0);
                        defLevels.writeInteger(1);
                        if (fieldInfo.values[0] instanceof Boolean) {
                            int n = currentBooleanByte;
                            bytes[n] = (byte)(bytes[n] | bitFields[booleanBitCounter.val] & ((Boolean)fieldInfo.values[valsWritten % 3] != false ? -1 : 0));
                            booleanBitCounter.increment();
                            if (booleanBitCounter.val == 0) {
                                ++currentBooleanByte;
                            }
                            ++valsWritten;
                            if (currentBooleanByte <= bytesPerPage) continue;
                            break;
                        }
                        if (fieldInfo.values[valsWritten % 3] instanceof byte[]) {
                            System.arraycopy(ByteArrayUtil.toByta(((byte[])fieldInfo.values[valsWritten % 3]).length), 0, bytes, bytesWritten, bytesNeededToEncodeLength);
                            System.arraycopy(fieldInfo.values[valsWritten % 3], 0, bytes, bytesWritten + bytesNeededToEncodeLength, ((byte[])fieldInfo.values[valsWritten % 3]).length);
                            bytesWritten += ((byte[])fieldInfo.values[valsWritten % 3]).length + bytesNeededToEncodeLength;
                        } else {
                            System.arraycopy(ByteArrayUtil.toByta(fieldInfo.values[valsWritten % 3]), 0, bytes, i * (fieldInfo.bitLength / 8), fieldInfo.bitLength / 8);
                        }
                        ++valsWritten;
                    }
                    byte[] fullPage = new byte[8 * valsPerPage + bytes.length];
                    byte[] repLevelBytes = repLevels.getBytes().toByteArray();
                    byte[] defLevelBytes = defLevels.getBytes().toByteArray();
                    System.arraycopy(bytes, 0, fullPage, 0, bytes.length);
                    System.arraycopy(repLevelBytes, 0, fullPage, bytes.length, repLevelBytes.length);
                    System.arraycopy(defLevelBytes, 0, fullPage, bytes.length + repLevelBytes.length, defLevelBytes.length);
                    w.writeDataPage(props.recordsPerRowGroup / fieldInfo.numberOfPages, fullPage.length, BytesInput.from((byte[])fullPage), Encoding.RLE, Encoding.RLE, Encoding.PLAIN);
                    currentBooleanByte = 0;
                    bytesWritten = 0;
                }
                w.endColumn();
                columnValuesWritten.remove(fieldInfo.name);
                columnValuesWritten.put(fieldInfo.name, valsWritten);
            }
            w.endBlock();
        }
        w.end(new HashMap());
        logger.debug("Finished generating parquet file.");
    }

    private static class ValueRepeaterProducer
    extends ValueProducer {
        WrapAroundCounter position;
        Object[] values;

        public ValueRepeaterProducer(Object[] values) {
            this.values = values;
            this.position = new WrapAroundCounter(values.length);
        }

        @Override
        public void reset() {
            this.position.reset();
        }

        @Override
        public Object getValue() {
            Object ret = this.values[this.position.val];
            this.position.increment();
            return ret;
        }
    }

    private static abstract class ValueProducer {
        private ValueProducer() {
        }

        public abstract void reset();

        public abstract Object getValue();
    }
}

