/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import java.util.HashMap;
import java.util.Map;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.record.MaterializedField;
import parquet.schema.DecimalMetadata;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;

public class ParquetTypeHelper {
    private static Map<TypeProtos.MinorType, PrimitiveType.PrimitiveTypeName> typeMap = new HashMap<TypeProtos.MinorType, PrimitiveType.PrimitiveTypeName>();
    private static Map<TypeProtos.DataMode, Type.Repetition> modeMap;
    private static Map<TypeProtos.MinorType, OriginalType> originalTypeMap;

    public static PrimitiveType.PrimitiveTypeName getPrimitiveTypeNameForMinorType(TypeProtos.MinorType minorType) {
        return typeMap.get(minorType);
    }

    public static Type.Repetition getRepetitionForDataMode(TypeProtos.DataMode dataMode) {
        return modeMap.get(dataMode);
    }

    public static OriginalType getOriginalTypeForMinorType(TypeProtos.MinorType minorType) {
        return originalTypeMap.get(minorType);
    }

    public static DecimalMetadata getDecimalMetadataForField(MaterializedField field) {
        switch (field.getType().getMinorType()) {
            case DECIMAL9: 
            case DECIMAL18: 
            case DECIMAL28SPARSE: 
            case DECIMAL28DENSE: 
            case DECIMAL38SPARSE: 
            case DECIMAL38DENSE: {
                return new DecimalMetadata(field.getPrecision(), field.getScale());
            }
        }
        return null;
    }

    public static int getLengthForMinorType(TypeProtos.MinorType minorType) {
        switch (minorType) {
            case INTERVALDAY: 
            case INTERVALYEAR: 
            case INTERVAL: {
                return 12;
            }
            case DECIMAL28SPARSE: {
                return 12;
            }
            case DECIMAL38SPARSE: {
                return 16;
            }
        }
        return 0;
    }

    static {
        typeMap.put(TypeProtos.MinorType.TINYINT, PrimitiveType.PrimitiveTypeName.INT32);
        typeMap.put(TypeProtos.MinorType.UINT1, PrimitiveType.PrimitiveTypeName.INT32);
        typeMap.put(TypeProtos.MinorType.UINT2, PrimitiveType.PrimitiveTypeName.INT32);
        typeMap.put(TypeProtos.MinorType.SMALLINT, PrimitiveType.PrimitiveTypeName.INT32);
        typeMap.put(TypeProtos.MinorType.INT, PrimitiveType.PrimitiveTypeName.INT32);
        typeMap.put(TypeProtos.MinorType.UINT4, PrimitiveType.PrimitiveTypeName.INT32);
        typeMap.put(TypeProtos.MinorType.FLOAT4, PrimitiveType.PrimitiveTypeName.FLOAT);
        typeMap.put(TypeProtos.MinorType.TIME, PrimitiveType.PrimitiveTypeName.INT32);
        typeMap.put(TypeProtos.MinorType.INTERVALYEAR, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY);
        typeMap.put(TypeProtos.MinorType.DECIMAL9, PrimitiveType.PrimitiveTypeName.INT32);
        typeMap.put(TypeProtos.MinorType.BIGINT, PrimitiveType.PrimitiveTypeName.INT64);
        typeMap.put(TypeProtos.MinorType.UINT8, PrimitiveType.PrimitiveTypeName.INT64);
        typeMap.put(TypeProtos.MinorType.FLOAT8, PrimitiveType.PrimitiveTypeName.DOUBLE);
        typeMap.put(TypeProtos.MinorType.DATE, PrimitiveType.PrimitiveTypeName.INT32);
        typeMap.put(TypeProtos.MinorType.TIMESTAMP, PrimitiveType.PrimitiveTypeName.INT64);
        typeMap.put(TypeProtos.MinorType.DECIMAL18, PrimitiveType.PrimitiveTypeName.INT64);
        typeMap.put(TypeProtos.MinorType.INTERVALDAY, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY);
        typeMap.put(TypeProtos.MinorType.INTERVAL, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY);
        typeMap.put(TypeProtos.MinorType.DECIMAL28DENSE, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY);
        typeMap.put(TypeProtos.MinorType.DECIMAL38DENSE, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY);
        typeMap.put(TypeProtos.MinorType.DECIMAL38SPARSE, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY);
        typeMap.put(TypeProtos.MinorType.DECIMAL28SPARSE, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY);
        typeMap.put(TypeProtos.MinorType.VARBINARY, PrimitiveType.PrimitiveTypeName.BINARY);
        typeMap.put(TypeProtos.MinorType.VARCHAR, PrimitiveType.PrimitiveTypeName.BINARY);
        typeMap.put(TypeProtos.MinorType.VAR16CHAR, PrimitiveType.PrimitiveTypeName.BINARY);
        typeMap.put(TypeProtos.MinorType.BIT, PrimitiveType.PrimitiveTypeName.BOOLEAN);
        modeMap = new HashMap<TypeProtos.DataMode, Type.Repetition>();
        modeMap.put(TypeProtos.DataMode.REQUIRED, Type.Repetition.REQUIRED);
        modeMap.put(TypeProtos.DataMode.OPTIONAL, Type.Repetition.OPTIONAL);
        modeMap.put(TypeProtos.DataMode.REPEATED, Type.Repetition.REPEATED);
        originalTypeMap = new HashMap<TypeProtos.MinorType, OriginalType>();
        originalTypeMap.put(TypeProtos.MinorType.DECIMAL9, OriginalType.DECIMAL);
        originalTypeMap.put(TypeProtos.MinorType.DECIMAL18, OriginalType.DECIMAL);
        originalTypeMap.put(TypeProtos.MinorType.DECIMAL28DENSE, OriginalType.DECIMAL);
        originalTypeMap.put(TypeProtos.MinorType.DECIMAL38DENSE, OriginalType.DECIMAL);
        originalTypeMap.put(TypeProtos.MinorType.DECIMAL38SPARSE, OriginalType.DECIMAL);
        originalTypeMap.put(TypeProtos.MinorType.DECIMAL28SPARSE, OriginalType.DECIMAL);
        originalTypeMap.put(TypeProtos.MinorType.VARCHAR, OriginalType.UTF8);
        originalTypeMap.put(TypeProtos.MinorType.DATE, OriginalType.DATE);
        originalTypeMap.put(TypeProtos.MinorType.TIME, OriginalType.TIME_MILLIS);
        originalTypeMap.put(TypeProtos.MinorType.TIMESTAMP, OriginalType.TIMESTAMP_MILLIS);
        originalTypeMap.put(TypeProtos.MinorType.INTERVALDAY, OriginalType.INTERVAL);
        originalTypeMap.put(TypeProtos.MinorType.INTERVALYEAR, OriginalType.INTERVAL);
        originalTypeMap.put(TypeProtos.MinorType.INTERVAL, OriginalType.INTERVAL);
    }
}

