/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.SettableFuture;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.user.ConnectionThrottle;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserResultsListener;
import org.apache.drill.exec.store.parquet.FieldInfo;
import org.apache.drill.exec.store.parquet.ParquetTestProperties;
import org.apache.drill.exec.vector.ValueVector;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetResultListener
implements UserResultsListener {
    private static final Logger logger = LoggerFactory.getLogger(ParquetResultListener.class);
    private final SettableFuture<Void> future = SettableFuture.create();
    int count = 0;
    int totalRecords;
    private boolean testValues;
    private final BufferAllocator allocator;
    int batchCounter = 1;
    private final HashMap<String, Integer> valuesChecked = new HashMap();
    private final ParquetTestProperties props;

    ParquetResultListener(BufferAllocator allocator, ParquetTestProperties props, int numberOfTimesRead, boolean testValues) {
        this.allocator = allocator;
        this.props = props;
        this.totalRecords = props.recordsPerRowGroup * props.numberRowGroups * numberOfTimesRead;
        this.testValues = testValues;
    }

    public void submissionFailed(UserException ex) {
        logger.error("Submission failed.", (Throwable)ex);
        this.future.setException((Throwable)ex);
    }

    public void queryCompleted(UserBitShared.QueryResult.QueryState state) {
        this.checkLastChunk();
    }

    private <T> void assertField(ValueVector valueVector, int index, TypeProtos.MinorType expectedMinorType, Object value, String name) {
        this.assertField(valueVector, index, expectedMinorType, value, name, 0);
    }

    private <T> void assertField(ValueVector valueVector, int index, TypeProtos.MinorType expectedMinorType, T value, String name, int parentFieldId) {
        if (expectedMinorType == TypeProtos.MinorType.MAP) {
            return;
        }
        Object val = valueVector.getAccessor().getObject(index);
        if (val instanceof byte[]) {
            Assert.assertTrue((boolean)Arrays.equals((byte[])value, (byte[])val));
        } else {
            Assert.assertEquals(value, (Object)val);
        }
    }

    public synchronized void dataArrived(QueryDataBatch result, ConnectionThrottle throttle) {
        logger.debug("result arrived in test batch listener.");
        int columnValCounter = 0;
        this.count += result.getHeader().getRowCount();
        boolean schemaChanged = false;
        RecordBatchLoader batchLoader = new RecordBatchLoader(this.allocator);
        try {
            schemaChanged = batchLoader.load(result.getHeader().getDef(), result.getData());
        }
        catch (SchemaChangeException e) {
            throw new RuntimeException(e);
        }
        int valueCount = batchLoader.getRecordCount();
        if (schemaChanged) {
            // empty if block
        }
        for (VectorWrapper vw : batchLoader) {
            ValueVector vv = vw.getValueVector();
            FieldInfo currentField = this.props.fields.get(vv.getField().getPath().getRootSegment().getPath());
            if (!this.valuesChecked.containsKey(vv.getField().getPath().getRootSegment().getPath())) {
                this.valuesChecked.put(vv.getField().getPath().getRootSegment().getPath(), 0);
                columnValCounter = 0;
            } else {
                columnValCounter = this.valuesChecked.get(vv.getField().getPath().getRootSegment().getPath());
            }
            this.printColumnMajor(vv);
            if (this.testValues) {
                for (int j = 0; j < vv.getAccessor().getValueCount(); ++j) {
                    this.assertField(vv, j, currentField.type, currentField.values[columnValCounter % 3], currentField.name + "/");
                    ++columnValCounter;
                }
            } else {
                columnValCounter += vv.getAccessor().getValueCount();
            }
            this.valuesChecked.remove(vv.getField().getPath().getRootSegment().getPath());
            Assert.assertEquals((String)"Mismatched value count for vectors in the same batch.", (long)valueCount, (long)vv.getAccessor().getValueCount());
            this.valuesChecked.put(vv.getField().getPath().getRootSegment().getPath(), columnValCounter);
        }
        ++this.batchCounter;
        batchLoader.clear();
        result.release();
    }

    private void checkLastChunk() {
        int recordsInBatch = -1;
        if (this.testValues) {
            Assert.assertEquals((String)"Unexpected number of output columns from parquet scan.", (long)this.props.fields.keySet().size(), (long)this.valuesChecked.keySet().size());
        }
        for (String s : this.valuesChecked.keySet()) {
            try {
                if (recordsInBatch == -1) {
                    recordsInBatch = this.valuesChecked.get(s);
                } else {
                    Assert.assertEquals((String)"Mismatched record counts in vectors.", (long)recordsInBatch, (long)this.valuesChecked.get(s).intValue());
                }
                Assert.assertEquals((String)("Record count incorrect for column: " + s), (long)this.totalRecords, (long)this.valuesChecked.get(s).intValue());
            }
            catch (AssertionError e) {
                this.submissionFailed(UserException.systemError((Throwable)((Object)e)).build(logger));
            }
        }
        Assert.assertTrue((this.valuesChecked.keySet().size() > 0 ? 1 : 0) != 0);
        this.future.set(null);
    }

    public void printColumnMajor(ValueVector vv) {
        for (int j = 0; j < vv.getAccessor().getValueCount(); ++j) {
        }
    }

    public void printRowMajor(RecordBatchLoader batchLoader) {
        for (int i = 0; i < batchLoader.getRecordCount(); ++i) {
            ValueVector v;
            if (i % 50 == 0) {
                System.out.println();
                for (VectorWrapper vw : batchLoader) {
                    v = vw.getValueVector();
                    System.out.print(Strings.padStart((String)v.getField().getAsSchemaPath().getRootSegment().getPath(), (int)20, (char)' ') + " ");
                }
                System.out.println();
                System.out.println();
            }
            for (VectorWrapper vw : batchLoader) {
                v = vw.getValueVector();
                Object o = v.getAccessor().getObject(i);
                if (o instanceof byte[]) {
                    try {
                        o = new String((byte[])o, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
                System.out.print(Strings.padStart((String)(o + ""), (int)20, (char)' ') + " ");
            }
            System.out.println();
        }
    }

    public void getResults() throws RpcException {
        try {
            this.future.get();
        }
        catch (Throwable t) {
            throw RpcException.mapException((Throwable)t);
        }
    }

    public void queryIdArrived(UserBitShared.QueryId queryId) {
    }
}

