/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import com.google.common.base.Charsets;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import io.netty.buffer.DrillBuf;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import mockit.Injectable;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.CachedSingleFileSystem;
import org.apache.drill.exec.store.TestOutputMutator;
import org.apache.drill.exec.store.parquet.DirectCodecFactory;
import org.apache.drill.exec.store.parquet.FieldInfo;
import org.apache.drill.exec.store.parquet.ParquetResultListener;
import org.apache.drill.exec.store.parquet.ParquetTestProperties;
import org.apache.drill.exec.store.parquet.TestFileGenerator;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetRecordReader;
import org.apache.drill.exec.util.CallBack;
import org.apache.drill.exec.vector.BigIntVector;
import org.apache.drill.exec.vector.NullableBigIntVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import parquet.bytes.BytesInput;
import parquet.column.page.DataPageV1;
import parquet.column.page.PageReadStore;
import parquet.column.page.PageReader;
import parquet.hadoop.Footer;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.schema.MessageType;

@Ignore
public class ParquetRecordReaderTest
extends BaseTestQuery {
    private static final Logger logger = LoggerFactory.getLogger(ParquetRecordReaderTest.class);
    static final boolean VERBOSE_DEBUG = false;
    private static final int numberRowGroups = 1;
    private static final int recordsPerRowGroup = 300;
    private static int DEFAULT_BYTES_PER_PAGE = 0x100000;
    private static final String fileName = "/tmp/parquet_test_file_many_types";

    @BeforeClass
    public static void generateFile() throws Exception {
        File f = new File(fileName);
        ParquetTestProperties props = new ParquetTestProperties(1, 300, DEFAULT_BYTES_PER_PAGE, new HashMap<String, FieldInfo>());
        TestFileGenerator.populateFieldInfoMap(props);
        if (!f.exists()) {
            TestFileGenerator.generateParquetFile(fileName, props);
        }
    }

    @Test
    public void testMultipleRowGroupsAndReads3() throws Exception {
        String planName = "/parquet/parquet_scan_screen.json";
        this.testParquetFullEngineLocalPath("/parquet/parquet_scan_screen.json", fileName, 2, 1, 300);
    }

    public String getPlanForFile(String pathFileName, String parquetFileName) throws IOException {
        return Files.toString((File)FileUtils.getResourceAsFile((String)pathFileName), (Charset)Charsets.UTF_8).replaceFirst("&REPLACED_IN_PARQUET_TEST&", parquetFileName);
    }

    @Test
    public void testMultipleRowGroupsAndReads2() throws Exception {
        StringBuilder readEntries = new StringBuilder();
        int i = 3;
        for (int j = 0; j < i; ++j) {
            readEntries.append('\"');
            readEntries.append(fileName);
            readEntries.append('\"');
            if (j >= i - 1) continue;
            readEntries.append(',');
        }
        String planText = Files.toString((File)FileUtils.getResourceAsFile((String)"/parquet/parquet_scan_screen_read_entry_replace.json"), (Charset)Charsets.UTF_8).replaceFirst("&REPLACED_IN_PARQUET_TEST&", readEntries.toString());
        this.testParquetFullEngineLocalText(planText, fileName, i, 1, 300, true);
    }

    @Test
    public void testDictionaryError() throws Exception {
        this.testFull(UserBitShared.QueryType.SQL, "select L_RECEIPTDATE from dfs.`/tmp/lineitem_null_dict.parquet`", "", 1, 1, 100000, false);
    }

    @Test
    public void testNullableAgg() throws Exception {
        List<QueryDataBatch> result = ParquetRecordReaderTest.testSqlWithResults("select sum(a) as total_sum from dfs.`/tmp/parquet_with_nulls_should_sum_100000_nulls_first.parquet`");
        Assert.assertEquals((String)"Only expected one batch with data, and then the empty finishing batch.", (long)2L, (long)result.size());
        RecordBatchLoader loader = new RecordBatchLoader(ParquetRecordReaderTest.getDrillbitContext().getAllocator());
        QueryDataBatch b = result.get(0);
        loader.load(b.getHeader().getDef(), b.getData());
        VectorWrapper vw = loader.getValueAccessorById(NullableBigIntVector.class, loader.getValueVectorId(SchemaPath.getCompoundPath((String[])new String[]{"total_sum"})).getFieldIds());
        Assert.assertEquals((Object)4999950000L, (Object)vw.getValueVector().getAccessor().getObject(0));
        b.release();
        loader.clear();
    }

    @Test
    public void testNullableFilter() throws Exception {
        List<QueryDataBatch> result = ParquetRecordReaderTest.testSqlWithResults("select count(wr_return_quantity) as row_count from dfs.`/tmp/web_returns` where wr_return_quantity = 1");
        Assert.assertEquals((String)"Only expected one batch with data, and then the empty finishing batch.", (long)2L, (long)result.size());
        RecordBatchLoader loader = new RecordBatchLoader(ParquetRecordReaderTest.getDrillbitContext().getAllocator());
        QueryDataBatch b = result.get(0);
        loader.load(b.getHeader().getDef(), b.getData());
        VectorWrapper vw = loader.getValueAccessorById(BigIntVector.class, loader.getValueVectorId(SchemaPath.getCompoundPath((String[])new String[]{"row_count"})).getFieldIds());
        Assert.assertEquals((Object)3573L, (Object)vw.getValueVector().getAccessor().getObject(0));
        b.release();
        loader.clear();
    }

    @Test
    public void testFixedBinary() throws Exception {
        String readEntries = "\"/tmp/drilltest/fixed_binary.parquet\"";
        String planText = Files.toString((File)FileUtils.getResourceAsFile((String)"/parquet/parquet_scan_screen_read_entry_replace.json"), (Charset)Charsets.UTF_8).replaceFirst("&REPLACED_IN_PARQUET_TEST&", "\"/tmp/drilltest/fixed_binary.parquet\"");
        this.testParquetFullEngineLocalText(planText, fileName, 1, 1, 1000000, false);
    }

    @Test
    public void testNonNullableDictionaries() throws Exception {
        this.testFull(UserBitShared.QueryType.SQL, "select * from dfs.`/tmp/drilltest/non_nullable_dictionary.parquet`", "", 1, 1, 30000000, false);
    }

    @Test
    public void testNullableVarCharMemory() throws Exception {
        this.testFull(UserBitShared.QueryType.SQL, "select s_comment,s_suppkey from dfs.`/tmp/sf100_supplier.parquet`", "", 1, 1, 1000, false);
    }

    @Test
    public void testReadVoter() throws Exception {
        this.testFull(UserBitShared.QueryType.SQL, "select * from dfs.`/tmp/voter.parquet`", "", 1, 1, 1000, false);
    }

    @Test
    public void testDrill_1314() throws Exception {
        this.testFull(UserBitShared.QueryType.SQL, "select l_partkey from dfs.`/tmp/drill_1314.parquet`", "", 1, 1, 10000, false);
    }

    @Test
    public void testDrill_1314_all_columns() throws Exception {
        this.testFull(UserBitShared.QueryType.SQL, "select * from dfs.`/tmp/drill_1314.parquet`", "", 1, 1, 10000, false);
    }

    @Test
    public void testDictionaryError_419() throws Exception {
        this.testFull(UserBitShared.QueryType.SQL, "select c_address from dfs.`/tmp/customer_snappyimpala_drill_419.parquet`", "", 1, 1, 150000, false);
    }

    @Test
    public void testNonExistentColumn() throws Exception {
        this.testFull(UserBitShared.QueryType.SQL, "select non_existent_column from cp.`tpch/nation.parquet`", "", 1, 1, 150000, false);
    }

    @Test
    public void testNonExistentColumnLargeFile() throws Exception {
        this.testFull(UserBitShared.QueryType.SQL, "select non_existent_column, non_existent_col_2 from dfs.`/tmp/customer.dict.parquet`", "", 1, 1, 150000, false);
    }

    @Test
    public void testNonExistentColumnsSomePresentColumnsLargeFile() throws Exception {
        this.testFull(UserBitShared.QueryType.SQL, "select cust_key, address,  non_existent_column, non_existent_col_2 from dfs.`/tmp/customer.dict.parquet`", "", 1, 1, 150000, false);
    }

    @Ignore
    @Test
    public void testTPCHPerformace_SF1() throws Exception {
        this.testFull(UserBitShared.QueryType.SQL, "select * from dfs.`/tmp/orders_part-m-00001.parquet`", "", 1, 1, 150000, false);
    }

    @Test
    public void testLocalDistributed() throws Exception {
        String planName = "/parquet/parquet_scan_union_screen_physical.json";
        this.testParquetFullEngineLocalTextDistributed("/parquet/parquet_scan_union_screen_physical.json", fileName, 1, 1, 300);
    }

    @Test
    @Ignore
    public void testRemoteDistributed() throws Exception {
        String planName = "/parquet/parquet_scan_union_screen_physical.json";
        this.testParquetFullEngineRemote("/parquet/parquet_scan_union_screen_physical.json", fileName, 1, 1, 300);
    }

    public void testParquetFullEngineLocalPath(String planFileName, String filename, int numberOfTimesRead, int numberOfRowGroups, int recordsPerRowGroup) throws Exception {
        this.testParquetFullEngineLocalText(Files.toString((File)FileUtils.getResourceAsFile((String)planFileName), (Charset)Charsets.UTF_8), filename, numberOfTimesRead, numberOfRowGroups, recordsPerRowGroup, true);
    }

    public void testParquetFullEngineLocalText(String planText, String filename, int numberOfTimesRead, int numberOfRowGroups, int recordsPerRowGroup, boolean testValues) throws Exception {
        this.testFull(UserBitShared.QueryType.LOGICAL, planText, filename, numberOfTimesRead, numberOfRowGroups, recordsPerRowGroup, testValues);
    }

    private void testFull(UserBitShared.QueryType type, String planText, String filename, int numberOfTimesRead, int numberOfRowGroups, int recordsPerRowGroup, boolean testValues) throws Exception {
        HashMap<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
        ParquetTestProperties props = new ParquetTestProperties(1, recordsPerRowGroup, DEFAULT_BYTES_PER_PAGE, fields);
        TestFileGenerator.populateFieldInfoMap(props);
        ParquetResultListener resultListener = new ParquetResultListener(ParquetRecordReaderTest.getAllocator(), props, numberOfTimesRead, testValues);
        Stopwatch watch = new Stopwatch().start();
        ParquetRecordReaderTest.testWithListener(type, planText, resultListener);
        resultListener.getResults();
        System.out.println(String.format("Took %d ms to run query", watch.elapsed(TimeUnit.MILLISECONDS)));
    }

    public void testParquetFullEngineLocalTextDistributed(String planName, String filename, int numberOfTimesRead, int numberOfRowGroups, int recordsPerRowGroup) throws Exception {
        String planText = Files.toString((File)FileUtils.getResourceAsFile((String)planName), (Charset)Charsets.UTF_8);
        this.testFull(UserBitShared.QueryType.PHYSICAL, planText, filename, numberOfTimesRead, numberOfRowGroups, recordsPerRowGroup, true);
    }

    public String pad(String value, int length) {
        return this.pad(value, length, " ");
    }

    public String pad(String value, int length, String with) {
        StringBuilder result = new StringBuilder(length);
        result.append(value);
        while (result.length() < length) {
            result.insert(0, with);
        }
        return result.toString();
    }

    public void testParquetFullEngineRemote(String plan, String filename, int numberOfTimesRead, int numberOfRowGroups, int recordsPerRowGroup) throws Exception {
        HashMap<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
        ParquetTestProperties props = new ParquetTestProperties(1, recordsPerRowGroup, DEFAULT_BYTES_PER_PAGE, fields);
        TestFileGenerator.populateFieldInfoMap(props);
        ParquetResultListener resultListener = new ParquetResultListener(ParquetRecordReaderTest.getAllocator(), props, numberOfTimesRead, true);
        ParquetRecordReaderTest.testWithListener(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)plan), (Charset)Charsets.UTF_8), resultListener);
        resultListener.getResults();
    }

    private void validateFooters(List<Footer> metadata) {
        logger.debug(metadata.toString());
        Assert.assertEquals((long)3L, (long)metadata.size());
        for (Footer footer : metadata) {
            File file = new File(footer.getFile().toUri());
            Assert.assertTrue((String)file.getName(), (boolean)file.getName().startsWith("part"));
            Assert.assertTrue((String)file.getPath(), (boolean)file.exists());
            ParquetMetadata parquetMetadata = footer.getParquetMetadata();
            Assert.assertEquals((long)2L, (long)parquetMetadata.getBlocks().size());
            Map keyValueMetaData = parquetMetadata.getFileMetaData().getKeyValueMetaData();
            Assert.assertEquals((Object)"bar", keyValueMetaData.get("foo"));
            Assert.assertEquals((Object)footer.getFile().getName(), keyValueMetaData.get(footer.getFile().getName()));
        }
    }

    private void validateContains(MessageType schema, PageReadStore pages, String[] path, int values, BytesInput bytes) throws IOException {
        PageReader pageReader = pages.getPageReader(schema.getColumnDescription(path));
        DataPageV1 page = (DataPageV1)pageReader.readPage();
        Assert.assertEquals((long)values, (long)page.getValueCount());
        Assert.assertArrayEquals((byte[])bytes.toByteArray(), (byte[])page.getBytes().toByteArray());
    }

    @Test
    public void testMultipleRowGroups() throws Exception {
        HashMap<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
        ParquetTestProperties props = new ParquetTestProperties(2, 300, DEFAULT_BYTES_PER_PAGE, fields);
        TestFileGenerator.populateFieldInfoMap(props);
        this.testParquetFullEngineEventBased(true, "/parquet/parquet_scan_screen.json", "/tmp/test.parquet", 1, props);
    }

    @Test
    public void testNullableColumns() throws Exception {
        HashMap<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
        ParquetTestProperties props = new ParquetTestProperties(1, 1500000, DEFAULT_BYTES_PER_PAGE, fields);
        Object[] boolVals = new Object[]{true, null, null};
        props.fields.put("a", new FieldInfo("boolean", "a", 1, boolVals, TypeProtos.MinorType.BIT, props));
        this.testParquetFullEngineEventBased(false, "/parquet/parquet_nullable.json", "/tmp/nullable_test.parquet", 1, props);
    }

    @Test
    public void testNullableColumnsVarLen() throws Exception {
        HashMap<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
        ParquetTestProperties props = new ParquetTestProperties(1, 300000, DEFAULT_BYTES_PER_PAGE, fields);
        byte[] val = new byte[]{98};
        byte[] val2 = new byte[]{98, 50};
        byte[] val3 = new byte[]{98, 51};
        byte[] val4 = new byte[]{108, 111, 110, 103, 101, 114, 32, 115, 116, 114, 105, 110, 103};
        Object[] byteArrayVals = new Object[]{val, val2, val4};
        props.fields.put("a", new FieldInfo("boolean", "a", 1, byteArrayVals, TypeProtos.MinorType.BIT, props));
        this.testParquetFullEngineEventBased(false, "/parquet/parquet_nullable_varlen.json", "/tmp/nullable_varlen.parquet", 1, props);
        HashMap<String, FieldInfo> fields2 = new HashMap<String, FieldInfo>();
        Object[] textVals = new Object[]{new Text("b"), new Text("b2"), new Text("b3")};
        ParquetTestProperties props2 = new ParquetTestProperties(1, 30000, DEFAULT_BYTES_PER_PAGE, fields2);
        props2.fields.put("a", new FieldInfo("boolean", "a", 1, textVals, TypeProtos.MinorType.BIT, props2));
        this.testParquetFullEngineEventBased(false, "/parquet/parquet_scan_screen_read_entry_replace.json", "\"/tmp/varLen.parquet/a\"", "unused", 1, props2);
    }

    @Test
    public void testFileWithNulls() throws Exception {
        HashMap<String, FieldInfo> fields3 = new HashMap<String, FieldInfo>();
        ParquetTestProperties props3 = new ParquetTestProperties(1, 3000, DEFAULT_BYTES_PER_PAGE, fields3);
        Object[] valuesWithNull = new Object[]{new Text(""), new Text("longer string"), null};
        props3.fields.put("a", new FieldInfo("boolean", "a", 1, valuesWithNull, TypeProtos.MinorType.BIT, props3));
        this.testParquetFullEngineEventBased(false, "/parquet/parquet_scan_screen_read_entry_replace.json", "\"/tmp/nullable_with_nulls.parquet\"", "unused", 1, props3);
    }

    @Test
    public void testDictionaryEncoding() throws Exception {
        HashMap<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
        ParquetTestProperties props = new ParquetTestProperties(1, 25, DEFAULT_BYTES_PER_PAGE, fields);
        Object boolVals = null;
        props.fields.put("n_name", null);
        props.fields.put("n_nationkey", null);
        props.fields.put("n_regionkey", null);
        props.fields.put("n_comment", null);
        this.testParquetFullEngineEventBased(false, false, "/parquet/parquet_scan_screen_read_entry_replace.json", "\"/tmp/nation_dictionary_fail.parquet\"", "unused", 1, props, UserBitShared.QueryType.LOGICAL);
        fields = new HashMap();
        props = new ParquetTestProperties(1, 5, DEFAULT_BYTES_PER_PAGE, fields);
        props.fields.put("employee_id", null);
        props.fields.put("name", null);
        props.fields.put("role", null);
        props.fields.put("phone", null);
        props.fields.put("password_hash", null);
        props.fields.put("gender_male", null);
        props.fields.put("height", null);
        props.fields.put("hair_thickness", null);
        this.testParquetFullEngineEventBased(false, false, "/parquet/parquet_scan_screen_read_entry_replace.json", "\"/tmp/employees_5_16_14.parquet\"", "unused", 1, props, UserBitShared.QueryType.LOGICAL);
    }

    @Test
    public void testMultipleRowGroupsAndReads() throws Exception {
        HashMap<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
        ParquetTestProperties props = new ParquetTestProperties(4, 3000, DEFAULT_BYTES_PER_PAGE, fields);
        TestFileGenerator.populateFieldInfoMap(props);
        String readEntries = "";
        int i = 3;
        for (int j = 0; j < i; ++j) {
            readEntries = readEntries + "\"/tmp/test.parquet\"";
            if (j >= i - 1) continue;
            readEntries = readEntries + ",";
        }
        this.testParquetFullEngineEventBased(true, "/parquet/parquet_scan_screen_read_entry_replace.json", readEntries, "/tmp/test.parquet", i, props);
    }

    @Test
    public void testReadError_Drill_901() throws Exception {
        HashMap<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
        ParquetTestProperties props = new ParquetTestProperties(1, 60175, DEFAULT_BYTES_PER_PAGE, fields);
        this.testParquetFullEngineEventBased(false, false, "/parquet/par_writer_test.json", null, "unused, no file is generated", 1, props, UserBitShared.QueryType.PHYSICAL);
    }

    @Test
    public void testReadError_Drill_839() throws Exception {
        HashMap<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
        ParquetTestProperties props = new ParquetTestProperties(1, 150000, DEFAULT_BYTES_PER_PAGE, fields);
        String readEntries = "\"/tmp/customer_nonull.parquet\"";
        this.testParquetFullEngineEventBased(false, false, "/parquet/parquet_scan_screen_read_entry_replace.json", readEntries, "unused, no file is generated", 1, props, UserBitShared.QueryType.LOGICAL);
    }

    @Test
    public void testReadBug_Drill_418() throws Exception {
        HashMap<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
        ParquetTestProperties props = new ParquetTestProperties(1, 150000, DEFAULT_BYTES_PER_PAGE, fields);
        TestFileGenerator.populateDrill_418_fields(props);
        String readEntries = "\"/tmp/customer.plain.parquet\"";
        this.testParquetFullEngineEventBased(false, false, "/parquet/parquet_scan_screen_read_entry_replace.json", readEntries, "unused, no file is generated", 1, props, UserBitShared.QueryType.LOGICAL);
    }

    @Test
    public void testMultipleRowGroupsAndReadsPigError() throws Exception {
        HashMap<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
        ParquetTestProperties props = new ParquetTestProperties(1, 1500000, DEFAULT_BYTES_PER_PAGE, fields);
        TestFileGenerator.populatePigTPCHCustomerFields(props);
        String readEntries = "\"/tmp/tpc-h/customer\"";
        this.testParquetFullEngineEventBased(false, false, "/parquet/parquet_scan_screen_read_entry_replace.json", readEntries, "unused, no file is generated", 1, props, UserBitShared.QueryType.LOGICAL);
        fields = new HashMap();
        props = new ParquetTestProperties(1, 100000, DEFAULT_BYTES_PER_PAGE, fields);
        TestFileGenerator.populatePigTPCHSupplierFields(props);
        readEntries = "\"/tmp/tpc-h/supplier\"";
        this.testParquetFullEngineEventBased(false, false, "/parquet/parquet_scan_screen_read_entry_replace.json", readEntries, "unused, no file is generated", 1, props, UserBitShared.QueryType.LOGICAL);
    }

    @Test
    public void test958_sql() throws Exception {
        this.testFull(UserBitShared.QueryType.SQL, "select * from dfs.`/tmp/store_sales`", "", 1, 1, 30000000, false);
    }

    @Test
    public void drill_958bugTest() throws Exception {
        HashMap<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
        ParquetTestProperties props = new ParquetTestProperties(1, 2880404, DEFAULT_BYTES_PER_PAGE, fields);
        TestFileGenerator.populatePigTPCHCustomerFields(props);
        String readEntries = "\"/tmp/store_sales\"";
        this.testParquetFullEngineEventBased(false, false, "/parquet/parquet_scan_screen_read_entry_replace.json", readEntries, "unused, no file is generated", 1, props, UserBitShared.QueryType.LOGICAL);
    }

    @Test
    public void testMultipleRowGroupsEvent() throws Exception {
        HashMap<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
        ParquetTestProperties props = new ParquetTestProperties(2, 300, DEFAULT_BYTES_PER_PAGE, fields);
        TestFileGenerator.populateFieldInfoMap(props);
        this.testParquetFullEngineEventBased(true, "/parquet/parquet_scan_screen.json", "/tmp/test.parquet", 1, props);
    }

    @Test
    public void testSelectColumnRead() throws Exception {
        HashMap<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
        ParquetTestProperties props = new ParquetTestProperties(4, 3000, DEFAULT_BYTES_PER_PAGE, fields);
        TestFileGenerator.populateFieldInfoMap(props);
        TestFileGenerator.generateParquetFile("/tmp/test.parquet", props);
        fields.clear();
        props = new ParquetTestProperties(4, 3000, DEFAULT_BYTES_PER_PAGE, fields);
        props.fields.put("integer", new FieldInfo("int32", "integer", 32, TestFileGenerator.intVals, TypeProtos.MinorType.INT, props));
        props.fields.put("bigInt", new FieldInfo("int64", "bigInt", 64, TestFileGenerator.longVals, TypeProtos.MinorType.BIGINT, props));
        props.fields.put("bin", new FieldInfo("binary", "bin", -1, TestFileGenerator.binVals, TypeProtos.MinorType.VARBINARY, props));
        props.fields.put("bin2", new FieldInfo("binary", "bin2", -1, TestFileGenerator.bin2Vals, TypeProtos.MinorType.VARBINARY, props));
        this.testParquetFullEngineEventBased(true, false, "/parquet/parquet_selective_column_read.json", null, "/tmp/test.parquet", 1, props, UserBitShared.QueryType.PHYSICAL);
    }

    @Test
    @Ignore
    public void testPerformance(@Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Exception {
        DrillConfig c = DrillConfig.create();
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        String fileName = "/tmp/parquet_test_performance.parquet";
        HashMap<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
        ParquetTestProperties props = new ParquetTestProperties(1, 20000000, DEFAULT_BYTES_PER_PAGE, fields);
        TestFileGenerator.populateFieldInfoMap(props);
        Configuration dfsConfig = new Configuration();
        List footers = ParquetFileReader.readFooters((Configuration)dfsConfig, (Path)new Path("/tmp/parquet_test_performance.parquet"));
        Footer f = (Footer)footers.iterator().next();
        ArrayList columns = Lists.newArrayList();
        columns.add(new SchemaPath("_MAP.integer", ExpressionPosition.UNKNOWN));
        columns.add(new SchemaPath("_MAP.bigInt", ExpressionPosition.UNKNOWN));
        columns.add(new SchemaPath("_MAP.f", ExpressionPosition.UNKNOWN));
        columns.add(new SchemaPath("_MAP.d", ExpressionPosition.UNKNOWN));
        columns.add(new SchemaPath("_MAP.b", ExpressionPosition.UNKNOWN));
        columns.add(new SchemaPath("_MAP.bin", ExpressionPosition.UNKNOWN));
        columns.add(new SchemaPath("_MAP.bin2", ExpressionPosition.UNKNOWN));
        int totalRowCount = 0;
        CachedSingleFileSystem fs = new CachedSingleFileSystem("/tmp/parquet_test_performance.parquet");
        BufferAllocator allocator = RootAllocatorFactory.newRoot((DrillConfig)c);
        for (int i = 0; i < 25; ++i) {
            ParquetRecordReader rr = new ParquetRecordReader(context, 256000L, "/tmp/parquet_test_performance.parquet", 0, (FileSystem)fs, new DirectCodecFactory(dfsConfig, allocator), f.getParquetMetadata(), (List)columns);
            TestOutputMutator mutator = new TestOutputMutator(allocator);
            rr.setup(null, (OutputMutator)mutator);
            Stopwatch watch = new Stopwatch();
            watch.start();
            int rowCount = 0;
            while ((rowCount = rr.next()) > 0) {
                totalRowCount += rowCount;
            }
            System.out.println(String.format("Time completed: %s. ", watch.elapsed(TimeUnit.MILLISECONDS)));
            rr.close();
        }
        allocator.close();
        System.out.println(String.format("Total row count %s", totalRowCount));
    }

    public void testParquetFullEngineEventBased(boolean generateNew, String plan, String readEntries, String filename, int numberOfTimesRead, ParquetTestProperties props) throws Exception {
        this.testParquetFullEngineEventBased(true, generateNew, plan, readEntries, filename, numberOfTimesRead, props, UserBitShared.QueryType.LOGICAL);
    }

    public void testParquetFullEngineEventBased(boolean generateNew, String plan, String filename, int numberOfTimesRead, ParquetTestProperties props) throws Exception {
        this.testParquetFullEngineEventBased(true, generateNew, plan, null, filename, numberOfTimesRead, props, UserBitShared.QueryType.LOGICAL);
    }

    public void testParquetFullEngineEventBased(boolean testValues, boolean generateNew, String plan, String readEntries, String filename, int numberOfTimesRead, ParquetTestProperties props, UserBitShared.QueryType queryType) throws Exception {
        if (generateNew) {
            TestFileGenerator.generateParquetFile(filename, props);
        }
        ParquetResultListener resultListener = new ParquetResultListener(ParquetRecordReaderTest.getAllocator(), props, numberOfTimesRead, testValues);
        long C = System.nanoTime();
        String planText = Files.toString((File)FileUtils.getResourceAsFile((String)plan), (Charset)Charsets.UTF_8);
        if (readEntries != null) {
            planText = planText.replaceFirst("&REPLACED_IN_PARQUET_TEST&", readEntries);
        }
        ParquetRecordReaderTest.testWithListener(queryType, planText, resultListener);
        resultListener.getResults();
        long D = System.nanoTime();
        System.out.println(String.format("Took %f s to run query", (double)(D - C) / 1.0E9));
    }

    private static class MockOutputMutator
    implements OutputMutator {
        private final List<MaterializedField> removedFields = Lists.newArrayList();
        private final List<ValueVector> addFields = Lists.newArrayList();

        private MockOutputMutator() {
        }

        List<MaterializedField> getRemovedFields() {
            return this.removedFields;
        }

        List<ValueVector> getAddFields() {
            return this.addFields;
        }

        public <T extends ValueVector> T addField(MaterializedField field, Class<T> clazz) throws SchemaChangeException {
            return null;
        }

        public void allocate(int recordCount) {
        }

        public boolean isNewSchema() {
            return false;
        }

        public DrillBuf getManagedBuffer() {
            return allocator.buffer(255);
        }

        public CallBack getCallBack() {
            return null;
        }
    }
}

