/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.store.parquet.ParquetTestProperties;

public class FieldInfo {
    final String parquetType;
    final String name;
    final int bitLength;
    final int numberOfPages;
    final Object[] values;
    final TypeProtos.MinorType type;

    FieldInfo(String parquetType, String name, int bitLength, Object[] values, TypeProtos.MinorType type, ParquetTestProperties props) {
        this.parquetType = parquetType;
        this.name = name;
        this.bitLength = bitLength;
        this.numberOfPages = Math.max(1, (int)Math.ceil((double)((long)props.recordsPerRowGroup * (long)bitLength) / 8.0 / (double)props.bytesPerPage));
        if (values.length != 3) {
            throw new IllegalStateException("generator is designed to use 3 values");
        }
        this.values = values;
        this.type = type;
    }
}

