/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.json;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.proto.UserBitShared;
import org.junit.Assert;
import org.junit.Test;

public class TestJsonRecordReader
extends BaseTestQuery {
    @Test
    public void testComplexJsonInput() throws Exception {
        TestJsonRecordReader.test("select `integer`, x['y'] as x1, x['y'] as x2, z[0], z[0]['orange'], z[1]['pink']  from cp.`jsoninput/input2.json` limit 10 ");
    }

    @Test
    public void testContainingArray() throws Exception {
        TestJsonRecordReader.test("select * from dfs.`${WORKING_PATH}/src/test/resources/store/json/listdoc.json`");
    }

    @Test
    public void testComplexMultipleTimes() throws Exception {
        for (int i = 0; i < 5; ++i) {
            TestJsonRecordReader.test("select * from cp.`join/merge_join.json`");
        }
    }

    @Test
    public void trySimpleQueryWithLimit() throws Exception {
        TestJsonRecordReader.test("select * from cp.`limit/test1.json` limit 10");
    }

    @Test
    public void testNestedArrayInRepeatedMap() throws Exception {
        TestJsonRecordReader.test("select a[0].b[0] from cp.`jsoninput/nestedArray.json`");
        TestJsonRecordReader.test("select a[0].b[1] from cp.`jsoninput/nestedArray.json`");
        TestJsonRecordReader.test("select a[1].b[1] from cp.`jsoninput/nestedArray.json`");
    }

    @Test
    public void testEmptyMapDoesNotFailValueCapacityCheck() throws Exception {
        String sql = "select * from cp.`store/json/value-capacity.json`";
        TestJsonRecordReader.test("select * from cp.`store/json/value-capacity.json`");
    }

    @Test
    public void testEnableAllTextMode() throws Exception {
        TestJsonRecordReader.testNoResult("alter session set `store.json.all_text_mode`= true", new Object[0]);
        TestJsonRecordReader.test("select * from cp.`jsoninput/big_numeric.json`");
        TestJsonRecordReader.testNoResult("alter session set `store.json.all_text_mode`= false", new Object[0]);
    }

    @Test
    public void testExceptionHandling() throws Exception {
        try {
            TestJsonRecordReader.test("select * from cp.`jsoninput/DRILL-2350.json`");
        }
        catch (UserException e) {
            Assert.assertEquals((Object)UserBitShared.DrillPBError.ErrorType.UNSUPPORTED_OPERATION, (Object)e.getOrCreatePBError(false).getErrorType());
            String s = e.getMessage();
            Assert.assertEquals((String)"Expected Unsupported Operation Exception.", (Object)true, (Object)s.contains("Drill does not support lists of different types."));
        }
    }

    @Test
    public void testJsonWithNulls1() throws Exception {
        String query = "select * from cp.`jsoninput/twitter_43.json`";
        TestJsonRecordReader.testBuilder().sqlQuery("select * from cp.`jsoninput/twitter_43.json`").unOrdered().jsonBaselineFile("jsoninput/drill-1832-1-result.json").go();
    }

    @Test
    public void testJsonWithNulls2() throws Exception {
        String query = "select SUM(1) as `sum_Number_of_Records_ok` from cp.`/jsoninput/twitter_43.json` having (COUNT(1) > 0)";
        TestJsonRecordReader.testBuilder().sqlQuery("select SUM(1) as `sum_Number_of_Records_ok` from cp.`/jsoninput/twitter_43.json` having (COUNT(1) > 0)").unOrdered().jsonBaselineFile("jsoninput/drill-1832-2-result.json").go();
    }

    @Test
    public void testMixedNumberTypes() throws Exception {
        try {
            TestJsonRecordReader.testBuilder().sqlQuery("select * from cp.`jsoninput/mixed_number_types.json`").unOrdered().jsonBaselineFile("jsoninput/mixed_number_types.json").build().run();
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("DATA_READ ERROR: Error parsing JSON - You tried to write a BigInt type when you are using a ValueWriter of type NullableFloat8WriterImpl."));
            return;
        }
        throw new Exception("Mixed number types verification failed, expected failure on conflicting number types.");
    }

    @Test
    public void testMixedNumberTypesInAllTextMode() throws Exception {
        TestJsonRecordReader.testNoResult("alter session set `store.json.all_text_mode`= true", new Object[0]);
        TestJsonRecordReader.testBuilder().sqlQuery("select * from cp.`jsoninput/mixed_number_types.json`").unOrdered().baselineColumns("a").baselineValues("5.2").baselineValues("6").build().run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMixedNumberTypesWhenReadingNumbersAsDouble() throws Exception {
        try {
            TestJsonRecordReader.testNoResult("alter session set `store.json.read_numbers_as_double`= true", new Object[0]);
            TestJsonRecordReader.testBuilder().sqlQuery("select * from cp.`jsoninput/mixed_number_types.json`").unOrdered().baselineColumns("a").baselineValues(5.2).baselineValues(6.0).build().run();
        }
        finally {
            TestJsonRecordReader.testNoResult("alter session set `store.json.read_numbers_as_double`= false", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void drill_3353() throws Exception {
        try {
            TestJsonRecordReader.testNoResult("alter session set `store.json.all_text_mode` = true", new Object[0]);
            TestJsonRecordReader.test("create table dfs_test.tmp.drill_3353 as select a from dfs.`${WORKING_PATH}/src/test/resources/jsoninput/drill_3353` where e = true");
            String query = "select t.a.d cnt from dfs_test.tmp.drill_3353 t where t.a.d is not null";
            TestJsonRecordReader.test(query);
            TestJsonRecordReader.testBuilder().sqlQuery(query).unOrdered().baselineColumns("cnt").baselineValues("1").go();
        }
        finally {
            TestJsonRecordReader.testNoResult("alter session set `store.json.all_text_mode` = false", new Object[0]);
        }
    }

    @Test
    public void testNestedFilter() throws Exception {
        String query = "select a from cp.`jsoninput/nestedFilter.json` t where t.a.b = 1";
        String baselineQuery = "select * from cp.`jsoninput/nestedFilter.json` t where t.a.b = 1";
        TestJsonRecordReader.testBuilder().sqlQuery(query).unOrdered().sqlBaselineQuery(baselineQuery).go();
    }
}

