/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.ischema;

import org.apache.drill.PlanTestBase;
import org.junit.Assert;
import org.junit.Test;

public class TestInfoSchemaFilterPushDown
extends PlanTestBase {
    @Test
    public void testFilterPushdown_Equal() throws Exception {
        String query = "SELECT * FROM INFORMATION_SCHEMA.`TABLES` WHERE TABLE_SCHEMA='INFORMATION_SCHEMA'";
        String scan = "Scan(groupscan=[TABLES, filter=equal(Field=TABLE_SCHEMA,Literal=INFORMATION_SCHEMA)])";
        this.testHelper("SELECT * FROM INFORMATION_SCHEMA.`TABLES` WHERE TABLE_SCHEMA='INFORMATION_SCHEMA'", "Scan(groupscan=[TABLES, filter=equal(Field=TABLE_SCHEMA,Literal=INFORMATION_SCHEMA)])", false);
    }

    @Test
    public void testFilterPushdown_NonEqual() throws Exception {
        String query = "SELECT * FROM INFORMATION_SCHEMA.`TABLES` WHERE TABLE_SCHEMA <> 'INFORMATION_SCHEMA'";
        String scan = "Scan(groupscan=[TABLES, filter=not_equal(Field=TABLE_SCHEMA,Literal=INFORMATION_SCHEMA)])";
        this.testHelper("SELECT * FROM INFORMATION_SCHEMA.`TABLES` WHERE TABLE_SCHEMA <> 'INFORMATION_SCHEMA'", "Scan(groupscan=[TABLES, filter=not_equal(Field=TABLE_SCHEMA,Literal=INFORMATION_SCHEMA)])", false);
    }

    @Test
    public void testFilterPushdown_Like() throws Exception {
        String query = "SELECT * FROM INFORMATION_SCHEMA.`TABLES` WHERE TABLE_SCHEMA LIKE '%SCH%'";
        String scan = "Scan(groupscan=[TABLES, filter=like(Field=TABLE_SCHEMA,Literal=%SCH%)])";
        this.testHelper("SELECT * FROM INFORMATION_SCHEMA.`TABLES` WHERE TABLE_SCHEMA LIKE '%SCH%'", "Scan(groupscan=[TABLES, filter=like(Field=TABLE_SCHEMA,Literal=%SCH%)])", false);
    }

    @Test
    public void testFilterPushdown_And() throws Exception {
        String query = "SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'sys' AND TABLE_NAME <> 'version'";
        String scan = "Scan(groupscan=[COLUMNS, filter=booleanand(equal(Field=TABLE_SCHEMA,Literal=sys),not_equal(Field=TABLE_NAME,Literal=version))])";
        this.testHelper("SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'sys' AND TABLE_NAME <> 'version'", "Scan(groupscan=[COLUMNS, filter=booleanand(equal(Field=TABLE_SCHEMA,Literal=sys),not_equal(Field=TABLE_NAME,Literal=version))])", false);
    }

    @Test
    public void testFilterPushdown_Or() throws Exception {
        String query = "SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'sys' OR TABLE_NAME <> 'version' OR TABLE_SCHEMA like '%sdfgjk%'";
        String scan = "Scan(groupscan=[COLUMNS, filter=booleanor(equal(Field=TABLE_SCHEMA,Literal=sys),not_equal(Field=TABLE_NAME,Literal=version),like(Field=TABLE_SCHEMA,Literal=%sdfgjk%))])";
        this.testHelper("SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'sys' OR TABLE_NAME <> 'version' OR TABLE_SCHEMA like '%sdfgjk%'", "Scan(groupscan=[COLUMNS, filter=booleanor(equal(Field=TABLE_SCHEMA,Literal=sys),not_equal(Field=TABLE_NAME,Literal=version),like(Field=TABLE_SCHEMA,Literal=%sdfgjk%))])", false);
    }

    @Test
    public void testFilterPushDownWithProject_Equal() throws Exception {
        String query = "SELECT COLUMN_NAME from INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_SCHEMA = 'INFORMATION_SCHEMA'";
        String scan = "Scan(groupscan=[COLUMNS, filter=equal(Field=TABLE_SCHEMA,Literal=INFORMATION_SCHEMA)])";
        this.testHelper("SELECT COLUMN_NAME from INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_SCHEMA = 'INFORMATION_SCHEMA'", "Scan(groupscan=[COLUMNS, filter=equal(Field=TABLE_SCHEMA,Literal=INFORMATION_SCHEMA)])", false);
    }

    @Test
    public void testFilterPushDownWithProject_NotEqual() throws Exception {
        String query = "SELECT COLUMN_NAME from INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_NAME <> 'TABLES'";
        String scan = "Scan(groupscan=[COLUMNS, filter=not_equal(Field=TABLE_NAME,Literal=TABLES)])";
        this.testHelper("SELECT COLUMN_NAME from INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_NAME <> 'TABLES'", "Scan(groupscan=[COLUMNS, filter=not_equal(Field=TABLE_NAME,Literal=TABLES)])", false);
    }

    @Test
    public void testFilterPushDownWithProject_Like() throws Exception {
        String query = "SELECT COLUMN_NAME from INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_NAME LIKE '%BL%'";
        String scan = "Scan(groupscan=[COLUMNS, filter=like(Field=TABLE_NAME,Literal=%BL%)])";
        this.testHelper("SELECT COLUMN_NAME from INFORMATION_SCHEMA.`COLUMNS` WHERE TABLE_NAME LIKE '%BL%'", "Scan(groupscan=[COLUMNS, filter=like(Field=TABLE_NAME,Literal=%BL%)])", false);
    }

    @Test
    public void testPartialFilterPushDownWithProject() throws Exception {
        String query = "SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'sys' AND TABLE_NAME = 'version' AND COLUMN_NAME like 'commit%s'";
        String scan = "Scan(groupscan=[COLUMNS, filter=booleanand(equal(Field=TABLE_SCHEMA,Literal=sys),equal(Field=TABLE_NAME,Literal=version))])";
        this.testHelper("SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'sys' AND TABLE_NAME = 'version' AND COLUMN_NAME like 'commit%s'", "Scan(groupscan=[COLUMNS, filter=booleanand(equal(Field=TABLE_SCHEMA,Literal=sys),equal(Field=TABLE_NAME,Literal=version))])", true);
    }

    private void testHelper(String query, String filterInScan, boolean filterPrelExpected) throws Exception {
        String plan = TestInfoSchemaFilterPushDown.getPlanInString("EXPLAIN PLAN FOR " + query, "text");
        if (!filterPrelExpected) {
            Assert.assertFalse((boolean)plan.contains("Filter("));
        } else {
            Assert.assertTrue((boolean)plan.contains("Filter("));
        }
        Assert.assertTrue((boolean)plan.contains(filterInScan));
        TestInfoSchemaFilterPushDown.test(query);
    }
}

