/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import org.apache.drill.exec.ops.OpProfileDef;
import org.apache.drill.exec.ops.OperatorStats;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDrillFileSystem {
    private static String tempFilePath;

    @BeforeClass
    public static void createTempFile() throws Exception {
        boolean success;
        File tempFile;
        while (!(tempFile = File.createTempFile("drillFSTest", ".txt")).exists() || !(success = tempFile.delete())) {
        }
        PrintWriter printWriter = new PrintWriter(tempFile);
        for (int i = 1; i <= 200000; ++i) {
            printWriter.println(String.format("%d, key_%d", i, i));
        }
        printWriter.close();
        tempFilePath = tempFile.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIOStats() throws Exception {
        DrillFileSystem dfs = null;
        InputStream is = null;
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        OpProfileDef profileDef = new OpProfileDef(0, 0, 0);
        OperatorStats stats = new OperatorStats(profileDef, null);
        stats.startProcessing();
        try {
            dfs = new DrillFileSystem(conf, stats);
            is = dfs.open(new Path(tempFilePath));
            byte[] buf = new byte[8000];
            while (is.read(buf, 0, buf.length) != -1) {
            }
        }
        finally {
            stats.stopProcessing();
            if (is != null) {
                is.close();
            }
            if (dfs != null) {
                dfs.close();
            }
        }
        UserBitShared.OperatorProfile operatorProfile = stats.getProfile();
        Assert.assertTrue((String)"Expected wait time is non-zero, but got zero wait time", (operatorProfile.getWaitNanos() > 0L ? 1 : 0) != 0);
    }

    @AfterClass
    public static void deleteTempFile() throws Exception {
        new File(tempFilePath).delete();
    }
}

