/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.avro;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;

public class AvroTestUtil {
    public static final int RECORD_COUNT = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateSimplePrimitiveSchema_NoNullValues() throws Exception {
        Schema schema = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"AvroRecordReaderTest").namespace("org.apache.drill.exec.store.avro")).fields().name("a_string").type().stringType().noDefault().name("b_int").type().intType().noDefault().name("c_long").type().longType().noDefault().name("d_float").type().floatType().noDefault().name("e_double").type().doubleType().noDefault().name("f_bytes").type().bytesType().noDefault().name("g_null").type().nullType().noDefault().name("h_boolean").type().booleanType().noDefault().endRecord();
        File file = File.createTempFile("avro-primitive-test", ".avro");
        file.deleteOnExit();
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));){
            writer.create(schema, file);
            ByteBuffer bb = ByteBuffer.allocate(1);
            bb.put(0, (byte)1);
            for (int i = 0; i < 10; ++i) {
                GenericData.Record record = new GenericData.Record(schema);
                record.put("a_string", (Object)("a_" + i));
                record.put("b_int", (Object)i);
                record.put("c_long", (Object)i);
                record.put("d_float", (Object)Float.valueOf(i));
                record.put("e_double", (Object)i);
                record.put("f_bytes", (Object)bb);
                record.put("g_null", null);
                record.put("h_boolean", (Object)(i % 2 == 0 ? 1 : 0));
                writer.append((Object)record);
            }
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateUnionSchema_WithNullValues() throws Exception {
        Schema schema = (Schema)((SchemaBuilder.FieldAssembler)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"AvroRecordReaderTest").namespace("org.apache.drill.exec.store.avro")).fields().name("a_string").type().stringType().noDefault().name("b_int").type().intType().noDefault().name("c_long").type().longType().noDefault().name("d_float").type().floatType().noDefault().name("e_double").type().doubleType().noDefault().name("f_bytes").type().bytesType().noDefault().name("g_null").type().nullType().noDefault().name("h_boolean").type().booleanType().noDefault().name("i_union").type().optional().doubleType()).endRecord();
        File file = File.createTempFile("avro-primitive-test", ".avro");
        file.deleteOnExit();
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));){
            writer.create(schema, file);
            ByteBuffer bb = ByteBuffer.allocate(1);
            bb.put(0, (byte)1);
            for (int i = 0; i < 10; ++i) {
                GenericData.Record record = new GenericData.Record(schema);
                record.put("a_string", (Object)("a_" + i));
                record.put("b_int", (Object)i);
                record.put("c_long", (Object)i);
                record.put("d_float", (Object)Float.valueOf(i));
                record.put("e_double", (Object)i);
                record.put("f_bytes", (Object)bb);
                record.put("g_null", null);
                record.put("h_boolean", (Object)(i % 2 == 0 ? 1 : 0));
                record.put("i_union", i % 2 == 0 ? Double.valueOf(i) : null);
                writer.append((Object)record);
            }
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateUnionSchema_WithNonNullValues() throws Exception {
        Schema schema = (Schema)((SchemaBuilder.DoubleDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"AvroRecordReaderTest").namespace("org.apache.drill.exec.store.avro")).fields().name("a_string").type().stringType().noDefault().name("b_int").type().intType().noDefault().name("c_long").type().longType().noDefault().name("d_float").type().floatType().noDefault().name("e_double").type().doubleType().noDefault().name("f_bytes").type().bytesType().noDefault().name("g_null").type().nullType().noDefault().name("h_boolean").type().booleanType().noDefault().name("i_union").type().unionOf().doubleType().and().longType()).endUnion()).noDefault().endRecord();
        File file = File.createTempFile("avro-primitive-test", ".avro");
        file.deleteOnExit();
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));){
            writer.create(schema, file);
            ByteBuffer bb = ByteBuffer.allocate(1);
            bb.put(0, (byte)1);
            for (int i = 0; i < 10; ++i) {
                GenericData.Record record = new GenericData.Record(schema);
                record.put("a_string", (Object)("a_" + i));
                record.put("b_int", (Object)i);
                record.put("c_long", (Object)i);
                record.put("d_float", (Object)Float.valueOf(i));
                record.put("e_double", (Object)i);
                record.put("f_bytes", (Object)bb);
                record.put("g_null", null);
                record.put("h_boolean", (Object)(i % 2 == 0 ? 1 : 0));
                record.put("i_union", (Object)(i % 2 == 0 ? (double)i : (double)i));
                writer.append((Object)record);
            }
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateSimpleEnumSchema_NoNullValues() throws Exception {
        String[] symbols = new String[]{"E_SYM_A", "E_SYM_B", "E_SYM_C", "E_SYM_D"};
        Schema schema = (Schema)((SchemaBuilder.EnumDefault)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"AvroRecordReaderTest").namespace("org.apache.drill.exec.store.avro")).fields().name("a_string").type().stringType().noDefault().name("b_enum").type().enumeration("my_enum").symbols(symbols)).noDefault().endRecord();
        File file = File.createTempFile("avro-primitive-test", ".avro");
        file.deleteOnExit();
        Schema enumSchema = schema.getField("b_enum").schema();
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));){
            writer.create(schema, file);
            for (int i = 0; i < 10; ++i) {
                GenericData.Record record = new GenericData.Record(schema);
                record.put("a_string", (Object)("a_" + i));
                GenericData.EnumSymbol symbol = new GenericData.EnumSymbol(enumSchema, symbols[(i + symbols.length) % symbols.length]);
                record.put("b_enum", (Object)symbol);
                writer.append((Object)record);
            }
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateSimpleArraySchema_NoNullValues() throws Exception {
        File file = File.createTempFile("avro-array-test", ".avro");
        file.deleteOnExit();
        Schema schema = (Schema)((SchemaBuilder.ArrayDefault)((SchemaBuilder.ArrayDefault)((SchemaBuilder.ArrayDefault)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"AvroRecordReaderTest").namespace("org.apache.drill.exec.store.avro")).fields().name("a_string").type().stringType().noDefault().name("b_int").type().intType().noDefault().name("c_string_array").type().array().items().stringType()).noDefault().name("d_int_array").type().array().items().intType()).noDefault().name("e_float_array").type().array().items().floatType()).noDefault().endRecord();
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));){
            writer.create(schema, file);
            for (int i = 0; i < 10; ++i) {
                int j;
                GenericData.Record record = new GenericData.Record(schema);
                record.put("a_string", (Object)("a_" + i));
                record.put("b_int", (Object)i);
                GenericData.Array array = new GenericData.Array(10, schema.getField("c_string_array").schema());
                for (j = 0; j < 10; ++j) {
                    array.add(j, (Object)("c_string_array_" + i + "_" + j));
                }
                record.put("c_string_array", (Object)array);
                array = new GenericData.Array(10, schema.getField("d_int_array").schema());
                for (j = 0; j < 10; ++j) {
                    array.add(j, (Object)(i * j));
                }
                record.put("d_int_array", (Object)array);
                array = new GenericData.Array(10, schema.getField("e_float_array").schema());
                for (j = 0; j < 10; ++j) {
                    array.add(j, (Object)Float.valueOf(i * j));
                }
                record.put("e_float_array", (Object)array);
                writer.append((Object)record);
            }
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateSimpleNestedSchema_NoNullValues() throws Exception {
        File file = File.createTempFile("avro-nested-test", ".avro");
        file.deleteOnExit();
        Schema schema = (Schema)((SchemaBuilder.RecordDefault)((SchemaBuilder.RecordBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"AvroRecordReaderTest").namespace("org.apache.drill.exec.store.avro")).fields().name("a_string").type().stringType().noDefault().name("b_int").type().intType().noDefault().name("c_record").type().record("my_record_1").namespace("foo.blah.org")).fields().name("nested_1_string").type().stringType().noDefault().name("nested_1_int").type().intType().noDefault().endRecord()).noDefault().endRecord();
        Schema nestedSchema = schema.getField("c_record").schema();
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));
        writer.create(schema, file);
        try {
            for (int i = 0; i < 10; ++i) {
                GenericData.Record record = new GenericData.Record(schema);
                record.put("a_string", (Object)("a_" + i));
                record.put("b_int", (Object)i);
                GenericData.Record nestedRecord = new GenericData.Record(nestedSchema);
                nestedRecord.put("nested_1_string", (Object)("nested_1_string_" + i));
                nestedRecord.put("nested_1_int", (Object)(i * i));
                record.put("c_record", (Object)nestedRecord);
                writer.append((Object)record);
            }
        }
        finally {
            writer.close();
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateUnionNestedArraySchema_withNullValues() throws Exception {
        File file = File.createTempFile("avro-nested-test", ".avro");
        file.deleteOnExit();
        Schema schema = (Schema)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.RecordBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"AvroRecordReaderTest").namespace("org.apache.drill.exec.store.avro")).fields().name("a_string").type().stringType().noDefault().name("b_int").type().intType().noDefault().name("c_array").type().optional().array().items().record("my_record_1").namespace("foo.blah.org")).fields().name("nested_1_string").type().optional().stringType()).name("nested_1_int").type().optional().intType()).endRecord()).endRecord();
        Schema nestedSchema = schema.getField("c_array").schema();
        Schema arraySchema = (Schema)nestedSchema.getTypes().get(1);
        Schema itemSchema = arraySchema.getElementType();
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));
        writer.create(schema, file);
        try {
            for (int i = 0; i < 10; ++i) {
                GenericData.Record record = new GenericData.Record(schema);
                record.put("a_string", (Object)("a_" + i));
                record.put("b_int", (Object)i);
                if (i % 2 == 0) {
                    GenericData.Array array = new GenericData.Array(1, arraySchema);
                    GenericData.Record nestedRecord = new GenericData.Record(itemSchema);
                    nestedRecord.put("nested_1_string", (Object)("nested_1_string_" + i));
                    nestedRecord.put("nested_1_int", (Object)(i * i));
                    array.add((Object)nestedRecord);
                    record.put("c_array", (Object)array);
                }
                writer.append((Object)record);
            }
        }
        finally {
            writer.close();
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateMapSchema_withNullValues() throws Exception {
        File file = File.createTempFile("avro-nested-test", ".avro");
        file.deleteOnExit();
        Schema schema = (Schema)((SchemaBuilder.FieldAssembler)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"AvroRecordReaderTest").namespace("org.apache.drill.exec.store.avro")).fields().name("a_string").type().stringType().noDefault().name("b_int").type().intType().noDefault().name("c_map").type().optional().map().values(Schema.create((Schema.Type)Schema.Type.STRING))).endRecord();
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));
        writer.create(schema, file);
        try {
            for (int i = 0; i < 10; ++i) {
                GenericData.Record record = new GenericData.Record(schema);
                record.put("a_string", (Object)("a_" + i));
                record.put("b_int", (Object)i);
                if (i % 2 == 0) {
                    HashMap<String, String> strMap = new HashMap<String, String>();
                    strMap.put("key1", "nested_1_string_" + i);
                    strMap.put("key2", "nested_1_string_" + (i + 1));
                    record.put("c_map", strMap);
                }
                writer.append((Object)record);
            }
        }
        finally {
            writer.close();
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateMapSchemaComplex_withNullValues() throws Exception {
        File file = File.createTempFile("avro-nested-test", ".avro");
        file.deleteOnExit();
        Schema schema = (Schema)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"AvroRecordReaderTest").namespace("org.apache.drill.exec.store.avro")).fields().name("a_string").type().stringType().noDefault().name("b_int").type().intType().noDefault().name("c_map").type().optional().map().values(Schema.create((Schema.Type)Schema.Type.STRING))).name("d_map").type().optional().map().values(Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.DOUBLE)))).endRecord();
        Schema arrayMapSchema = schema.getField("d_map").schema();
        Schema arrayItemSchema = ((Schema)arrayMapSchema.getTypes().get(1)).getValueType();
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));
        writer.create(schema, file);
        try {
            for (int i = 0; i < 10; ++i) {
                GenericData.Record record = new GenericData.Record(schema);
                record.put("a_string", (Object)("a_" + i));
                record.put("b_int", (Object)i);
                if (i % 2 == 0) {
                    HashMap<String, String> c_map = new HashMap<String, String>();
                    c_map.put("key1", "nested_1_string_" + i);
                    c_map.put("key2", "nested_1_string_" + (i + 1));
                    record.put("c_map", c_map);
                } else {
                    HashMap<String, GenericData.Array> d_map = new HashMap<String, GenericData.Array>();
                    GenericData.Array array = new GenericData.Array(10, arrayItemSchema);
                    for (int j = 0; j < 10; ++j) {
                        array.add((Object)j);
                    }
                    d_map.put("key1", array);
                    d_map.put("key2", array);
                    record.put("d_map", d_map);
                }
                writer.append((Object)record);
            }
        }
        finally {
            writer.close();
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateUnionNestedSchema_withNullValues() throws Exception {
        File file = File.createTempFile("avro-nested-test", ".avro");
        file.deleteOnExit();
        Schema schema = (Schema)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.RecordBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"AvroRecordReaderTest").namespace("org.apache.drill.exec.store.avro")).fields().name("a_string").type().stringType().noDefault().name("b_int").type().intType().noDefault().name("c_record").type().optional().record("my_record_1").namespace("foo.blah.org")).fields().name("nested_1_string").type().optional().stringType()).name("nested_1_int").type().optional().intType()).endRecord()).endRecord();
        Schema nestedSchema = schema.getField("c_record").schema();
        Schema optionalSchema = (Schema)nestedSchema.getTypes().get(1);
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));
        writer.create(schema, file);
        try {
            for (int i = 0; i < 10; ++i) {
                GenericData.Record record = new GenericData.Record(schema);
                record.put("a_string", (Object)("a_" + i));
                record.put("b_int", (Object)i);
                if (i % 2 == 0) {
                    GenericData.Record nestedRecord = new GenericData.Record(optionalSchema);
                    nestedRecord.put("nested_1_string", (Object)("nested_1_string_" + i));
                    nestedRecord.put("nested_1_int", (Object)(i * i));
                    record.put("c_record", (Object)nestedRecord);
                }
                writer.append((Object)record);
            }
        }
        finally {
            writer.close();
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateDoubleNestedSchema_NoNullValues() throws Exception {
        File file = File.createTempFile("avro-double-nested-test", ".avro");
        file.deleteOnExit();
        Schema schema = (Schema)((SchemaBuilder.RecordDefault)((SchemaBuilder.RecordDefault)((SchemaBuilder.RecordBuilder)((SchemaBuilder.RecordBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"AvroRecordReaderTest").namespace("org.apache.drill.exec.store.avro")).fields().name("a_string").type().stringType().noDefault().name("b_int").type().intType().noDefault().name("c_record").type().record("my_record_1").namespace("foo.blah.org")).fields().name("nested_1_string").type().stringType().noDefault().name("nested_1_int").type().intType().noDefault().name("nested_1_record").type().record("my_double_nested_record_1").namespace("foo.blah.org.rot")).fields().name("double_nested_1_string").type().stringType().noDefault().name("double_nested_1_int").type().intType().noDefault().endRecord()).noDefault().endRecord()).noDefault().endRecord();
        Schema nestedSchema = schema.getField("c_record").schema();
        Schema doubleNestedSchema = nestedSchema.getField("nested_1_record").schema();
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));
        writer.create(schema, file);
        try {
            for (int i = 0; i < 10; ++i) {
                GenericData.Record record = new GenericData.Record(schema);
                record.put("a_string", (Object)("a_" + i));
                record.put("b_int", (Object)i);
                GenericData.Record nestedRecord = new GenericData.Record(nestedSchema);
                nestedRecord.put("nested_1_string", (Object)("nested_1_string_" + i));
                nestedRecord.put("nested_1_int", (Object)(i * i));
                GenericData.Record doubleNestedRecord = new GenericData.Record(doubleNestedSchema);
                doubleNestedRecord.put("double_nested_1_string", (Object)("double_nested_1_string_" + i + "_" + i));
                doubleNestedRecord.put("double_nested_1_int", (Object)(i * i * i));
                nestedRecord.put("nested_1_record", (Object)doubleNestedRecord);
                record.put("c_record", (Object)nestedRecord);
                writer.append((Object)record);
            }
        }
        finally {
            writer.close();
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateStringAndUtf8Data() throws Exception {
        Schema schema = (Schema)((SchemaBuilder.StringDefault)((SchemaBuilder.StringBldr)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"AvroRecordReaderTest").namespace("org.apache.drill.exec.store.avro")).fields().name("a_string").type().stringBuilder().prop("avro.java.string", "String")).endString()).noDefault().name("b_utf8").type().stringType().noDefault().endRecord();
        File file = File.createTempFile("avro-primitive-test", ".avro");
        file.deleteOnExit();
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));){
            writer.create(schema, file);
            ByteBuffer bb = ByteBuffer.allocate(1);
            bb.put(0, (byte)1);
            for (int i = 0; i < 10; ++i) {
                GenericData.Record record = new GenericData.Record(schema);
                record.put("a_string", (Object)("a_" + i));
                record.put("b_utf8", (Object)("b_" + i));
                writer.append((Object)record);
            }
        }
        return file.getAbsolutePath();
    }
}

