/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.avro;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.exceptions.UserRemoteException;
import org.apache.drill.exec.store.avro.AvroTestUtil;
import org.junit.Assert;
import org.junit.Test;

public class AvroFormatTest
extends BaseTestQuery {
    @Test
    public void testSimplePrimitiveSchema_NoNullValues() throws Exception {
        String file = AvroTestUtil.generateSimplePrimitiveSchema_NoNullValues();
        String sql = "select a_string, b_int, c_long, d_float, e_double, f_bytes, h_boolean, g_null from dfs_test.`" + file + "`";
        AvroFormatTest.test(sql);
    }

    @Test
    public void testSimplePrimitiveSchema_StarQuery() throws Exception {
        String file = AvroTestUtil.generateSimplePrimitiveSchema_NoNullValues();
        String sql = "select * from dfs_test.`" + file + "`";
        AvroFormatTest.test(sql);
    }

    @Test
    public void testSimplePrimitiveSchema_SelectColumnSubset() throws Exception {
        String file = AvroTestUtil.generateSimplePrimitiveSchema_NoNullValues();
        String sql = "select h_boolean, e_double from dfs_test.`" + file + "`";
        AvroFormatTest.test(sql);
    }

    @Test
    public void testSimpleArraySchema_NoNullValues() throws Exception {
        String file = AvroTestUtil.generateSimpleArraySchema_NoNullValues();
        String sql = "select a_string, c_string_array[0], e_float_array[2] from dfs_test.`" + file + "`";
        AvroFormatTest.test(sql);
    }

    @Test
    public void testSimpleArraySchema_StarQuery() throws Exception {
        String file = AvroTestUtil.generateSimpleArraySchema_NoNullValues();
        String sql = "select * from dfs_test.`" + file + "`";
        AvroFormatTest.test(sql);
    }

    @Test
    public void testSimpleNestedSchema_NoNullValues() throws Exception {
        String file = AvroTestUtil.generateSimpleNestedSchema_NoNullValues();
        String sql = "select a_string, b_int, t.c_record.nested_1_string, t.c_record.nested_1_int from dfs_test.`" + file + "` t";
        AvroFormatTest.test(sql);
    }

    @Test
    public void testSimpleNestedSchema_StarQuery() throws Exception {
        String file = AvroTestUtil.generateSimpleNestedSchema_NoNullValues();
        String sql = "select * from dfs_test.`" + file + "`";
        AvroFormatTest.test(sql);
    }

    @Test
    public void testDoubleNestedSchema_NoNullValues() throws Exception {
        String file = AvroTestUtil.generateDoubleNestedSchema_NoNullValues();
        String sql = "select a_string, b_int, t.c_record.nested_1_string, t.c_record.nested_1_int, t.c_record.nested_1_record.double_nested_1_string, t.c_record.nested_1_record.double_nested_1_int from dfs_test.`" + file + "` t";
        AvroFormatTest.test(sql);
    }

    @Test
    public void testDoubleNestedSchema_StarQuery() throws Exception {
        String file = AvroTestUtil.generateDoubleNestedSchema_NoNullValues();
        String sql = "select * from dfs_test.`" + file + "`";
        AvroFormatTest.test(sql);
    }

    @Test
    public void testSimpleEnumSchema_NoNullValues() throws Exception {
        String file = AvroTestUtil.generateSimpleEnumSchema_NoNullValues();
        String sql = "select a_string, b_enum from dfs_test.`" + file + "`";
        AvroFormatTest.test(sql);
    }

    @Test
    public void testSimpleEnumSchema_StarQuery() throws Exception {
        String file = AvroTestUtil.generateSimpleEnumSchema_NoNullValues();
        String sql = "select * from dfs_test.`" + file + "`";
        AvroFormatTest.test(sql);
    }

    @Test
    public void testSimpleUnionSchema_StarQuery() throws Exception {
        String file = AvroTestUtil.generateUnionSchema_WithNullValues();
        String sql = "select * from dfs_test.`" + file + "`";
        AvroFormatTest.test(sql);
    }

    @Test
    public void testShouldFailSimpleUnionNonNullSchema_StarQuery() throws Exception {
        String file = AvroTestUtil.generateUnionSchema_WithNonNullValues();
        String sql = "select * from dfs_test.`" + file + "`";
        try {
            AvroFormatTest.test(sql);
            Assert.fail((String)"Test should fail as union is only supported for optional fields");
        }
        catch (UserRemoteException e) {
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.contains("Avro union type must be of the format : [\"null\", \"some-type\"]"));
        }
    }

    @Test
    public void testNestedUnionSchema_withNullValues() throws Exception {
        String file = AvroTestUtil.generateUnionNestedSchema_withNullValues();
        String sql = "select t.c_record.nested_1_string,t.c_record.nested_1_int from dfs_test.`" + file + "` t";
        AvroFormatTest.test(sql);
    }

    @Test
    public void testNestedUnionArraySchema_withNullValues() throws Exception {
        String file = AvroTestUtil.generateUnionNestedArraySchema_withNullValues();
        String sql = "select t.c_array[0].nested_1_string,t.c_array[0].nested_1_int from dfs_test.`" + file + "` t";
        AvroFormatTest.test(sql);
    }

    @Test
    public void testMapSchema_withNullValues() throws Exception {
        String file = AvroTestUtil.generateMapSchema_withNullValues();
        String sql = "select c_map['key1'],c_map['key2'] from dfs_test.`" + file + "`";
        AvroFormatTest.test(sql);
    }

    @Test
    public void testMapSchemaComplex_withNullValues() throws Exception {
        String file = AvroTestUtil.generateMapSchemaComplex_withNullValues();
        String sql = "select d_map['key1'],d_map['key2'] from dfs_test.`" + file + "`";
        AvroFormatTest.test(sql);
    }

    @Test
    public void testStringAndUtf8Data() throws Exception {
        String file = AvroTestUtil.generateStringAndUtf8Data();
        String sql = "select * from dfs_test.`" + file + "`";
        AvroFormatTest.test(sql);
    }
}

