/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.util.TestTools;
import org.apache.drill.exec.store.TimedRunnable;
import org.apache.drill.test.DrillTest;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTimedRunnable
extends DrillTest {
    private static final Logger logger = LoggerFactory.getLogger(TestTimedRunnable.class);
    @Rule
    public final TestRule TIMEOUT = TestTools.getTimeoutRule((int)180000);

    @Test
    public void withoutAnyTasksTriggeringTimeout() throws Exception {
        ArrayList tasks = Lists.newArrayList();
        for (int i = 0; i < 100; ++i) {
            tasks.add(new TestTask(2000L));
        }
        TimedRunnable.run((String)"Execution without triggering timeout", (Logger)logger, (List)tasks, (int)16);
    }

    @Test
    public void withTasksExceedingTimeout() throws Exception {
        UserException ex = null;
        try {
            ArrayList tasks = Lists.newArrayList();
            for (int i = 0; i < 100; ++i) {
                if ((i & i + 1) == 0) {
                    tasks.add(new TestTask(2000L));
                    continue;
                }
                tasks.add(new TestTask(20000L));
            }
            TimedRunnable.run((String)"Execution with some tasks triggering timeout", (Logger)logger, (List)tasks, (int)16);
        }
        catch (UserException e) {
            ex = e;
        }
        Assert.assertNotNull((String)"Expected a UserException", (Object)((Object)ex));
        Assert.assertThat((Object)ex.getMessage(), (Matcher)StringContains.containsString((String)"Waited for 93750ms, but tasks for 'Execution with some tasks triggering timeout' are not complete. Total runnable size 100, parallelism 16."));
    }

    @Test
    public void withManyTasks() throws Exception {
        ArrayList tasks = Lists.newArrayList();
        for (int i = 0; i < 150000; ++i) {
            tasks.add(new TestTask(0L));
        }
        TimedRunnable.run((String)"Execution with lots of tasks", (Logger)logger, (List)tasks, (int)16);
    }

    private static class TestTask
    extends TimedRunnable {
        final long sleepTime;

        public TestTask(long sleepTime) {
            this.sleepTime = sleepTime;
        }

        protected Void runInner() throws Exception {
            Thread.sleep(this.sleepTime);
            return null;
        }

        protected IOException convertToIOException(Exception e) {
            return new IOException("Failure while trying to sleep for sometime", e);
        }
    }
}

