/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import com.google.common.collect.Maps;
import io.netty.buffer.DrillBuf;
import java.util.Iterator;
import java.util.Map;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.util.CallBack;
import org.apache.drill.exec.vector.ValueVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOutputMutator
implements OutputMutator,
Iterable<VectorWrapper<?>> {
    static final Logger logger = LoggerFactory.getLogger(TestOutputMutator.class);
    private final VectorContainer container = new VectorContainer();
    private final Map<MaterializedField, ValueVector> fieldVectorMap = Maps.newHashMap();
    private final BufferAllocator allocator;

    public TestOutputMutator(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    public void removeField(MaterializedField field) throws SchemaChangeException {
        ValueVector vector = this.fieldVectorMap.remove(field);
        if (vector == null) {
            throw new SchemaChangeException("Failure attempting to remove an unknown field.");
        }
        this.container.remove(vector);
        vector.close();
    }

    public void addField(ValueVector vector) {
        this.container.add(vector);
        this.fieldVectorMap.put(vector.getField(), vector);
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.container.iterator();
    }

    public void clear() {
    }

    public boolean isNewSchema() {
        return false;
    }

    public void allocate(int recordCount) {
    }

    public <T extends ValueVector> T addField(MaterializedField field, Class<T> clazz) throws SchemaChangeException {
        ValueVector v = TypeHelper.getNewVector(field, this.allocator);
        if (!clazz.isAssignableFrom(v.getClass())) {
            throw new SchemaChangeException(String.format("The class that was provided %s does not correspond to the expected vector type of %s.", clazz.getSimpleName(), v.getClass().getSimpleName()));
        }
        this.addField(v);
        return (T)v;
    }

    public DrillBuf getManagedBuffer() {
        return this.allocator.buffer(255);
    }

    public CallBack getCallBack() {
        return null;
    }
}

