/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DrillBuf;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.drill.common.DeferredException;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.store.parquet.DirectCodecFactory;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;
import parquet.bytes.BytesInput;
import parquet.hadoop.CodecFactory;
import parquet.hadoop.metadata.CompressionCodecName;

public class TestDirectCodecFactory
extends ExecTest {
    private final DrillConfig drillConfig = DrillConfig.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void test(int size, CompressionCodecName codec, boolean useOnHeapCompression, Decompression decomp) {
        DrillBuf rawBuf = null;
        DrillBuf outBuf = null;
        try (BufferAllocator allocator = RootAllocatorFactory.newRoot((DrillConfig)this.drillConfig);
             DirectCodecFactory codecFactory = new DirectCodecFactory(new Configuration(), allocator);){
            try {
                rawBuf = allocator.buffer(size);
                byte[] rawArr = new byte[size];
                outBuf = allocator.buffer(size * 2);
                Random r = new Random();
                byte[] random = new byte[1024];
                for (int pos = 0; pos < size; pos += random.length) {
                    r.nextBytes(random);
                    rawBuf.writeBytes(random);
                    System.arraycopy(random, 0, rawArr, pos, random.length);
                }
                CodecFactory.BytesCompressor c = codecFactory.getCompressor(codec, 65536);
                DirectCodecFactory.DirectBytesDecompressor d = (DirectCodecFactory.DirectBytesDecompressor)codecFactory.getDecompressor(codec);
                BytesInput compressed = useOnHeapCompression ? c.compress(BytesInput.from((byte[])rawArr)) : c.compress((BytesInput)new DirectCodecFactory.ByteBufBytesInput((ByteBuf)rawBuf));
                switch (decomp) {
                    case DRILLBUF: {
                        ByteBuffer buf = compressed.toByteBuffer();
                        DrillBuf b = allocator.buffer(buf.capacity());
                        try {
                            b.writeBytes(buf);
                            d.decompress(b, (int)compressed.size(), outBuf, size);
                            int i = 0;
                            while (i < size) {
                                Assert.assertTrue((String)("Data didn't match at " + i), (outBuf.getByte(i) == rawBuf.getByte(i) ? 1 : 0) != 0);
                                ++i;
                            }
                            return;
                        }
                        finally {
                            b.release();
                        }
                    }
                    case OFF_HEAP: {
                        ByteBuffer buf = compressed.toByteBuffer();
                        DrillBuf b = allocator.buffer(buf.capacity());
                        try {
                            b.writeBytes(buf);
                            BytesInput input = d.decompress((BytesInput)new DirectCodecFactory.ByteBufBytesInput((ByteBuf)b), size);
                            Assert.assertArrayEquals((byte[])input.toByteArray(), (byte[])rawArr);
                            return;
                        }
                        finally {
                            b.release();
                        }
                    }
                    case ON_HEAP: {
                        byte[] buf = compressed.toByteArray();
                        BytesInput input = d.decompress(BytesInput.from((byte[])buf), size);
                        Assert.assertArrayEquals((byte[])input.toByteArray(), (byte[])rawArr);
                        return;
                    }
                }
                return;
            }
            catch (Exception e) {
                String msg = String.format("Failure while testing Codec: %s, OnHeapCompressionInput: %s, Decompression Mode: %s, Data Size: %d", codec.name(), useOnHeapCompression, decomp.name(), size);
                System.out.println(msg);
                throw new RuntimeException(msg, e);
            }
            finally {
                if (rawBuf != null) {
                    rawBuf.release();
                }
                if (outBuf != null) {
                    outBuf.release();
                }
            }
        }
    }

    @Test
    public void compressionCodecs() throws Exception {
        int[] sizes = new int[]{4096, 0x100000};
        boolean[] comp = new boolean[]{true, false};
        try (DeferredException ex = new DeferredException();){
            for (int size : sizes) {
                for (boolean useOnHeapComp : comp) {
                    for (Decompression decomp : Decompression.values()) {
                        for (CompressionCodecName codec : CompressionCodecName.values()) {
                            if (codec == CompressionCodecName.LZO) continue;
                            try {
                                this.test(size, codec, useOnHeapComp, decomp);
                            }
                            catch (Exception e) {
                                ex.addException(e);
                            }
                        }
                    }
                }
            }
        }
    }

    private static enum Decompression {
        ON_HEAP,
        OFF_HEAP,
        DRILLBUF;

    }
}

