/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;
import java.util.LinkedList;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.parquet.ParquetGroupScan;
import org.apache.hadoop.fs.BlockLocation;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAffinityCalculator
extends ExecTest {
    static final Logger logger = LoggerFactory.getLogger(TestAffinityCalculator.class);
    String port = "1234";
    final String path = "path";

    public BlockLocation[] buildBlockLocations(String[] hosts, long blockSize) {
        String[] names = new String[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i] = "host" + i;
            names[i] = "host:" + this.port;
        }
        BlockLocation[] blockLocations = new BlockLocation[]{new BlockLocation(new String[]{names[0], names[1], names[2]}, new String[]{hosts[0], hosts[1], hosts[2]}, 0L, blockSize), new BlockLocation(new String[]{names[0], names[2], names[3]}, new String[]{hosts[0], hosts[2], hosts[3]}, blockSize, blockSize), new BlockLocation(new String[]{names[0], names[1], names[3]}, new String[]{hosts[0], hosts[1], hosts[3]}, blockSize * 2L, blockSize)};
        return blockLocations;
    }

    public BlockLocation[] buildBlockLocations2(String[] hosts, long blockSize) {
        String[] names = new String[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i] = "host" + i;
            names[i] = "host:" + this.port;
        }
        BlockLocation[] blockLocations = new BlockLocation[4];
        blockLocations[0] = new BlockLocation(new String[]{names[0]}, new String[]{hosts[0]}, 0L, blockSize);
        blockLocations[1] = new BlockLocation(new String[]{names[1]}, new String[]{hosts[1]}, blockSize, blockSize);
        blockLocations[3] = new BlockLocation(new String[]{names[3]}, new String[]{hosts[3]}, blockSize * 2L, blockSize);
        blockLocations[2] = new BlockLocation(new String[]{names[2]}, new String[]{hosts[2]}, blockSize * 3L, blockSize);
        return blockLocations;
    }

    public void buildRowGroups(LinkedList<ParquetGroupScan.RowGroupInfo> rowGroups, int numberOfBlocks, long blockSize, int numberOfRowGroups) {
        long rowGroupSize = (long)numberOfBlocks * blockSize / (long)numberOfRowGroups;
        rowGroups.clear();
        for (int i = 0; i < numberOfRowGroups; ++i) {
            rowGroups.add(new ParquetGroupScan.RowGroupInfo("path", (long)i * rowGroupSize, rowGroupSize, i));
        }
    }

    public LinkedList<CoordinationProtos.DrillbitEndpoint> buildEndpoints(int numberOfEndpoints) {
        LinkedList<CoordinationProtos.DrillbitEndpoint> endPoints = new LinkedList<CoordinationProtos.DrillbitEndpoint>();
        for (int i = 0; i < numberOfEndpoints; ++i) {
            endPoints.add(CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress("host" + i).build());
        }
        return endPoints;
    }

    @Test
    public void testBuildRangeMap() {
        BlockLocation[] blocks = this.buildBlockLocations(new String[4], 0x10000000L);
        long tA = System.nanoTime();
        ImmutableRangeMap.Builder blockMapBuilder = new ImmutableRangeMap.Builder();
        for (BlockLocation block : blocks) {
            long start = block.getOffset();
            long end = start + block.getLength();
            Range range = Range.closedOpen((Comparable)Long.valueOf(start), (Comparable)Long.valueOf(end));
            blockMapBuilder = blockMapBuilder.put(range, (Object)block);
        }
        ImmutableRangeMap map = blockMapBuilder.build();
        long tB = System.nanoTime();
        System.out.println(String.format("Took %f ms to build range map", (double)(tB - tA) / 1000000.0));
    }
}

