/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import io.netty.buffer.DrillBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.apache.drill.exec.expr.holders.NullableDateHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal18Holder;
import org.apache.drill.exec.expr.holders.NullableDecimal28DenseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal28SparseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal38DenseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal38SparseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal9Holder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalDayHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalYearHolder;
import org.apache.drill.exec.expr.holders.NullableSmallIntHolder;
import org.apache.drill.exec.expr.holders.NullableTimeHolder;
import org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import org.apache.drill.exec.expr.holders.NullableTinyIntHolder;
import org.apache.drill.exec.expr.holders.NullableUInt1Holder;
import org.apache.drill.exec.expr.holders.NullableUInt2Holder;
import org.apache.drill.exec.expr.holders.NullableUInt4Holder;
import org.apache.drill.exec.expr.holders.NullableUInt8Holder;
import org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.store.AbstractRecordWriter;
import org.apache.drill.exec.store.EventBasedRecordWriter;
import org.apache.drill.exec.store.RecordWriter;
import org.apache.drill.exec.store.parquet.ParquetTypeHelper;
import org.apache.drill.exec.util.DecimalUtility;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.joda.time.DateTimeUtils;
import parquet.io.api.Binary;
import parquet.io.api.RecordConsumer;
import parquet.schema.MessageType;

public abstract class ParquetOutputRecordWriter
extends AbstractRecordWriter
implements RecordWriter {
    private RecordConsumer consumer;
    private MessageType schema;
    public static final long JULIAN_DAY_EPOC = DateTimeUtils.toJulianDayNumber((long)0L);

    public void setUp(MessageType schema, RecordConsumer consumer) {
        this.schema = schema;
        this.consumer = consumer;
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableTinyIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableTinyIntParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewTinyIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new TinyIntParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedTinyIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedTinyIntParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableUInt1Converter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableUInt1ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewUInt1Converter(int fieldId, String fieldName, FieldReader reader) {
        return new UInt1ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedUInt1Converter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedUInt1ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableUInt2Converter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableUInt2ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewUInt2Converter(int fieldId, String fieldName, FieldReader reader) {
        return new UInt2ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedUInt2Converter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedUInt2ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableSmallIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableSmallIntParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewSmallIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new SmallIntParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedSmallIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedSmallIntParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableIntParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new IntParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedIntParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableUInt4Converter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableUInt4ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewUInt4Converter(int fieldId, String fieldName, FieldReader reader) {
        return new UInt4ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedUInt4Converter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedUInt4ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableFloat4Converter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableFloat4ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewFloat4Converter(int fieldId, String fieldName, FieldReader reader) {
        return new Float4ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedFloat4Converter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedFloat4ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableTimeConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableTimeParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewTimeConverter(int fieldId, String fieldName, FieldReader reader) {
        return new TimeParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedTimeConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedTimeParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableIntervalYearConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableIntervalYearParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewIntervalYearConverter(int fieldId, String fieldName, FieldReader reader) {
        return new IntervalYearParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedIntervalYearConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedIntervalYearParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableDecimal9Converter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableDecimal9ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewDecimal9Converter(int fieldId, String fieldName, FieldReader reader) {
        return new Decimal9ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedDecimal9Converter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedDecimal9ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableBigIntParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new BigIntParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedBigIntConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedBigIntParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableUInt8Converter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableUInt8ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewUInt8Converter(int fieldId, String fieldName, FieldReader reader) {
        return new UInt8ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedUInt8Converter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedUInt8ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableFloat8Converter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableFloat8ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewFloat8Converter(int fieldId, String fieldName, FieldReader reader) {
        return new Float8ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedFloat8Converter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedFloat8ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableDateConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableDateParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewDateConverter(int fieldId, String fieldName, FieldReader reader) {
        return new DateParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedDateConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedDateParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableTimeStampConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableTimeStampParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewTimeStampConverter(int fieldId, String fieldName, FieldReader reader) {
        return new TimeStampParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedTimeStampConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedTimeStampParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableDecimal18Converter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableDecimal18ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewDecimal18Converter(int fieldId, String fieldName, FieldReader reader) {
        return new Decimal18ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedDecimal18Converter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedDecimal18ParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableIntervalDayConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableIntervalDayParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewIntervalDayConverter(int fieldId, String fieldName, FieldReader reader) {
        return new IntervalDayParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedIntervalDayConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedIntervalDayParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableIntervalConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableIntervalParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewIntervalConverter(int fieldId, String fieldName, FieldReader reader) {
        return new IntervalParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedIntervalConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedIntervalParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableDecimal28DenseConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableDecimal28DenseParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewDecimal28DenseConverter(int fieldId, String fieldName, FieldReader reader) {
        return new Decimal28DenseParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedDecimal28DenseConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedDecimal28DenseParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableDecimal38DenseConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableDecimal38DenseParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewDecimal38DenseConverter(int fieldId, String fieldName, FieldReader reader) {
        return new Decimal38DenseParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedDecimal38DenseConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedDecimal38DenseParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableDecimal38SparseConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableDecimal38SparseParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewDecimal38SparseConverter(int fieldId, String fieldName, FieldReader reader) {
        return new Decimal38SparseParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedDecimal38SparseConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedDecimal38SparseParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableDecimal28SparseConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableDecimal28SparseParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewDecimal28SparseConverter(int fieldId, String fieldName, FieldReader reader) {
        return new Decimal28SparseParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedDecimal28SparseConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedDecimal28SparseParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableVarBinaryConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableVarBinaryParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewVarBinaryConverter(int fieldId, String fieldName, FieldReader reader) {
        return new VarBinaryParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedVarBinaryConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedVarBinaryParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableVarCharConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableVarCharParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewVarCharConverter(int fieldId, String fieldName, FieldReader reader) {
        return new VarCharParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedVarCharConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedVarCharParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableVar16CharConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableVar16CharParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewVar16CharConverter(int fieldId, String fieldName, FieldReader reader) {
        return new Var16CharParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedVar16CharConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedVar16CharParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewNullableBitConverter(int fieldId, String fieldName, FieldReader reader) {
        return new NullableBitParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewBitConverter(int fieldId, String fieldName, FieldReader reader) {
        return new BitParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedBitConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedBitParquetConverter(fieldId, fieldName, reader);
    }

    private static class IntervalUtility {
        private IntervalUtility() {
        }

        private static void intToLEByteArray(int value, byte[] output, int outputIndex) {
            int shiftOrder = 0;
            for (int i = outputIndex; i < outputIndex + 4; ++i) {
                output[i] = (byte)(value >> shiftOrder);
                shiftOrder += 8;
            }
        }
    }

    public class RepeatedBitParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableBitHolder holder;

        public RepeatedBitParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableBitHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                this.reader.read(i, this.holder);
                ParquetOutputRecordWriter.this.consumer.addBoolean(this.holder.value == 1);
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class BitParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableBitHolder holder;

        public BitParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableBitHolder();
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addBoolean(this.holder.value == 1);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableBitParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableBitHolder holder;

        public NullableBitParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableBitHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addBoolean(this.holder.value == 1);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedVar16CharParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableVar16CharHolder holder;

        public RepeatedVar16CharParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableVar16CharHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                this.reader.read(i, this.holder);
                ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteBuffer((ByteBuffer)this.holder.buffer.nioBuffer(this.holder.start, this.holder.end - this.holder.start)));
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class Var16CharParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableVar16CharHolder holder;

        public Var16CharParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableVar16CharHolder();
        }

        @Override
        public void writeField() throws IOException {
            this.reader.read(this.holder);
            DrillBuf buf = this.holder.buffer;
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteBuffer((ByteBuffer)this.holder.buffer.nioBuffer(this.holder.start, this.holder.end - this.holder.start)));
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableVar16CharParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableVar16CharHolder holder;

        public NullableVar16CharParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableVar16CharHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            this.reader.read(this.holder);
            DrillBuf buf = this.holder.buffer;
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteBuffer((ByteBuffer)this.holder.buffer.nioBuffer(this.holder.start, this.holder.end - this.holder.start)));
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedVarCharParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableVarCharHolder holder;

        public RepeatedVarCharParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableVarCharHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                this.reader.read(i, this.holder);
                ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteBuffer((ByteBuffer)this.holder.buffer.nioBuffer(this.holder.start, this.holder.end - this.holder.start)));
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class VarCharParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableVarCharHolder holder;

        public VarCharParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableVarCharHolder();
        }

        @Override
        public void writeField() throws IOException {
            this.reader.read(this.holder);
            DrillBuf buf = this.holder.buffer;
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteBuffer((ByteBuffer)this.holder.buffer.nioBuffer(this.holder.start, this.holder.end - this.holder.start)));
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableVarCharParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableVarCharHolder holder;

        public NullableVarCharParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableVarCharHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            this.reader.read(this.holder);
            DrillBuf buf = this.holder.buffer;
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteBuffer((ByteBuffer)this.holder.buffer.nioBuffer(this.holder.start, this.holder.end - this.holder.start)));
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedVarBinaryParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableVarBinaryHolder holder;

        public RepeatedVarBinaryParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableVarBinaryHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                this.reader.read(i, this.holder);
                ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteBuffer((ByteBuffer)this.holder.buffer.nioBuffer(this.holder.start, this.holder.end - this.holder.start)));
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class VarBinaryParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableVarBinaryHolder holder;

        public VarBinaryParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableVarBinaryHolder();
        }

        @Override
        public void writeField() throws IOException {
            this.reader.read(this.holder);
            DrillBuf buf = this.holder.buffer;
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteBuffer((ByteBuffer)this.holder.buffer.nioBuffer(this.holder.start, this.holder.end - this.holder.start)));
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableVarBinaryParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableVarBinaryHolder holder;

        public NullableVarBinaryParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableVarBinaryHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            this.reader.read(this.holder);
            DrillBuf buf = this.holder.buffer;
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteBuffer((ByteBuffer)this.holder.buffer.nioBuffer(this.holder.start, this.holder.end - this.holder.start)));
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedDecimal28SparseParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal28SparseHolder holder;

        public RepeatedDecimal28SparseParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal28SparseHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class Decimal28SparseParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal28SparseHolder holder;

        public Decimal28SparseParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal28SparseHolder();
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            byte[] bytes = DecimalUtility.getBigDecimalFromSparse((DrillBuf)this.holder.buffer, (int)this.holder.start, (int)5, (int)this.holder.scale).unscaledValue().toByteArray();
            byte[] output = new byte[ParquetTypeHelper.getLengthForMinorType(TypeProtos.MinorType.DECIMAL28SPARSE)];
            if (NullableDecimal28SparseHolder.getSign(this.holder.start, this.holder.buffer)) {
                Arrays.fill(output, 0, output.length - bytes.length, (byte)-1);
            } else {
                Arrays.fill(output, 0, output.length - bytes.length, (byte)0);
            }
            System.arraycopy(bytes, 0, output, output.length - bytes.length, bytes.length);
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteArray((byte[])output));
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableDecimal28SparseParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal28SparseHolder holder;

        public NullableDecimal28SparseParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal28SparseHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            byte[] bytes = DecimalUtility.getBigDecimalFromSparse((DrillBuf)this.holder.buffer, (int)this.holder.start, (int)5, (int)this.holder.scale).unscaledValue().toByteArray();
            byte[] output = new byte[ParquetTypeHelper.getLengthForMinorType(TypeProtos.MinorType.DECIMAL28SPARSE)];
            if (NullableDecimal28SparseHolder.getSign(this.holder.start, this.holder.buffer)) {
                Arrays.fill(output, 0, output.length - bytes.length, (byte)-1);
            } else {
                Arrays.fill(output, 0, output.length - bytes.length, (byte)0);
            }
            System.arraycopy(bytes, 0, output, output.length - bytes.length, bytes.length);
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteArray((byte[])output));
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedDecimal38SparseParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal38SparseHolder holder;

        public RepeatedDecimal38SparseParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal38SparseHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class Decimal38SparseParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal38SparseHolder holder;

        public Decimal38SparseParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal38SparseHolder();
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            byte[] bytes = DecimalUtility.getBigDecimalFromSparse((DrillBuf)this.holder.buffer, (int)this.holder.start, (int)6, (int)this.holder.scale).unscaledValue().toByteArray();
            byte[] output = new byte[ParquetTypeHelper.getLengthForMinorType(TypeProtos.MinorType.DECIMAL38SPARSE)];
            if (NullableDecimal38SparseHolder.getSign(this.holder.start, this.holder.buffer)) {
                Arrays.fill(output, 0, output.length - bytes.length, (byte)-1);
            } else {
                Arrays.fill(output, 0, output.length - bytes.length, (byte)0);
            }
            System.arraycopy(bytes, 0, output, output.length - bytes.length, bytes.length);
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteArray((byte[])output));
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableDecimal38SparseParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal38SparseHolder holder;

        public NullableDecimal38SparseParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal38SparseHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            byte[] bytes = DecimalUtility.getBigDecimalFromSparse((DrillBuf)this.holder.buffer, (int)this.holder.start, (int)6, (int)this.holder.scale).unscaledValue().toByteArray();
            byte[] output = new byte[ParquetTypeHelper.getLengthForMinorType(TypeProtos.MinorType.DECIMAL38SPARSE)];
            if (NullableDecimal38SparseHolder.getSign(this.holder.start, this.holder.buffer)) {
                Arrays.fill(output, 0, output.length - bytes.length, (byte)-1);
            } else {
                Arrays.fill(output, 0, output.length - bytes.length, (byte)0);
            }
            System.arraycopy(bytes, 0, output, output.length - bytes.length, bytes.length);
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteArray((byte[])output));
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedDecimal38DenseParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal38DenseHolder holder;

        public RepeatedDecimal38DenseParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal38DenseHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class Decimal38DenseParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal38DenseHolder holder;

        public Decimal38DenseParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal38DenseHolder();
        }

        @Override
        public void writeField() throws IOException {
        }
    }

    public class NullableDecimal38DenseParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal38DenseHolder holder;

        public NullableDecimal38DenseParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal38DenseHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
        }
    }

    public class RepeatedDecimal28DenseParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal28DenseHolder holder;

        public RepeatedDecimal28DenseParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal28DenseHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class Decimal28DenseParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal28DenseHolder holder;

        public Decimal28DenseParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal28DenseHolder();
        }

        @Override
        public void writeField() throws IOException {
        }
    }

    public class NullableDecimal28DenseParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal28DenseHolder holder;

        public NullableDecimal28DenseParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal28DenseHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
        }
    }

    public class RepeatedIntervalParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableIntervalHolder holder;
        private final byte[] output;

        public RepeatedIntervalParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableIntervalHolder();
            this.output = new byte[12];
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
                this.reader.read(this.holder);
                IntervalUtility.intToLEByteArray(this.holder.months, this.output, 0);
                IntervalUtility.intToLEByteArray(this.holder.days, this.output, 4);
                IntervalUtility.intToLEByteArray(this.holder.milliseconds, this.output, 8);
                ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteArray((byte[])this.output));
                ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class IntervalParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableIntervalHolder holder;
        private final byte[] output;

        public IntervalParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableIntervalHolder();
            this.output = new byte[12];
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            IntervalUtility.intToLEByteArray(this.holder.months, this.output, 0);
            IntervalUtility.intToLEByteArray(this.holder.days, this.output, 4);
            IntervalUtility.intToLEByteArray(this.holder.milliseconds, this.output, 8);
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteArray((byte[])this.output));
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableIntervalParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableIntervalHolder holder;
        private final byte[] output;

        public NullableIntervalParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableIntervalHolder();
            this.output = new byte[12];
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            IntervalUtility.intToLEByteArray(this.holder.months, this.output, 0);
            IntervalUtility.intToLEByteArray(this.holder.days, this.output, 4);
            IntervalUtility.intToLEByteArray(this.holder.milliseconds, this.output, 8);
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteArray((byte[])this.output));
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedIntervalDayParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableIntervalDayHolder holder;
        private final byte[] output;

        public RepeatedIntervalDayParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableIntervalDayHolder();
            this.output = new byte[12];
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
                this.reader.read(this.holder);
                Arrays.fill(this.output, 0, 4, (byte)0);
                IntervalUtility.intToLEByteArray(this.holder.days, this.output, 4);
                IntervalUtility.intToLEByteArray(this.holder.milliseconds, this.output, 8);
                ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteArray((byte[])this.output));
                ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class IntervalDayParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableIntervalDayHolder holder;
        private final byte[] output;

        public IntervalDayParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableIntervalDayHolder();
            this.output = new byte[12];
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            Arrays.fill(this.output, 0, 4, (byte)0);
            IntervalUtility.intToLEByteArray(this.holder.days, this.output, 4);
            IntervalUtility.intToLEByteArray(this.holder.milliseconds, this.output, 8);
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteArray((byte[])this.output));
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableIntervalDayParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableIntervalDayHolder holder;
        private final byte[] output;

        public NullableIntervalDayParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableIntervalDayHolder();
            this.output = new byte[12];
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            Arrays.fill(this.output, 0, 4, (byte)0);
            IntervalUtility.intToLEByteArray(this.holder.days, this.output, 4);
            IntervalUtility.intToLEByteArray(this.holder.milliseconds, this.output, 8);
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteArray((byte[])this.output));
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedDecimal18ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal18Holder holder;

        public RepeatedDecimal18ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal18Holder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                this.reader.read(i, this.holder);
                ParquetOutputRecordWriter.this.consumer.addLong(this.holder.value);
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class Decimal18ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal18Holder holder;

        public Decimal18ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal18Holder();
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addLong(this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableDecimal18ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal18Holder holder;

        public NullableDecimal18ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal18Holder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addLong(this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedTimeStampParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableTimeStampHolder holder;

        public RepeatedTimeStampParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableTimeStampHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                this.reader.read(i, this.holder);
                ParquetOutputRecordWriter.this.consumer.addLong(this.holder.value);
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class TimeStampParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableTimeStampHolder holder;

        public TimeStampParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableTimeStampHolder();
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addLong(this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableTimeStampParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableTimeStampHolder holder;

        public NullableTimeStampParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableTimeStampHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addLong(this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedDateParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDateHolder holder;

        public RepeatedDateParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDateHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                this.reader.read(i, this.holder);
                ParquetOutputRecordWriter.this.consumer.addInteger((int)(DateTimeUtils.toJulianDayNumber((long)this.holder.value) + JULIAN_DAY_EPOC));
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class DateParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDateHolder holder;

        public DateParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDateHolder();
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addInteger((int)(DateTimeUtils.toJulianDayNumber((long)this.holder.value) + JULIAN_DAY_EPOC));
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableDateParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDateHolder holder;

        public NullableDateParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDateHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addInteger((int)(DateTimeUtils.toJulianDayNumber((long)this.holder.value) + JULIAN_DAY_EPOC));
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedFloat8ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableFloat8Holder holder;

        public RepeatedFloat8ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableFloat8Holder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                this.reader.read(i, this.holder);
                ParquetOutputRecordWriter.this.consumer.addDouble(this.holder.value);
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class Float8ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableFloat8Holder holder;

        public Float8ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableFloat8Holder();
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addDouble(this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableFloat8ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableFloat8Holder holder;

        public NullableFloat8ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableFloat8Holder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addDouble(this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedUInt8ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableUInt8Holder holder;

        public RepeatedUInt8ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableUInt8Holder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                this.reader.read(i, this.holder);
                ParquetOutputRecordWriter.this.consumer.addLong(this.holder.value);
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class UInt8ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableUInt8Holder holder;

        public UInt8ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableUInt8Holder();
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addLong(this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableUInt8ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableUInt8Holder holder;

        public NullableUInt8ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableUInt8Holder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addLong(this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedBigIntParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableBigIntHolder holder;

        public RepeatedBigIntParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableBigIntHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                this.reader.read(i, this.holder);
                ParquetOutputRecordWriter.this.consumer.addLong(this.holder.value);
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class BigIntParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableBigIntHolder holder;

        public BigIntParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableBigIntHolder();
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addLong(this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableBigIntParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableBigIntHolder holder;

        public NullableBigIntParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableBigIntHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addLong(this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedDecimal9ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal9Holder holder;

        public RepeatedDecimal9ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal9Holder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                this.reader.read(i, this.holder);
                ParquetOutputRecordWriter.this.consumer.addInteger(this.holder.value);
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class Decimal9ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal9Holder holder;

        public Decimal9ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal9Holder();
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addInteger(this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableDecimal9ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableDecimal9Holder holder;

        public NullableDecimal9ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableDecimal9Holder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addInteger(this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedIntervalYearParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableIntervalYearHolder holder;
        private final byte[] output;

        public RepeatedIntervalYearParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableIntervalYearHolder();
            this.output = new byte[12];
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
                this.reader.read(this.holder);
                IntervalUtility.intToLEByteArray(this.holder.value, this.output, 0);
                Arrays.fill(this.output, 4, 8, (byte)0);
                Arrays.fill(this.output, 8, 12, (byte)0);
                ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteArray((byte[])this.output));
                ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class IntervalYearParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableIntervalYearHolder holder;
        private final byte[] output;

        public IntervalYearParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableIntervalYearHolder();
            this.output = new byte[12];
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            IntervalUtility.intToLEByteArray(this.holder.value, this.output, 0);
            Arrays.fill(this.output, 4, 8, (byte)0);
            Arrays.fill(this.output, 8, 12, (byte)0);
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteArray((byte[])this.output));
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableIntervalYearParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableIntervalYearHolder holder;
        private final byte[] output;

        public NullableIntervalYearParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableIntervalYearHolder();
            this.output = new byte[12];
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            IntervalUtility.intToLEByteArray(this.holder.value, this.output, 0);
            Arrays.fill(this.output, 4, 8, (byte)0);
            Arrays.fill(this.output, 8, 12, (byte)0);
            ParquetOutputRecordWriter.this.consumer.addBinary(Binary.fromByteArray((byte[])this.output));
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedTimeParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableTimeHolder holder;

        public RepeatedTimeParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableTimeHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                this.reader.read(i, this.holder);
                ParquetOutputRecordWriter.this.consumer.addInteger(this.holder.value);
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class TimeParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableTimeHolder holder;

        public TimeParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableTimeHolder();
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addInteger(this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableTimeParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableTimeHolder holder;

        public NullableTimeParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableTimeHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addInteger(this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedFloat4ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableFloat4Holder holder;

        public RepeatedFloat4ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableFloat4Holder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                this.reader.read(i, this.holder);
                ParquetOutputRecordWriter.this.consumer.addFloat(this.holder.value);
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class Float4ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableFloat4Holder holder;

        public Float4ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableFloat4Holder();
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addFloat(this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableFloat4ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableFloat4Holder holder;

        public NullableFloat4ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableFloat4Holder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addFloat(this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedUInt4ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableUInt4Holder holder;

        public RepeatedUInt4ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableUInt4Holder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                this.reader.read(i, this.holder);
                ParquetOutputRecordWriter.this.consumer.addInteger(this.holder.value);
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class UInt4ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableUInt4Holder holder;

        public UInt4ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableUInt4Holder();
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addInteger(this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableUInt4ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableUInt4Holder holder;

        public NullableUInt4ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableUInt4Holder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addInteger(this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedIntParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableIntHolder holder;

        public RepeatedIntParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableIntHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                this.reader.read(i, this.holder);
                ParquetOutputRecordWriter.this.consumer.addInteger(this.holder.value);
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class IntParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableIntHolder holder;

        public IntParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableIntHolder();
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addInteger(this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableIntParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableIntHolder holder;

        public NullableIntParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableIntHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addInteger(this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedSmallIntParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableSmallIntHolder holder;

        public RepeatedSmallIntParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableSmallIntHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                this.reader.read(i, this.holder);
                ParquetOutputRecordWriter.this.consumer.addInteger((int)this.holder.value);
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class SmallIntParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableSmallIntHolder holder;

        public SmallIntParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableSmallIntHolder();
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addInteger((int)this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableSmallIntParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableSmallIntHolder holder;

        public NullableSmallIntParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableSmallIntHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addInteger((int)this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedUInt2ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableUInt2Holder holder;

        public RepeatedUInt2ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableUInt2Holder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                this.reader.read(i, this.holder);
                ParquetOutputRecordWriter.this.consumer.addInteger((int)this.holder.value);
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class UInt2ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableUInt2Holder holder;

        public UInt2ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableUInt2Holder();
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addInteger((int)this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableUInt2ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableUInt2Holder holder;

        public NullableUInt2ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableUInt2Holder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addInteger((int)this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedUInt1ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableUInt1Holder holder;

        public RepeatedUInt1ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableUInt1Holder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                this.reader.read(i, this.holder);
                ParquetOutputRecordWriter.this.consumer.addInteger((int)this.holder.value);
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class UInt1ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableUInt1Holder holder;

        public UInt1ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableUInt1Holder();
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addInteger((int)this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableUInt1ParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableUInt1Holder holder;

        public NullableUInt1ParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableUInt1Holder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addInteger((int)this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedTinyIntParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableTinyIntHolder holder;

        public RepeatedTinyIntParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableTinyIntHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            for (int i = 0; i < this.reader.size(); ++i) {
                this.reader.read(i, this.holder);
                ParquetOutputRecordWriter.this.consumer.addInteger((int)this.holder.value);
            }
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class TinyIntParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableTinyIntHolder holder;

        public TinyIntParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableTinyIntHolder();
        }

        @Override
        public void writeField() throws IOException {
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addInteger((int)this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class NullableTinyIntParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private NullableTinyIntHolder holder;

        public NullableTinyIntParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.holder = new NullableTinyIntHolder();
        }

        @Override
        public void writeField() throws IOException {
            if (!this.reader.isSet()) {
                return;
            }
            ParquetOutputRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            this.reader.read(this.holder);
            ParquetOutputRecordWriter.this.consumer.addInteger((int)this.holder.value);
            ParquetOutputRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }
}

