/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public class CachedSingleFileSystem
extends FileSystem {
    private ByteBuf file;
    private String path;

    public CachedSingleFileSystem(String path) throws IOException {
        this.path = path;
        File f = new File(path);
        long length = f.length();
        if (length > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Cached file system only supports files of less than 2GB.");
        }
        System.out.println(length);
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(path));){
            int read;
            byte[] buffer = new byte[65536];
            this.file = UnpooledByteBufAllocator.DEFAULT.directBuffer((int)length);
            while ((read = ((InputStream)is).read(buffer)) > 0) {
                this.file.writeBytes(buffer, 0, read);
            }
        }
    }

    public void close() throws IOException {
        this.file.release();
        super.close();
    }

    public FSDataOutputStream append(Path arg0, int arg1, Progressable arg2) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FSDataOutputStream create(Path arg0, FsPermission arg1, boolean arg2, int arg3, short arg4, long arg5, Progressable arg6) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean delete(Path arg0) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean delete(Path arg0, boolean arg1) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FileStatus getFileStatus(Path arg0) throws IOException {
        throw new UnsupportedOperationException();
    }

    public URI getUri() {
        throw new UnsupportedOperationException();
    }

    public Path getWorkingDirectory() {
        throw new UnsupportedOperationException();
    }

    public FileStatus[] listStatus(Path arg0) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean mkdirs(Path path, FsPermission arg1) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FSDataInputStream open(Path path, int arg1) throws IOException {
        if (!path.toString().equals(this.path)) {
            throw new IOException(String.format("You requested file %s but this cached single file system only has the file %s.", path.toString(), this.path));
        }
        return new FSDataInputStream((InputStream)((Object)new CachedFSDataInputStream(this.file.slice())));
    }

    public boolean rename(Path arg0, Path arg1) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setWorkingDirectory(Path arg0) {
        throw new UnsupportedOperationException();
    }

    private class CachedFSDataInputStream
    extends ByteBufInputStream
    implements Seekable,
    PositionedReadable {
        private ByteBuf buf;

        public CachedFSDataInputStream(ByteBuf buffer) {
            super(buffer);
            this.buf = buffer;
        }

        public long getPos() throws IOException {
            return this.buf.readerIndex();
        }

        public void seek(long arg0) throws IOException {
            this.buf.readerIndex((int)arg0);
        }

        public boolean seekToNewSource(long arg0) throws IOException {
            return false;
        }

        public int read(long pos, byte[] buffer, int offset, int length) throws IOException {
            ByteBuf local = this.buf.slice((int)pos, (int)Math.min((long)this.buf.capacity() - pos, (long)length));
            local.readBytes(buffer, offset, this.buf.capacity());
            return this.buf.capacity();
        }

        public void readFully(long pos, byte[] buffer) throws IOException {
            this.readFully(pos, buffer, 0, buffer.length);
        }

        public void readFully(long pos, byte[] buffer, int offset, int length) throws IOException {
            if ((long)length + pos > (long)this.buf.capacity()) {
                throw new IOException("Read was too big.");
            }
            this.read(pos, buffer, offset, length);
        }
    }
}

