/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

public class ByteArrayUtil {
    public static byte[] toByta(Object data) throws Exception {
        if (data instanceof Integer) {
            return ByteArrayUtil.toByta((Integer)data);
        }
        if (data instanceof Double) {
            return ByteArrayUtil.toByta((Double)data);
        }
        if (data instanceof Float) {
            return ByteArrayUtil.toByta(((Float)data).floatValue());
        }
        if (data instanceof Boolean) {
            return ByteArrayUtil.toByta((Boolean)data);
        }
        if (data instanceof Long) {
            return ByteArrayUtil.toByta((Long)data);
        }
        throw new Exception("Cannot convert that type to a byte array.");
    }

    public static byte[] toByta(byte data) {
        return new byte[]{data};
    }

    public static byte[] toByta(byte[] data) {
        return data;
    }

    public static byte[] toByta(short data) {
        return new byte[]{(byte)(data >> 8 & 0xFF), (byte)(data >> 0 & 0xFF)};
    }

    public static byte[] toByta(short[] data) {
        if (data == null) {
            return null;
        }
        byte[] byts = new byte[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(ByteArrayUtil.toByta(data[i]), 0, byts, i * 2, 2);
        }
        return byts;
    }

    public static byte[] toByta(char data) {
        return new byte[]{(byte)(data >> 8 & 0xFF), (byte)(data >> 0 & 0xFF)};
    }

    public static byte[] toByta(char[] data) {
        if (data == null) {
            return null;
        }
        byte[] byts = new byte[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(ByteArrayUtil.toByta(data[i]), 0, byts, i * 2, 2);
        }
        return byts;
    }

    public static byte[] toByta(int data) {
        return new byte[]{(byte)(data >> 0 & 0xFF), (byte)(data >> 8 & 0xFF), (byte)(data >> 16 & 0xFF), (byte)(data >> 24 & 0xFF)};
    }

    public static byte[] toByta(int[] data) {
        if (data == null) {
            return null;
        }
        byte[] byts = new byte[data.length * 4];
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(ByteArrayUtil.toByta(data[i]), 0, byts, i * 4, 4);
        }
        return byts;
    }

    public static byte[] toByta(long data) {
        return new byte[]{(byte)(data >> 0 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 56 & 0xFFL)};
    }

    public static byte[] toByta(long[] data) {
        if (data == null) {
            return null;
        }
        byte[] byts = new byte[data.length * 8];
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(ByteArrayUtil.toByta(data[i]), 0, byts, i * 8, 8);
        }
        return byts;
    }

    public static byte[] toByta(float data) {
        return ByteArrayUtil.toByta(Float.floatToRawIntBits(data));
    }

    public static byte[] toByta(float[] data) {
        if (data == null) {
            return null;
        }
        byte[] byts = new byte[data.length * 4];
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(ByteArrayUtil.toByta(data[i]), 0, byts, i * 4, 4);
        }
        return byts;
    }

    public static byte[] toByta(double data) {
        return ByteArrayUtil.toByta(Double.doubleToRawLongBits(data));
    }

    public static byte[] toByta(double[] data) {
        if (data == null) {
            return null;
        }
        byte[] byts = new byte[data.length * 8];
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(ByteArrayUtil.toByta(data[i]), 0, byts, i * 8, 8);
        }
        return byts;
    }

    public static byte[] toByta(boolean data) {
        return new byte[]{(byte)(data ? 1 : 0)};
    }

    public static byte[] toByta(boolean[] data) {
        if (data == null) {
            return null;
        }
        int len = data.length;
        byte[] lena = ByteArrayUtil.toByta(len);
        byte[] byts = new byte[lena.length + len / 8 + (len % 8 != 0 ? 1 : 0)];
        System.arraycopy(lena, 0, byts, 0, lena.length);
        int j = lena.length;
        int k = 7;
        for (int i = 0; i < data.length; ++i) {
            int n = j;
            byts[n] = (byte)(byts[n] | (data[i] ? 1 : 0) << k--);
            if (k >= 0) continue;
            ++j;
            k = 7;
        }
        return byts;
    }
}

