/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.sql;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.drill.exec.sql.TestBaseViewSupport;
import org.junit.Ignore;
import org.junit.Test;

public class TestViewSupport
extends TestBaseViewSupport {
    @Test
    public void referToSchemaInsideAndOutsideView() throws Exception {
        String use = "use dfs_test.tmp;";
        String selectInto = "create table monkey as select c_custkey, c_nationkey from cp.`tpch/customer.parquet`";
        String createView = "create or replace view myMonkeyView as select c_custkey, c_nationkey from monkey";
        String selectInside = "select * from myMonkeyView;";
        String use2 = "use cp;";
        String selectOutside = "select * from dfs_test.tmp.myMonkeyView;";
        TestViewSupport.test(use);
        TestViewSupport.test(selectInto);
        TestViewSupport.test(createView);
        TestViewSupport.test(selectInside);
        TestViewSupport.test(use2);
        TestViewSupport.test(selectOutside);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void nullabilityPropertyInViewPersistence() throws Exception {
        String viewName = "testNullabilityPropertyInViewPersistence";
        try {
            TestViewSupport.test("USE dfs_test.tmp");
            TestViewSupport.test(String.format("CREATE OR REPLACE VIEW %s AS SELECT CAST(customer_id AS BIGINT) as cust_id, CAST(fname AS VARCHAR(25)) as fname, CAST(country AS VARCHAR(20)) as country FROM cp.`customer.json` ORDER BY customer_id LIMIT 1;", "testNullabilityPropertyInViewPersistence"));
            TestViewSupport.testBuilder().sqlQuery(String.format("DESCRIBE %s", "testNullabilityPropertyInViewPersistence")).unOrdered().baselineColumns("COLUMN_NAME", "DATA_TYPE", "IS_NULLABLE").baselineValues("cust_id", "BIGINT", "YES").baselineValues("fname", "CHARACTER VARYING", "YES").baselineValues("country", "CHARACTER VARYING", "YES").go();
            TestViewSupport.testBuilder().sqlQuery(String.format("SELECT * FROM %s", "testNullabilityPropertyInViewPersistence")).ordered().baselineColumns("cust_id", "fname", "country").baselineValues(1L, "Sheri", "Mexico").go();
        }
        finally {
            TestViewSupport.test("drop view testNullabilityPropertyInViewPersistence;");
        }
    }

    @Test
    public void viewWithStarInDef_StarInQuery() throws Exception {
        TestViewSupport.testViewHelper("dfs_test.tmp", null, "SELECT * FROM cp.`region.json` ORDER BY `region_id`", "SELECT * FROM TEST_SCHEMA.TEST_VIEW_NAME LIMIT 1", new String[]{"region_id", "sales_city", "sales_state_province", "sales_district", "sales_region", "sales_country", "sales_district_id"}, (List<Object[]>)ImmutableList.of((Object)new Object[]{0L, "None", "None", "No District", "No Region", "No Country", 0L}));
    }

    @Test
    public void viewWithSelectFieldsInDef_StarInQuery() throws Exception {
        TestViewSupport.testViewHelper("dfs_test.tmp", null, "SELECT region_id, sales_city FROM cp.`region.json` ORDER BY `region_id`", "SELECT * FROM TEST_SCHEMA.TEST_VIEW_NAME LIMIT 2", new String[]{"region_id", "sales_city"}, (List<Object[]>)ImmutableList.of((Object)new Object[]{0L, "None"}, (Object)new Object[]{1L, "San Francisco"}));
    }

    @Test
    public void viewWithSelectFieldsInDef_SelectFieldsInView_StarInQuery() throws Exception {
        TestViewSupport.testViewHelper("dfs_test.tmp", "(regionid, salescity)", "SELECT region_id, sales_city FROM cp.`region.json` ORDER BY `region_id`", "SELECT * FROM TEST_SCHEMA.TEST_VIEW_NAME LIMIT 2", new String[]{"regionid", "salescity"}, (List<Object[]>)ImmutableList.of((Object)new Object[]{0L, "None"}, (Object)new Object[]{1L, "San Francisco"}));
    }

    @Test
    public void viewWithStarInDef_SelectFieldsInQuery() throws Exception {
        TestViewSupport.testViewHelper("dfs_test.tmp", null, "SELECT * FROM cp.`region.json` ORDER BY `region_id`", "SELECT region_id, sales_city FROM TEST_SCHEMA.TEST_VIEW_NAME LIMIT 2", new String[]{"region_id", "sales_city"}, (List<Object[]>)ImmutableList.of((Object)new Object[]{0L, "None"}, (Object)new Object[]{1L, "San Francisco"}));
    }

    @Test
    public void viewWithSelectFieldsInDef_SelectFieldsInQuery1() throws Exception {
        TestViewSupport.testViewHelper("dfs_test.tmp", null, "SELECT region_id, sales_city FROM cp.`region.json` ORDER BY `region_id`", "SELECT region_id, sales_city FROM TEST_SCHEMA.TEST_VIEW_NAME LIMIT 2", new String[]{"region_id", "sales_city"}, (List<Object[]>)ImmutableList.of((Object)new Object[]{0L, "None"}, (Object)new Object[]{1L, "San Francisco"}));
    }

    @Test
    public void viewWithSelectFieldsInDef_SelectFieldsInQuery2() throws Exception {
        TestViewSupport.testViewHelper("dfs_test.tmp", null, "SELECT region_id, sales_city FROM cp.`region.json` ORDER BY `region_id`", "SELECT sales_city FROM TEST_SCHEMA.TEST_VIEW_NAME LIMIT 2", new String[]{"sales_city"}, (List<Object[]>)ImmutableList.of((Object)new Object[]{"None"}, (Object)new Object[]{"San Francisco"}));
    }

    @Test
    public void viewWithSelectFieldsInDef_SelectFieldsInView_SelectFieldsInQuery1() throws Exception {
        TestViewSupport.testViewHelper("dfs_test.tmp", "(regionid, salescity)", "SELECT region_id, sales_city FROM cp.`region.json` ORDER BY `region_id` LIMIT 2", "SELECT regionid, salescity FROM TEST_SCHEMA.TEST_VIEW_NAME LIMIT 2", new String[]{"regionid", "salescity"}, (List<Object[]>)ImmutableList.of((Object)new Object[]{0L, "None"}, (Object)new Object[]{1L, "San Francisco"}));
    }

    @Test
    public void viewWithSelectFieldsInDef_SelectFieldsInView_SelectFieldsInQuery2() throws Exception {
        TestViewSupport.testViewHelper("dfs_test.tmp", "(regionid, salescity)", "SELECT region_id, sales_city FROM cp.`region.json` ORDER BY `region_id` DESC", "SELECT regionid FROM TEST_SCHEMA.TEST_VIEW_NAME LIMIT 2", new String[]{"regionid"}, (List<Object[]>)ImmutableList.of((Object)new Object[]{109L}, (Object)new Object[]{108L}));
    }

    @Test
    @Ignore(value="DRILL-1921")
    public void viewWithUnionWithSelectFieldsInDef_StarInQuery() throws Exception {
        TestViewSupport.testViewHelper("dfs_test.tmp", null, "SELECT region_id FROM cp.`region.json` UNION SELECT employee_id FROM cp.`employee.json`", "SELECT regionid FROM TEST_SCHEMA.TEST_VIEW_NAME LIMIT 2", new String[]{"regionid"}, (List<Object[]>)ImmutableList.of((Object)new Object[]{110L}, (Object)new Object[]{108L}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void viewCreatedFromAnotherView() throws Exception {
        String innerView = TestViewSupport.generateViewName();
        String outerView = TestViewSupport.generateViewName();
        try {
            TestViewSupport.createViewHelper("dfs_test.tmp", innerView, "dfs_test.tmp", null, "SELECT region_id, sales_city FROM cp.`region.json` ORDER BY `region_id`");
            TestViewSupport.createViewHelper("dfs_test.tmp", outerView, "dfs_test.tmp", null, String.format("SELECT region_id FROM %s.`%s`", "dfs_test.tmp", innerView));
            TestViewSupport.queryViewHelper(String.format("SELECT region_id FROM %s.`%s` LIMIT 1", "dfs_test.tmp", outerView), new String[]{"region_id"}, (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
        }
        finally {
            TestViewSupport.dropViewHelper("dfs_test.tmp", outerView, "dfs_test.tmp");
            TestViewSupport.dropViewHelper("dfs_test.tmp", innerView, "dfs_test.tmp");
        }
    }

    @Test
    public void viewWithCompoundIdentifiersInDef() throws Exception {
        String viewDef = "SELECT cast(columns[0] AS int) n_nationkey, cast(columns[1] AS CHAR(25)) n_name, cast(columns[2] AS INT) n_regionkey, cast(columns[3] AS VARCHAR(152)) n_comment FROM dfs_test.`[WORKING_PATH]/src/test/resources/nation`";
        TestViewSupport.testViewHelper("dfs_test.tmp", null, "SELECT cast(columns[0] AS int) n_nationkey, cast(columns[1] AS CHAR(25)) n_name, cast(columns[2] AS INT) n_regionkey, cast(columns[3] AS VARCHAR(152)) n_comment FROM dfs_test.`[WORKING_PATH]/src/test/resources/nation`", "SELECT * FROM TEST_SCHEMA.TEST_VIEW_NAME LIMIT 1", new String[]{"n_nationkey", "n_name", "n_regionkey", "n_comment"}, (List<Object[]>)ImmutableList.of((Object)new Object[]{0, "ALGERIA", 0, " haggle. carefully final deposits detect slyly agai"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createViewWhenViewAlreadyExists() throws Exception {
        String viewName = TestViewSupport.generateViewName();
        try {
            String viewDef1 = "SELECT region_id, sales_city FROM cp.`region.json`";
            TestViewSupport.createViewHelper("dfs_test.tmp", viewName, "dfs_test.tmp", null, "SELECT region_id, sales_city FROM cp.`region.json`");
            String createViewSql = String.format("CREATE VIEW %s.`%s` AS %s", "dfs_test.tmp", viewName, "SELECT region_id, sales_city FROM cp.`region.json`");
            TestViewSupport.errorMsgTestHelper(createViewSql, String.format("A view with given name [%s] already exists in schema [%s]", viewName, "dfs_test.tmp"));
            String viewDef2 = "SELECT sales_state_province FROM cp.`region.json` ORDER BY `region_id`";
            String createOrReplaceViewSql = String.format("CREATE OR REPLACE VIEW %s.`%s` AS %s", "dfs_test.tmp", viewName, "SELECT sales_state_province FROM cp.`region.json` ORDER BY `region_id`");
            TestViewSupport.testBuilder().sqlQuery(createOrReplaceViewSql).unOrdered().baselineColumns("ok", "summary").baselineValues(true, String.format("View '%s' replaced successfully in '%s' schema", viewName, "dfs_test.tmp")).go();
            TestViewSupport.queryViewHelper(String.format("SELECT * FROM %s.`%s` LIMIT 1", "dfs_test.tmp", viewName), new String[]{"sales_state_province"}, (List<Object[]>)ImmutableList.of((Object)new Object[]{"None"}));
        }
        finally {
            TestViewSupport.dropViewHelper("dfs_test.tmp", viewName, "dfs_test.tmp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createViewWhenATableWithSameNameAlreadyExists() throws Exception {
        String tableName = TestViewSupport.generateViewName();
        try {
            String tableDef1 = "SELECT region_id, sales_city FROM cp.`region.json`";
            TestViewSupport.test(String.format("CREATE TABLE %s.%s as %s", "dfs_test.tmp", tableName, "SELECT region_id, sales_city FROM cp.`region.json`"));
            String createViewSql = String.format("CREATE VIEW %s.`%s` AS %s", "dfs_test.tmp", tableName, "SELECT region_id, sales_city FROM cp.`region.json`");
            TestViewSupport.errorMsgTestHelper(createViewSql, String.format("A non-view table with given name [%s] already exists in schema [%s]", tableName, "dfs_test.tmp"));
            String viewDef2 = "SELECT sales_state_province FROM cp.`region.json` ORDER BY `region_id`";
            TestViewSupport.errorMsgTestHelper(String.format("CREATE OR REPLACE VIEW %s.`%s` AS %s", "dfs_test.tmp", tableName, "SELECT sales_state_province FROM cp.`region.json` ORDER BY `region_id`"), String.format("A non-view table with given name [%s] already exists in schema [%s]", tableName, "dfs_test.tmp"));
        }
        finally {
            FileUtils.deleteQuietly((File)new File(TestViewSupport.getDfsTestTmpSchemaLocation(), tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void infoSchemaWithView() throws Exception {
        String viewName = TestViewSupport.generateViewName();
        try {
            TestViewSupport.test("USE dfs_test.tmp");
            TestViewSupport.createViewHelper(null, viewName, "dfs_test.tmp", null, "SELECT cast(`employee_id` as integer) employeeid FROM cp.`employee.json`");
            TestViewSupport.testBuilder().sqlQuery(String.format("SHOW TABLES like '%s'", viewName)).unOrdered().baselineColumns("TABLE_SCHEMA", "TABLE_NAME").baselineValues("dfs_test.tmp", viewName).go();
            TestViewSupport.testBuilder().sqlQuery(String.format("SELECT * FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = '%s'", viewName)).unOrdered().baselineColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "VIEW_DEFINITION").baselineValues("DRILL", "dfs_test.tmp", viewName, "SELECT CAST(`employee_id` AS INTEGER) AS `employeeid`\nFROM `cp`.`employee.json`").go();
            TestViewSupport.testBuilder().sqlQuery(String.format("SELECT * FROM INFORMATION_SCHEMA.`TABLES` WHERE TABLE_NAME = '%s'", viewName)).unOrdered().baselineColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "TABLE_TYPE").baselineValues("DRILL", "dfs_test.tmp", viewName, "VIEW").go();
            TestViewSupport.testBuilder().sqlQuery(String.format("DESCRIBE `%s`", viewName)).unOrdered().baselineColumns("COLUMN_NAME", "DATA_TYPE", "IS_NULLABLE").baselineValues("employeeid", "INTEGER", "YES").go();
        }
        finally {
            TestViewSupport.dropViewHelper("dfs_test.tmp", viewName, "dfs_test.tmp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void viewWithPartialSchemaIdentifier() throws Exception {
        String viewName = TestViewSupport.generateViewName();
        try {
            TestViewSupport.test("USE dfs_test");
            TestViewSupport.createViewHelper("tmp", viewName, "dfs_test.tmp", null, "SELECT CAST(`employee_id` AS INTEGER) AS `employeeid`\nFROM `cp`.`employee.json`");
            String[] baselineColumns = new String[]{"employeeid"};
            ImmutableList baselineValues = ImmutableList.of((Object)new Object[]{1156});
            TestViewSupport.queryViewHelper(String.format("SELECT * FROM %s.`%s` ORDER BY `employeeid` DESC LIMIT 1", "tmp", viewName), baselineColumns, (List<Object[]>)baselineValues);
            TestViewSupport.test("USE dfs_test.tmp");
            TestViewSupport.queryViewHelper(String.format("SELECT * FROM `%s` ORDER BY `employeeid` DESC LIMIT 1", viewName), baselineColumns, (List<Object[]>)baselineValues);
            TestViewSupport.test("USE cp");
            TestViewSupport.queryViewHelper(String.format("SELECT * FROM %s.`%s` ORDER BY `employeeid` DESC LIMIT 1", "dfs_test.tmp", viewName), baselineColumns, (List<Object[]>)baselineValues);
        }
        finally {
            TestViewSupport.dropViewHelper("dfs_test.tmp", viewName, "dfs_test.tmp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void viewResolvingTablesInWorkspaceSchema() throws Exception {
        String viewName = TestViewSupport.generateViewName();
        try {
            TestViewSupport.test("USE cp");
            TestViewSupport.createViewHelper("dfs_test.tmp", viewName, "dfs_test.tmp", null, "SELECT region_id, sales_city FROM `region.json`");
            String[] baselineColumns = new String[]{"region_id", "sales_city"};
            ImmutableList baselineValues = ImmutableList.of((Object)new Object[]{109L, "Santa Fe"});
            TestViewSupport.queryViewHelper(String.format("SELECT * FROM %s.`%s` ORDER BY region_id DESC LIMIT 1", "dfs_test.tmp", viewName), baselineColumns, (List<Object[]>)baselineValues);
            TestViewSupport.test("USE dfs_test");
            TestViewSupport.queryViewHelper(String.format("SELECT * FROM %s.`%s` ORDER BY region_id DESC LIMIT 1", "tmp", viewName), baselineColumns, (List<Object[]>)baselineValues);
        }
        finally {
            TestViewSupport.dropViewHelper("dfs_test.tmp", viewName, "dfs_test.tmp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void viewSchemaWhenSelectFieldsInDef_SelectFieldsInView() throws Exception {
        String viewName = TestViewSupport.generateViewName();
        try {
            TestViewSupport.test("USE dfs_test.tmp");
            TestViewSupport.createViewHelper(null, viewName, "dfs_test.tmp", "(id, name, bday)", "SELECT cast(`region_id` as integer), cast(`full_name` as varchar(100)), cast(`birth_date` as date) FROM cp.`employee.json`");
            TestViewSupport.testBuilder().sqlQuery(String.format("DESCRIBE `%s`", viewName)).unOrdered().baselineColumns("COLUMN_NAME", "DATA_TYPE", "IS_NULLABLE").baselineValues("id", "INTEGER", "YES").baselineValues("name", "CHARACTER VARYING", "YES").baselineValues("bday", "DATE", "YES").go();
        }
        finally {
            TestViewSupport.dropViewHelper("dfs_test.tmp", viewName, "dfs_test.tmp");
        }
    }

    @Test
    public void createViewWithDuplicateColumnsInDef1() throws Exception {
        TestViewSupport.createViewErrorTestHelper("CREATE VIEW %s.%s AS SELECT region_id, region_id FROM cp.`region.json`", String.format("Duplicate column name [%s]", "region_id"));
    }

    @Test
    public void createViewWithDuplicateColumnsInDef2() throws Exception {
        TestViewSupport.createViewErrorTestHelper("CREATE VIEW %s.%s AS SELECT region_id, sales_city, sales_city FROM cp.`region.json`", String.format("Duplicate column name [%s]", "sales_city"));
    }

    @Test
    public void createViewWithDuplicateColumnsInDef3() throws Exception {
        TestViewSupport.createViewErrorTestHelper("CREATE VIEW %s.%s(regionid, regionid) AS SELECT region_id, sales_city FROM cp.`region.json`", String.format("Duplicate column name [%s]", "regionid"));
    }

    @Test
    public void createViewWithDuplicateColumnsInDef4() throws Exception {
        TestViewSupport.createViewErrorTestHelper("CREATE VIEW %s.%s(regionid, salescity, salescity) AS SELECT region_id, sales_city, sales_city FROM cp.`region.json`", String.format("Duplicate column name [%s]", "salescity"));
    }

    @Test
    public void createViewWithDuplicateColumnsInDef5() throws Exception {
        TestViewSupport.createViewErrorTestHelper("CREATE VIEW %s.%s(regionid, salescity, SalesCity) AS SELECT region_id, sales_city, sales_city FROM cp.`region.json`", String.format("Duplicate column name [%s]", "SalesCity"));
    }

    @Test
    public void createViewWithDuplicateColumnsInDef6() throws Exception {
        TestViewSupport.createViewErrorTestHelper("CREATE VIEW %s.%s AS SELECT t1.region_id, t2.region_id FROM cp.`region.json` t1 JOIN cp.`region.json` t2 ON t1.region_id = t2.region_id LIMIT 1", String.format("Duplicate column name [%s]", "region_id"));
    }

    @Test
    public void createViewWithUniqueColsInFieldListDuplicateColsInQuery1() throws Exception {
        TestViewSupport.testViewHelper("dfs_test.tmp", "(regionid1, regionid2)", "SELECT region_id, region_id FROM cp.`region.json` LIMIT 1", "SELECT * FROM TEST_SCHEMA.TEST_VIEW_NAME", new String[]{"regionid1", "regionid2"}, (List<Object[]>)ImmutableList.of((Object)new Object[]{0L, 0L}));
    }

    @Test
    public void createViewWithUniqueColsInFieldListDuplicateColsInQuery2() throws Exception {
        TestViewSupport.testViewHelper("dfs_test.tmp", "(regionid1, regionid2)", "SELECT t1.region_id, t2.region_id FROM cp.`region.json` t1 JOIN cp.`region.json` t2 ON t1.region_id = t2.region_id LIMIT 1", "SELECT * FROM TEST_SCHEMA.TEST_VIEW_NAME", new String[]{"regionid1", "regionid2"}, (List<Object[]>)ImmutableList.of((Object)new Object[]{0L, 0L}));
    }

    @Test
    public void createViewWhenInEqualColumnCountInViewDefVsInViewQuery() throws Exception {
        TestViewSupport.createViewErrorTestHelper("CREATE VIEW %s.%s(regionid, salescity) AS SELECT region_id, sales_city, sales_region FROM cp.`region.json`", "view's field list and the view's query field list have different counts.");
    }

    @Test
    public void createViewWhenViewQueryColumnHasStarAndViewFiledListIsSpecified() throws Exception {
        TestViewSupport.createViewErrorTestHelper("CREATE VIEW %s.%s(regionid, salescity) AS SELECT region_id, * FROM cp.`region.json`", "view's query field list has a '*', which is invalid when view's field list is specified.");
    }

    private static void createViewErrorTestHelper(String viewSql, String expErrorMsg) throws Exception {
        String createViewSql = String.format(viewSql, "dfs_test.tmp", "duplicateColumnsInViewDef");
        TestViewSupport.errorMsgTestHelper(createViewSql, expErrorMsg);
    }

    @Test
    public void showProperMsgWhenDroppingNonExistentView() throws Exception {
        TestViewSupport.errorMsgTestHelper("DROP VIEW dfs_test.tmp.nonExistentView", "Unknown view [nonExistentView] in schema [dfs_test.tmp].");
    }

    @Test
    public void showProperMsgWhenTryingToDropAViewInImmutableSchema() throws Exception {
        TestViewSupport.errorMsgTestHelper("DROP VIEW cp.nonExistentView", "Unable to create or drop tables/views. Schema [cp] is immutable.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void showProperMsgWhenTryingToDropANonViewTable() throws Exception {
        String testTableName = "testTableShowErrorMsg";
        try {
            TestViewSupport.test(String.format("CREATE TABLE %s.%s AS SELECT c_custkey, c_nationkey from cp.`tpch/customer.parquet`", "dfs_test.tmp", "testTableShowErrorMsg"));
            TestViewSupport.errorMsgTestHelper(String.format("DROP VIEW %s.%s", "dfs_test.tmp", "testTableShowErrorMsg"), "[testTableShowErrorMsg] is not a VIEW in schema [dfs_test.tmp]");
        }
        finally {
            File tblPath = new File(TestViewSupport.getDfsTestTmpSchemaLocation(), "testTableShowErrorMsg");
            FileUtils.deleteQuietly((File)tblPath);
        }
    }
}

