/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.sql;

import org.apache.calcite.config.Lex;
import org.apache.calcite.jdbc.SimpleCalciteSchema;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.drill.exec.planner.sql.DrillConvertletTable;
import org.apache.drill.exec.planner.sql.parser.CompoundIdentifierConverter;
import org.apache.drill.exec.planner.sql.parser.impl.DrillParserImpl;
import org.apache.drill.test.DrillAssert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSqlBracketlessSyntax {
    static final Logger logger = LoggerFactory.getLogger(TestSqlBracketlessSyntax.class);

    @Test
    public void checkComplexExpressionParsing() throws Exception {
        FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(SqlParser.configBuilder().setLex(Lex.MYSQL).setIdentifierMaxLength(1024).setParserFactory(DrillParserImpl.FACTORY).build()).defaultSchema(SimpleCalciteSchema.createRootSchema((boolean)false)).convertletTable((SqlRexConvertletTable)new DrillConvertletTable()).build();
        Planner planner = Frameworks.getPlanner((FrameworkConfig)config);
        SqlNode node = planner.parse("select a[4].c \nfrom x.y.z \nwhere a.c.b = 5 and x[2] = 7 \ngroup by d \nhaving a.c < 5 \norder by x.a.a.a.a.a");
        String expected = "SELECT `a`[4]['c']\nFROM `x`.`y`.`z`\nWHERE `a`.`c`['b'] = 5 AND `x`[2] = 7\nGROUP BY `d`\nHAVING `a`.`c` < 5\nORDER BY `x`.`a`['a']['a']['a']['a']";
        SqlNode rewritten = (SqlNode)node.accept((SqlVisitor)new CompoundIdentifierConverter());
        String rewrittenQuery = rewritten.toString();
        DrillAssert.assertMultiLineStringEquals((String)expected, (String)rewrittenQuery);
    }
}

