/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.sql;

import com.google.common.collect.ImmutableList;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.TestBuilder;
import org.junit.Test;

public class TestInfoSchema
extends BaseTestQuery {
    @Test
    public void selectFromAllTables() throws Exception {
        TestInfoSchema.test("select * from INFORMATION_SCHEMA.SCHEMATA");
        TestInfoSchema.test("select * from INFORMATION_SCHEMA.CATALOGS");
        TestInfoSchema.test("select * from INFORMATION_SCHEMA.VIEWS");
        TestInfoSchema.test("select * from INFORMATION_SCHEMA.`TABLES`");
        TestInfoSchema.test("select * from INFORMATION_SCHEMA.COLUMNS");
    }

    @Test
    public void showTablesFromDb() throws Exception {
        ImmutableList expected = ImmutableList.of((Object)new String[]{"INFORMATION_SCHEMA", "VIEWS"}, (Object)new String[]{"INFORMATION_SCHEMA", "COLUMNS"}, (Object)new String[]{"INFORMATION_SCHEMA", "TABLES"}, (Object)new String[]{"INFORMATION_SCHEMA", "CATALOGS"}, (Object)new String[]{"INFORMATION_SCHEMA", "SCHEMATA"});
        TestBuilder t1 = TestInfoSchema.testBuilder().sqlQuery("SHOW TABLES FROM INFORMATION_SCHEMA").unOrdered().baselineColumns("TABLE_SCHEMA", "TABLE_NAME");
        for (Object[] expectedRow : expected) {
            t1.baselineValues(expectedRow);
        }
        t1.go();
        TestBuilder t2 = TestInfoSchema.testBuilder().sqlQuery("SHOW TABLES IN INFORMATION_SCHEMA").unOrdered().baselineColumns("TABLE_SCHEMA", "TABLE_NAME");
        for (Object[] expectedRow : expected) {
            t2.baselineValues(expectedRow);
        }
        t2.go();
    }

    @Test
    public void showTablesFromDbWhere() throws Exception {
        TestInfoSchema.testBuilder().sqlQuery("SHOW TABLES FROM INFORMATION_SCHEMA WHERE TABLE_NAME='VIEWS'").unOrdered().baselineColumns("TABLE_SCHEMA", "TABLE_NAME").baselineValues("INFORMATION_SCHEMA", "VIEWS").go();
    }

    @Test
    public void showTablesLike() throws Exception {
        TestInfoSchema.testBuilder().sqlQuery("SHOW TABLES LIKE '%CH%'").unOrdered().optionSettingQueriesForTestQuery("USE INFORMATION_SCHEMA").baselineColumns("TABLE_SCHEMA", "TABLE_NAME").baselineValues("INFORMATION_SCHEMA", "SCHEMATA").go();
    }

    @Test
    public void showDatabases() throws Exception {
        ImmutableList expected = ImmutableList.of((Object)new String[]{"dfs.default"}, (Object)new String[]{"dfs.root"}, (Object)new String[]{"dfs.tmp"}, (Object)new String[]{"cp.default"}, (Object)new String[]{"sys"}, (Object)new String[]{"dfs_test.home"}, (Object)new String[]{"dfs_test.default"}, (Object)new String[]{"dfs_test.tmp"}, (Object)new String[]{"INFORMATION_SCHEMA"});
        TestBuilder t1 = TestInfoSchema.testBuilder().sqlQuery("SHOW DATABASES").unOrdered().baselineColumns("SCHEMA_NAME");
        for (Object[] expectedRow : expected) {
            t1.baselineValues(expectedRow);
        }
        t1.go();
        TestBuilder t2 = TestInfoSchema.testBuilder().sqlQuery("SHOW SCHEMAS").unOrdered().baselineColumns("SCHEMA_NAME");
        for (Object[] expectedRow : expected) {
            t2.baselineValues(expectedRow);
        }
        t2.go();
    }

    @Test
    public void showDatabasesWhere() throws Exception {
        TestInfoSchema.testBuilder().sqlQuery("SHOW DATABASES WHERE SCHEMA_NAME='dfs_test.tmp'").unOrdered().baselineColumns("SCHEMA_NAME").baselineValues("dfs_test.tmp").go();
    }

    @Test
    public void showDatabasesLike() throws Exception {
        TestInfoSchema.testBuilder().sqlQuery("SHOW DATABASES LIKE '%y%'").unOrdered().baselineColumns("SCHEMA_NAME").baselineValues("sys").go();
    }

    @Test
    public void describeTable() throws Exception {
        TestInfoSchema.testBuilder().sqlQuery("DESCRIBE CATALOGS").unOrdered().optionSettingQueriesForTestQuery("USE INFORMATION_SCHEMA").baselineColumns("COLUMN_NAME", "DATA_TYPE", "IS_NULLABLE").baselineValues("CATALOG_NAME", "CHARACTER VARYING", "NO").baselineValues("CATALOG_DESCRIPTION", "CHARACTER VARYING", "NO").baselineValues("CATALOG_CONNECT", "CHARACTER VARYING", "NO").go();
    }

    @Test
    public void describeTableWithSchema() throws Exception {
        TestInfoSchema.testBuilder().sqlQuery("DESCRIBE INFORMATION_SCHEMA.`TABLES`").unOrdered().baselineColumns("COLUMN_NAME", "DATA_TYPE", "IS_NULLABLE").baselineValues("TABLE_CATALOG", "CHARACTER VARYING", "NO").baselineValues("TABLE_SCHEMA", "CHARACTER VARYING", "NO").baselineValues("TABLE_NAME", "CHARACTER VARYING", "NO").baselineValues("TABLE_TYPE", "CHARACTER VARYING", "NO").go();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void describeWhenSameTableNameExistsInMultipleSchemas() throws Exception {
        try {
            TestInfoSchema.test("USE dfs_test.tmp");
            TestInfoSchema.test("CREATE OR REPLACE VIEW `TABLES` AS SELECT full_name FROM cp.`employee.json`");
            TestInfoSchema.testBuilder().sqlQuery("DESCRIBE `TABLES`").unOrdered().optionSettingQueriesForTestQuery("USE dfs_test.tmp").baselineColumns("COLUMN_NAME", "DATA_TYPE", "IS_NULLABLE").baselineValues("full_name", "ANY", "YES").go();
            TestInfoSchema.testBuilder().sqlQuery("DESCRIBE INFORMATION_SCHEMA.`TABLES`").unOrdered().baselineColumns("COLUMN_NAME", "DATA_TYPE", "IS_NULLABLE").baselineValues("TABLE_CATALOG", "CHARACTER VARYING", "NO").baselineValues("TABLE_SCHEMA", "CHARACTER VARYING", "NO").baselineValues("TABLE_NAME", "CHARACTER VARYING", "NO").baselineValues("TABLE_TYPE", "CHARACTER VARYING", "NO").go();
        }
        finally {
            TestInfoSchema.test("DROP VIEW dfs_test.tmp.`TABLES`");
        }
    }

    @Test
    public void describeTableWithColumnName() throws Exception {
        TestInfoSchema.testBuilder().sqlQuery("DESCRIBE `TABLES` TABLE_CATALOG").unOrdered().optionSettingQueriesForTestQuery("USE INFORMATION_SCHEMA").baselineColumns("COLUMN_NAME", "DATA_TYPE", "IS_NULLABLE").baselineValues("TABLE_CATALOG", "CHARACTER VARYING", "NO").go();
    }

    @Test
    public void describeTableWithSchemaAndColumnName() throws Exception {
        TestInfoSchema.testBuilder().sqlQuery("DESCRIBE INFORMATION_SCHEMA.`TABLES` TABLE_CATALOG").unOrdered().baselineColumns("COLUMN_NAME", "DATA_TYPE", "IS_NULLABLE").baselineValues("TABLE_CATALOG", "CHARACTER VARYING", "NO").go();
    }

    @Test
    public void describeTableWithColQualifier() throws Exception {
        TestInfoSchema.testBuilder().sqlQuery("DESCRIBE COLUMNS 'TABLE%'").unOrdered().optionSettingQueriesForTestQuery("USE INFORMATION_SCHEMA").baselineColumns("COLUMN_NAME", "DATA_TYPE", "IS_NULLABLE").baselineValues("TABLE_CATALOG", "CHARACTER VARYING", "NO").baselineValues("TABLE_SCHEMA", "CHARACTER VARYING", "NO").baselineValues("TABLE_NAME", "CHARACTER VARYING", "NO").go();
    }

    @Test
    public void describeTableWithSchemaAndColQualifier() throws Exception {
        TestInfoSchema.testBuilder().sqlQuery("DESCRIBE INFORMATION_SCHEMA.SCHEMATA 'SCHEMA%'").unOrdered().baselineColumns("COLUMN_NAME", "DATA_TYPE", "IS_NULLABLE").baselineValues("SCHEMA_NAME", "CHARACTER VARYING", "NO").baselineValues("SCHEMA_OWNER", "CHARACTER VARYING", "NO").go();
    }

    @Test
    public void defaultSchemaDfs() throws Exception {
        TestInfoSchema.testBuilder().sqlQuery("SELECT R_REGIONKEY FROM `[WORKING_PATH]/../../sample-data/region.parquet` LIMIT 1").unOrdered().optionSettingQueriesForTestQuery("USE dfs_test").baselineColumns("R_REGIONKEY").baselineValues(0L).go();
    }

    @Test
    public void defaultSchemaClasspath() throws Exception {
        TestInfoSchema.testBuilder().sqlQuery("SELECT full_name FROM `employee.json` LIMIT 1").unOrdered().optionSettingQueriesForTestQuery("USE cp").baselineColumns("full_name").baselineValues("Sheri Nowmer").go();
    }

    @Test
    public void queryFromNonDefaultSchema() throws Exception {
        TestInfoSchema.testBuilder().sqlQuery("SELECT full_name FROM cp.`employee.json` LIMIT 1").unOrdered().optionSettingQueriesForTestQuery("USE dfs_test").baselineColumns("full_name").baselineValues("Sheri Nowmer").go();
    }

    @Test
    public void useSchema() throws Exception {
        TestInfoSchema.testBuilder().sqlQuery("USE dfs_test.`default`").unOrdered().baselineColumns("ok", "summary").baselineValues(true, "Default schema changed to [dfs_test.default]").go();
    }

    @Test
    public void useSubSchemaWithinSchema() throws Exception {
        TestInfoSchema.testBuilder().sqlQuery("USE dfs_test").unOrdered().baselineColumns("ok", "summary").baselineValues(true, "Default schema changed to [dfs_test]").go();
        TestInfoSchema.testBuilder().sqlQuery("USE tmp").unOrdered().baselineColumns("ok", "summary").baselineValues(true, "Default schema changed to [dfs_test.tmp]").go();
        TestInfoSchema.testBuilder().sqlQuery("USE dfs.`default`").unOrdered().baselineColumns("ok", "summary").baselineValues(true, "Default schema changed to [dfs.default]").go();
    }

    @Test
    public void useSchemaNegative() throws Exception {
        TestInfoSchema.errorMsgTestHelper("USE invalid.schema", "Schema [invalid.schema] is not valid with respect to either root schema or current default schema.");
    }

    @Test
    public void completeSchemaRef1() throws Exception {
        TestInfoSchema.test("SELECT * FROM `cp.default`.`employee.json` limit 2");
    }

    @Test
    public void showFiles() throws Exception {
        TestInfoSchema.test("show files from dfs_test.`/tmp`");
        TestInfoSchema.test("show files from `dfs_test.default`.`/tmp`");
    }

    @Test
    public void showFilesWithDefaultSchema() throws Exception {
        TestInfoSchema.test("USE dfs_test.`default`");
        TestInfoSchema.test("SHOW FILES FROM `/tmp`");
    }
}

