/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.sql;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.drill.BaseTestQuery;
import org.junit.Test;

public class TestCTAS
extends BaseTestQuery {
    @Test
    public void withDuplicateColumnsInDef1() throws Exception {
        TestCTAS.ctasErrorTestHelper("CREATE TABLE %s.%s AS SELECT region_id, region_id FROM cp.`region.json`", String.format("Duplicate column name [%s]", "region_id"));
    }

    @Test
    public void withDuplicateColumnsInDef2() throws Exception {
        TestCTAS.ctasErrorTestHelper("CREATE TABLE %s.%s AS SELECT region_id, sales_city, sales_city FROM cp.`region.json`", String.format("Duplicate column name [%s]", "sales_city"));
    }

    @Test
    public void withDuplicateColumnsInDef3() throws Exception {
        TestCTAS.ctasErrorTestHelper("CREATE TABLE %s.%s(regionid, regionid) AS SELECT region_id, sales_city FROM cp.`region.json`", String.format("Duplicate column name [%s]", "regionid"));
    }

    @Test
    public void withDuplicateColumnsInDef4() throws Exception {
        TestCTAS.ctasErrorTestHelper("CREATE TABLE %s.%s(regionid, salescity, salescity) AS SELECT region_id, sales_city, sales_city FROM cp.`region.json`", String.format("Duplicate column name [%s]", "salescity"));
    }

    @Test
    public void withDuplicateColumnsInDef5() throws Exception {
        TestCTAS.ctasErrorTestHelper("CREATE TABLE %s.%s(regionid, salescity, SalesCity) AS SELECT region_id, sales_city, sales_city FROM cp.`region.json`", String.format("Duplicate column name [%s]", "SalesCity"));
    }

    @Test
    public void whenInEqualColumnCountInTableDefVsInTableQuery() throws Exception {
        TestCTAS.ctasErrorTestHelper("CREATE TABLE %s.%s(regionid, salescity) AS SELECT region_id, sales_city, sales_region FROM cp.`region.json`", "table's field list and the table's query field list have different counts.");
    }

    @Test
    public void whenTableQueryColumnHasStarAndTableFiledListIsSpecified() throws Exception {
        TestCTAS.ctasErrorTestHelper("CREATE TABLE %s.%s(regionid, salescity) AS SELECT region_id, * FROM cp.`region.json`", "table's query field list has a '*', which is invalid when table's field list is specified.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createTableWhenATableWithSameNameAlreadyExists() throws Exception {
        String newTblName = "createTableWhenTableAlreadyExists";
        try {
            String ctasQuery = String.format("CREATE TABLE %s.%s AS SELECT * from cp.`region.json`", "dfs_test.tmp", "createTableWhenTableAlreadyExists");
            TestCTAS.test(ctasQuery);
            TestCTAS.errorMsgTestHelper(ctasQuery, String.format("A table or view with given name [%s] already exists in schema [%s]", "createTableWhenTableAlreadyExists", "dfs_test.tmp"));
        }
        finally {
            FileUtils.deleteQuietly((File)new File(TestCTAS.getDfsTestTmpSchemaLocation(), "createTableWhenTableAlreadyExists"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createTableWhenAViewWithSameNameAlreadyExists() throws Exception {
        String newTblName = "createTableWhenAViewWithSameNameAlreadyExists";
        try {
            TestCTAS.test(String.format("CREATE VIEW %s.%s AS SELECT * from cp.`region.json`", "dfs_test.tmp", "createTableWhenAViewWithSameNameAlreadyExists"));
            String ctasQuery = String.format("CREATE TABLE %s.%s AS SELECT * FROM cp.`employee.json`", "dfs_test.tmp", "createTableWhenAViewWithSameNameAlreadyExists");
            TestCTAS.errorMsgTestHelper(ctasQuery, String.format("A table or view with given name [%s] already exists in schema [%s]", "createTableWhenAViewWithSameNameAlreadyExists", "dfs_test.tmp"));
        }
        catch (Throwable throwable) {
            TestCTAS.test(String.format("DROP VIEW %s.%s", "dfs_test.tmp", "createTableWhenAViewWithSameNameAlreadyExists"));
            throw throwable;
        }
        TestCTAS.test(String.format("DROP VIEW %s.%s", "dfs_test.tmp", "createTableWhenAViewWithSameNameAlreadyExists"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void ctasPartitionWithEmptyList() throws Exception {
        String newTblName = "ctasPartitionWithEmptyList";
        try {
            String ctasQuery = String.format("CREATE TABLE %s.%s PARTITION BY AS SELECT * from cp.`region.json`", "dfs_test.tmp", "ctasPartitionWithEmptyList");
            TestCTAS.errorMsgTestHelper(ctasQuery, String.format("PARSE ERROR: Encountered \"AS\"", new Object[0]));
        }
        finally {
            FileUtils.deleteQuietly((File)new File(TestCTAS.getDfsTestTmpSchemaLocation(), "ctasPartitionWithEmptyList"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void partitionByCtasColList() throws Exception {
        String newTblName = "partitionByCtasColList";
        try {
            String ctasQuery = String.format("CREATE TABLE %s.%s (cnt, rkey) PARTITION BY (cnt) AS SELECT count(*), n_regionkey from cp.`tpch/nation.parquet` group by n_regionkey", "dfs_test.tmp", "partitionByCtasColList");
            TestCTAS.test(ctasQuery);
            String selectFromCreatedTable = String.format(" select cnt, rkey from %s.%s", "dfs_test.tmp", "partitionByCtasColList");
            String baselineQuery = "select count(*) as cnt, n_regionkey as rkey from cp.`tpch/nation.parquet` group by n_regionkey";
            TestCTAS.testBuilder().sqlQuery(selectFromCreatedTable).unOrdered().sqlBaselineQuery("select count(*) as cnt, n_regionkey as rkey from cp.`tpch/nation.parquet` group by n_regionkey").build().run();
        }
        finally {
            FileUtils.deleteQuietly((File)new File(TestCTAS.getDfsTestTmpSchemaLocation(), "partitionByCtasColList"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void partitionByCtasFromView() throws Exception {
        String newTblName = "partitionByCtasColList";
        String newView = "partitionByCtasColListView";
        try {
            String viewCreate = String.format("create or replace view %s.%s (col_int, col_varchar)  AS select cast(n_nationkey as int), cast(n_name as varchar(30)) from cp.`tpch/nation.parquet`", "dfs_test.tmp", "partitionByCtasColListView");
            String ctasQuery = String.format("CREATE TABLE %s.%s PARTITION BY (col_int) AS SELECT * from %s.%s", "dfs_test.tmp", "partitionByCtasColList", "dfs_test.tmp", "partitionByCtasColListView");
            TestCTAS.test(viewCreate);
            TestCTAS.test(ctasQuery);
            String baselineQuery = "select cast(n_nationkey as int) as col_int, cast(n_name as varchar(30)) as col_varchar from cp.`tpch/nation.parquet`";
            String selectFromCreatedTable = String.format("select col_int, col_varchar from %s.%s", "dfs_test.tmp", "partitionByCtasColList");
            TestCTAS.testBuilder().sqlQuery(selectFromCreatedTable).unOrdered().sqlBaselineQuery("select cast(n_nationkey as int) as col_int, cast(n_name as varchar(30)) as col_varchar from cp.`tpch/nation.parquet`").build().run();
            String viewDrop = String.format("DROP VIEW %s.%s", "dfs_test.tmp", "partitionByCtasColListView");
            TestCTAS.test(viewDrop);
        }
        finally {
            FileUtils.deleteQuietly((File)new File(TestCTAS.getDfsTestTmpSchemaLocation(), "partitionByCtasColList"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void ctasWithQueryOrderby() throws Exception {
        String newTblName = "ctasWithQueryOrderby";
        try {
            String ctasQuery = String.format("CREATE TABLE %s.%s   AS SELECT n_nationkey, n_name, n_comment from cp.`tpch/nation.parquet` order by n_nationkey", "dfs_test.tmp", "ctasWithQueryOrderby");
            TestCTAS.test(ctasQuery);
            String selectFromCreatedTable = String.format(" select n_nationkey, n_name, n_comment from %s.%s", "dfs_test.tmp", "ctasWithQueryOrderby");
            String baselineQuery = "select n_nationkey, n_name, n_comment from cp.`tpch/nation.parquet` order by n_nationkey";
            TestCTAS.testBuilder().sqlQuery(selectFromCreatedTable).ordered().sqlBaselineQuery("select n_nationkey, n_name, n_comment from cp.`tpch/nation.parquet` order by n_nationkey").build().run();
        }
        finally {
            FileUtils.deleteQuietly((File)new File(TestCTAS.getDfsTestTmpSchemaLocation(), "ctasWithQueryOrderby"));
        }
    }

    private static void ctasErrorTestHelper(String ctasSql, String expErrorMsg) throws Exception {
        String createTableSql = String.format(ctasSql, "dfs_test.tmp", "testTableName");
        TestCTAS.errorMsgTestHelper(createTableSql, expErrorMsg);
    }
}

