/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.sql;

import com.google.common.base.Strings;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.TestBuilder;

public class TestBaseViewSupport
extends BaseTestQuery {
    private static AtomicInteger viewSeqNum = new AtomicInteger(0);

    protected static void createViewHelper(String viewSchema, String viewName, String finalSchema, String viewFields, String viewDef) throws Exception {
        String viewFullName = "`" + viewName + "`";
        if (!Strings.isNullOrEmpty((String)viewSchema)) {
            viewFullName = viewSchema + "." + viewFullName;
        }
        String createViewSql = String.format("CREATE VIEW %s %s AS %s", viewFullName, viewFields == null ? "" : viewFields, viewDef);
        TestBaseViewSupport.testBuilder().sqlQuery(createViewSql).unOrdered().baselineColumns("ok", "summary").baselineValues(true, String.format("View '%s' created successfully in '%s' schema", viewName, finalSchema)).go();
    }

    protected static void dropViewHelper(String viewSchema, String viewName, String finalSchema) throws Exception {
        String viewFullName = "`" + viewName + "`";
        if (!Strings.isNullOrEmpty((String)viewSchema)) {
            viewFullName = viewSchema + "." + viewFullName;
        }
        TestBaseViewSupport.testBuilder().sqlQuery(String.format("DROP VIEW %s", viewFullName)).unOrdered().baselineColumns("ok", "summary").baselineValues(true, String.format("View [%s] deleted successfully from schema [%s].", viewName, finalSchema)).go();
    }

    protected static void queryViewHelper(String query, String[] baselineColumns, List<Object[]> baselineValues) throws Exception {
        TestBuilder testBuilder = TestBaseViewSupport.testBuilder().sqlQuery(query).unOrdered().baselineColumns(baselineColumns);
        for (Object[] values : baselineValues) {
            testBuilder = testBuilder.baselineValues(values);
        }
        testBuilder.go();
    }

    protected static String generateViewName() {
        return TestBaseViewSupport.class.getSimpleName() + "_" + viewSeqNum.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void testViewHelper(String finalSchema, String viewFields, String viewDef, String queryOnView, String[] expectedBaselineColumns, List<Object[]> expectedBaselineValues) throws Exception {
        String viewName = TestBaseViewSupport.generateViewName();
        try {
            TestBaseViewSupport.createViewHelper(finalSchema, viewName, finalSchema, viewFields, viewDef);
            queryOnView = queryOnView.replace("TEST_VIEW_NAME", "`" + viewName + "`").replace("TEST_SCHEMA", finalSchema);
            TestBaseViewSupport.queryViewHelper(queryOnView, expectedBaselineColumns, expectedBaselineValues);
        }
        finally {
            TestBaseViewSupport.dropViewHelper(finalSchema, viewName, finalSchema);
        }
    }
}

