/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server;

import java.util.Properties;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.rpc.user.security.UserAuthenticatorTestImpl;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestOptionsAuthEnabled
extends BaseTestQuery {
    private static final String setSysOptionQuery = String.format("ALTER SYSTEM SET `%s` = %d;", "planner.slice_target", 200);

    @BeforeClass
    public static void setupCluster() throws Exception {
        Properties props = TestOptionsAuthEnabled.cloneDefaultTestConfigProperties();
        props.setProperty("drill.exec.security.user.auth.enabled", "true");
        props.setProperty("drill.exec.security.user.auth.impl", "drillTestAuthenticator");
        TestOptionsAuthEnabled.updateTestCluster(1, DrillConfig.create((Properties)props));
        TestOptionsAuthEnabled.updateClient(UserAuthenticatorTestImpl.PROCESS_USER, "processUserPw");
        TestOptionsAuthEnabled.test(String.format("ALTER SYSTEM SET `%s`='%s,%s'", "security.admin.users", "admin", UserAuthenticatorTestImpl.PROCESS_USER));
        TestOptionsAuthEnabled.test(String.format("ALTER SYSTEM SET `%s`='%s'", "security.admin.user_groups", "admingrp"));
    }

    @Test
    public void updateSysOptAsAdminUser() throws Exception {
        TestOptionsAuthEnabled.updateClient("admin", "adminUserPw");
        this.setOptHelper();
    }

    @Test
    public void updateSysOptAsNonAdminUser() throws Exception {
        TestOptionsAuthEnabled.updateClient("testUser2", "testUser2Password");
        TestOptionsAuthEnabled.errorMsgTestHelper(setSysOptionQuery, "Not authorized to change SYSTEM options.");
    }

    @Test
    public void updateSysOptAsUserInAdminGroup() throws Exception {
        TestOptionsAuthEnabled.updateClient("testUser1", "testUser1Password");
        this.setOptHelper();
    }

    @Test
    public void trySettingAdminOptsAtSessionScopeAsAdmin() throws Exception {
        TestOptionsAuthEnabled.updateClient("admin", "adminUserPw");
        String setOptionQuery = String.format("ALTER SESSION SET `%s`='%s,%s'", "security.admin.users", "admin", UserAuthenticatorTestImpl.PROCESS_USER);
        TestOptionsAuthEnabled.errorMsgTestHelper(setOptionQuery, "Admin related settings can only be set at SYSTEM level scope");
    }

    @Test
    public void trySettingAdminOptsAtSessionScopeAsNonAdmin() throws Exception {
        TestOptionsAuthEnabled.updateClient("testUser2", "testUser2Password");
        String setOptionQuery = String.format("ALTER SESSION SET `%s`='%s,%s'", "security.admin.users", "admin", UserAuthenticatorTestImpl.PROCESS_USER);
        TestOptionsAuthEnabled.errorMsgTestHelper(setOptionQuery, "Admin related settings can only be set at SYSTEM level scope");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOptHelper() throws Exception {
        try {
            TestOptionsAuthEnabled.test(setSysOptionQuery);
            TestOptionsAuthEnabled.testBuilder().sqlQuery(String.format("SELECT num_val FROM sys.options WHERE name = '%s' AND type = 'SYSTEM'", "planner.slice_target")).unOrdered().baselineColumns("num_val").baselineValues(200L).go();
        }
        catch (Throwable throwable) {
            TestOptionsAuthEnabled.test(String.format("ALTER SYSTEM SET `%s` = %d;", "planner.slice_target", 100000L));
            throw throwable;
        }
        TestOptionsAuthEnabled.test(String.format("ALTER SYSTEM SET `%s` = %d;", "planner.slice_target", 100000L));
    }
}

