/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.test.UserExceptionMatcher;
import org.hamcrest.Matcher;
import org.junit.Test;

public class TestOptions
extends BaseTestQuery {
    @Test
    public void testDrillbits() throws Exception {
        TestOptions.test("select * from sys.drillbits;");
    }

    @Test
    public void testOptions() throws Exception {
        TestOptions.test("select * from sys.options;ALTER SYSTEM set `planner.disable_exchanges` = true;select * from sys.options;ALTER SESSION set `planner.disable_exchanges` = true;select * from sys.options;");
    }

    @Test
    public void checkValidationException() throws Exception {
        this.thrownException.expect((Matcher)new UserExceptionMatcher(UserBitShared.DrillPBError.ErrorType.VALIDATION));
        TestOptions.test(String.format("ALTER session SET `%s` = '%s';", "planner.slice_target", "fail"));
    }

    @Test
    public void checkChangedColumn() throws Exception {
        TestOptions.test(String.format("ALTER session SET `%s` = %d;", "planner.slice_target", 100000L));
        TestOptions.testBuilder().sqlQuery(String.format("SELECT status FROM sys.options WHERE name = '%s' AND type = 'SESSION'", "planner.slice_target")).unOrdered().baselineColumns("status").baselineValues("DEFAULT").build().run();
    }
}

