/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.user.security;

import java.io.IOException;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.exception.DrillbitStartupException;
import org.apache.drill.exec.rpc.user.security.UserAuthenticationException;
import org.apache.drill.exec.rpc.user.security.UserAuthenticator;
import org.apache.drill.exec.rpc.user.security.UserAuthenticatorTemplate;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.hadoop.security.UserGroupInformation;

@UserAuthenticatorTemplate(type="drillTestAuthenticator")
public class UserAuthenticatorTestImpl
implements UserAuthenticator {
    public static final String TYPE = "drillTestAuthenticator";
    public static final String TEST_USER_1 = "testUser1";
    public static final String TEST_USER_2 = "testUser2";
    public static final String ADMIN_USER = "admin";
    public static final String PROCESS_USER = ImpersonationUtil.getProcessUserName();
    public static final String TEST_USER_1_PASSWORD = "testUser1Password";
    public static final String TEST_USER_2_PASSWORD = "testUser2Password";
    public static final String ADMIN_USER_PASSWORD = "adminUserPw";
    public static final String PROCESS_USER_PASSWORD = "processUserPw";
    public static final String ADMIN_GROUP = "admingrp";

    public void setup(DrillConfig drillConfig) throws DrillbitStartupException {
    }

    public void authenticate(String user, String password) throws UserAuthenticationException {
        if ("anonymous".equals(user)) {
            return;
        }
        if (!(TEST_USER_1.equals(user) && TEST_USER_1_PASSWORD.equals(password) || TEST_USER_2.equals(user) && TEST_USER_2_PASSWORD.equals(password) || ADMIN_USER.equals(user) && ADMIN_USER_PASSWORD.equals(password) || PROCESS_USER.equals(user) && PROCESS_USER_PASSWORD.equals(password))) {
            throw new UserAuthenticationException();
        }
    }

    public void close() throws IOException {
    }

    static {
        UserGroupInformation.createUserForTesting((String)TEST_USER_1, (String[])new String[]{"g1", ADMIN_GROUP});
        UserGroupInformation.createUserForTesting((String)TEST_USER_2, (String[])new String[]{"g1"});
        UserGroupInformation.createUserForTesting((String)ADMIN_USER, (String[])new String[]{ADMIN_GROUP});
    }
}

