/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.user.security;

import java.util.Properties;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.rpc.RpcException;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestCustomUserAuthenticator
extends BaseTestQuery {
    @BeforeClass
    public static void setupCluster() {
        Properties props = TestCustomUserAuthenticator.cloneDefaultTestConfigProperties();
        props.setProperty("drill.exec.security.user.auth.enabled", "true");
        props.setProperty("drill.exec.security.user.auth.impl", "drillTestAuthenticator");
        DrillConfig newConfig = DrillConfig.create((Properties)props);
        TestCustomUserAuthenticator.updateTestCluster(3, newConfig);
    }

    @Test
    public void positiveUserAuth() throws Exception {
        TestCustomUserAuthenticator.runTest("testUser1", "testUser1Password");
        TestCustomUserAuthenticator.runTest("testUser2", "testUser2Password");
    }

    @Test
    public void negativeUserAuth() throws Exception {
        TestCustomUserAuthenticator.negativeAuthHelper("testUser1", "blah.. blah..");
        TestCustomUserAuthenticator.negativeAuthHelper("testUser2", "blah.. blah..");
        TestCustomUserAuthenticator.negativeAuthHelper("testUser2", "");
        TestCustomUserAuthenticator.negativeAuthHelper("invalidUserName", "blah.. blah..");
    }

    @Test
    public void positiveUserAuthAfterNegativeUserAuth() throws Exception {
        TestCustomUserAuthenticator.negativeAuthHelper("blah.. blah..", "blah.. blah..");
        TestCustomUserAuthenticator.runTest("testUser2", "testUser2Password");
    }

    private static void negativeAuthHelper(String user, String password) throws Exception {
        RpcException negativeAuthEx = null;
        try {
            TestCustomUserAuthenticator.runTest(user, password);
        }
        catch (RpcException e) {
            negativeAuthEx = e;
        }
        Assert.assertNotNull((String)"Expected RpcException.", (Object)((Object)negativeAuthEx));
        String exMsg = negativeAuthEx.getMessage();
        Assert.assertThat((Object)exMsg, (Matcher)StringContains.containsString((String)"HANDSHAKE_VALIDATION : Status: AUTH_FAILED"));
        Assert.assertThat((Object)exMsg, (Matcher)StringContains.containsString((String)"Invalid user credentials"));
    }

    private static void runTest(String user, String password) throws Exception {
        Properties connectionProps = new Properties();
        connectionProps.setProperty("user", user);
        connectionProps.setProperty("password", password);
        TestCustomUserAuthenticator.updateClient(connectionProps);
        TestCustomUserAuthenticator.test("SHOW SCHEMAS");
        TestCustomUserAuthenticator.test("USE INFORMATION_SCHEMA");
        TestCustomUserAuthenticator.test("SHOW TABLES");
        TestCustomUserAuthenticator.test("SELECT * FROM INFORMATION_SCHEMA.`TABLES` WHERE TABLE_NAME LIKE 'COLUMNS'");
        TestCustomUserAuthenticator.test("SELECT * FROM cp.`region.json` LIMIT 5");
    }
}

