/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.vector;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.DrillBuf;
import java.nio.charset.Charset;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.exception.OversizedAllocationException;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.NullableUInt4Holder;
import org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.RepeatedFloat4Holder;
import org.apache.drill.exec.expr.holders.RepeatedVarBinaryHolder;
import org.apache.drill.exec.expr.holders.UInt1Holder;
import org.apache.drill.exec.expr.holders.UInt4Holder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.BitVector;
import org.apache.drill.exec.vector.NullableFloat4Vector;
import org.apache.drill.exec.vector.NullableUInt4Vector;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.drill.exec.vector.complex.RepeatedListVector;
import org.apache.drill.exec.vector.complex.RepeatedMapVector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestValueVector
extends ExecTest {
    private static final SchemaPath EMPTY_SCHEMA_PATH = SchemaPath.getSimplePath((String)"");
    private static final byte[] STR1 = new String("AAAAA1").getBytes(Charset.forName("UTF-8"));
    private static final byte[] STR2 = new String("BBBBBBBBB2").getBytes(Charset.forName("UTF-8"));
    private static final byte[] STR3 = new String("CCCC3").getBytes(Charset.forName("UTF-8"));
    private DrillConfig drillConfig;
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.drillConfig = DrillConfig.create();
        this.allocator = RootAllocatorFactory.newRoot((DrillConfig)this.drillConfig);
    }

    @After
    public void terminate() {
        this.allocator.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=OversizedAllocationException.class)
    public void testFixedVectorReallocation() {
        MaterializedField field = MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)UInt4Holder.TYPE);
        int expectedValueCapacity = 0x1FFFFFFF;
        try (UInt4Vector vector = new UInt4Vector(field, this.allocator);){
            vector.allocateNew(0x1FFFFFFF);
            Assert.assertEquals((long)0x1FFFFFFFL, (long)vector.getValueCapacity());
            vector.reAlloc();
            Assert.assertEquals((long)0x3FFFFFFEL, (long)vector.getValueCapacity());
        }
        try {
            vector.allocateNew(0xFFFFFFF);
            vector.reAlloc();
            vector.reAlloc();
        }
        finally {
            vector.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=OversizedAllocationException.class)
    public void testBitVectorReallocation() {
        MaterializedField field = MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)UInt4Holder.TYPE);
        int expectedValueCapacity = 0x20000000;
        try (BitVector vector = new BitVector(field, this.allocator);){
            vector.allocateNew(0x20000000);
            Assert.assertEquals((long)0x20000000L, (long)vector.getValueCapacity());
            vector.reAlloc();
            Assert.assertEquals((long)0x40000000L, (long)vector.getValueCapacity());
        }
        try {
            vector.allocateNew(0x20000000);
            for (int i = 0; i < 3; ++i) {
                vector.reAlloc();
            }
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)vector.getValueCapacity());
            vector.reAlloc();
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)vector.getValueCapacity());
            vector.reAlloc();
        }
        finally {
            vector.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=OversizedAllocationException.class)
    public void testVariableVectorReallocation() {
        MaterializedField field = MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)UInt4Holder.TYPE);
        VarCharVector vector = new VarCharVector(field, this.allocator);
        int expectedAllocationInBytes = Integer.MAX_VALUE;
        int expectedOffsetSize = 10;
        try {
            vector.allocateNew(Integer.MAX_VALUE, 10);
            Assert.assertEquals((long)10L, (long)vector.getValueCapacity());
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)vector.getBuffer().capacity());
            vector.reAlloc();
            Assert.assertEquals((long)20L, (long)vector.getValueCapacity());
            Assert.assertEquals((long)-2L, (long)vector.getBuffer().capacity());
        }
        finally {
            vector.close();
        }
        try {
            vector.allocateNew(0x3FFFFFFF, 0);
            vector.reAlloc();
            vector.reAlloc();
        }
        finally {
            vector.close();
        }
    }

    @Test
    public void testFixedType() {
        MaterializedField field = MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)UInt4Holder.TYPE);
        try (UInt4Vector vector = new UInt4Vector(field, this.allocator);){
            UInt4Vector.Mutator m = vector.getMutator();
            vector.allocateNew(1024);
            m.setSafe(0, 100);
            m.setSafe(1, 101);
            m.setSafe(100, 102);
            m.setSafe(1022, 103);
            m.setSafe(1023, 104);
            Assert.assertEquals((long)100L, (long)vector.getAccessor().get(0));
            Assert.assertEquals((long)101L, (long)vector.getAccessor().get(1));
            Assert.assertEquals((long)102L, (long)vector.getAccessor().get(100));
            Assert.assertEquals((long)103L, (long)vector.getAccessor().get(1022));
            Assert.assertEquals((long)104L, (long)vector.getAccessor().get(1023));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullableVarLen2() {
        MaterializedField field = MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)NullableVarCharHolder.TYPE);
        try (NullableVarCharVector vector = new NullableVarCharVector(field, this.allocator);){
            NullableVarCharVector.Mutator m = vector.getMutator();
            vector.allocateNew(10240, 1024);
            m.set(0, STR1);
            m.set(1, STR2);
            m.set(2, STR3);
            Assert.assertArrayEquals((byte[])STR1, (byte[])vector.getAccessor().get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])vector.getAccessor().get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])vector.getAccessor().get(2));
            boolean b = false;
            try {
                vector.getAccessor().get(3);
            }
            catch (IllegalStateException e) {
                b = true;
            }
            finally {
                Assert.assertTrue((boolean)b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullableFixedType() {
        MaterializedField field = MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)NullableUInt4Holder.TYPE);
        try (NullableUInt4Vector vector = new NullableUInt4Vector(field, this.allocator);){
            NullableUInt4Vector.Mutator m = vector.getMutator();
            vector.allocateNew(1024);
            m.set(0, 100);
            m.set(1, 101);
            m.set(100, 102);
            m.set(1022, 103);
            m.set(1023, 104);
            Assert.assertEquals((long)100L, (long)vector.getAccessor().get(0));
            Assert.assertEquals((long)101L, (long)vector.getAccessor().get(1));
            Assert.assertEquals((long)102L, (long)vector.getAccessor().get(100));
            Assert.assertEquals((long)103L, (long)vector.getAccessor().get(1022));
            Assert.assertEquals((long)104L, (long)vector.getAccessor().get(1023));
            boolean b = false;
            try {
                vector.getAccessor().get(3);
            }
            catch (IllegalStateException e) {
                b = true;
            }
            finally {
                Assert.assertTrue((boolean)b);
            }
            vector.allocateNew(2048);
            b = false;
            try {
                vector.getAccessor().get(0);
            }
            catch (IllegalStateException e) {
                b = true;
            }
            finally {
                Assert.assertTrue((boolean)b);
            }
            m.set(0, 100);
            m.set(1, 101);
            m.set(100, 102);
            m.set(1022, 103);
            m.set(1023, 104);
            Assert.assertEquals((long)100L, (long)vector.getAccessor().get(0));
            Assert.assertEquals((long)101L, (long)vector.getAccessor().get(1));
            Assert.assertEquals((long)102L, (long)vector.getAccessor().get(100));
            Assert.assertEquals((long)103L, (long)vector.getAccessor().get(1022));
            Assert.assertEquals((long)104L, (long)vector.getAccessor().get(1023));
            b = false;
            try {
                vector.getAccessor().get(3);
            }
            catch (IllegalStateException e) {
                b = true;
            }
            finally {
                Assert.assertTrue((boolean)b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullableFloat() {
        MaterializedField field = MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)NullableFloat4Holder.TYPE);
        try (NullableFloat4Vector vector = (NullableFloat4Vector)TypeHelper.getNewVector(field, this.allocator);){
            NullableFloat4Vector.Mutator m = vector.getMutator();
            vector.allocateNew(1024);
            m.set(0, 100.1f);
            m.set(1, 101.2f);
            m.set(100, 102.3f);
            m.set(1022, 103.4f);
            m.set(1023, 104.5f);
            Assert.assertEquals((float)100.1f, (float)vector.getAccessor().get(0), (float)0.0f);
            Assert.assertEquals((float)101.2f, (float)vector.getAccessor().get(1), (float)0.0f);
            Assert.assertEquals((float)102.3f, (float)vector.getAccessor().get(100), (float)0.0f);
            Assert.assertEquals((float)103.4f, (float)vector.getAccessor().get(1022), (float)0.0f);
            Assert.assertEquals((float)104.5f, (float)vector.getAccessor().get(1023), (float)0.0f);
            boolean b = false;
            try {
                vector.getAccessor().get(3);
            }
            catch (IllegalStateException e) {
                b = true;
            }
            finally {
                Assert.assertTrue((boolean)b);
            }
            vector.allocateNew(2048);
            b = false;
            try {
                vector.getAccessor().get(0);
            }
            catch (IllegalStateException e) {
                b = true;
            }
            finally {
                Assert.assertTrue((boolean)b);
            }
        }
    }

    @Test
    public void testBitVector() {
        MaterializedField field = MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)BitHolder.TYPE);
        try (BitVector vector = new BitVector(field, this.allocator);){
            BitVector.Mutator m = vector.getMutator();
            vector.allocateNew(1024);
            m.set(0, 1);
            m.set(1, 0);
            m.set(100, 0);
            m.set(1022, 1);
            Assert.assertEquals((long)1L, (long)vector.getAccessor().get(0));
            Assert.assertEquals((long)0L, (long)vector.getAccessor().get(1));
            Assert.assertEquals((long)0L, (long)vector.getAccessor().get(100));
            Assert.assertEquals((long)1L, (long)vector.getAccessor().get(1022));
            m.set(0, 1);
            m.set(0, 1);
            m.set(1, 0);
            m.set(1, 0);
            Assert.assertEquals((long)1L, (long)vector.getAccessor().get(0));
            Assert.assertEquals((long)0L, (long)vector.getAccessor().get(1));
            m.set(0, 0);
            m.set(1, 1);
            Assert.assertEquals((long)0L, (long)vector.getAccessor().get(0));
            Assert.assertEquals((long)1L, (long)vector.getAccessor().get(1));
            Assert.assertEquals((long)0L, (long)vector.getAccessor().get(3));
        }
    }

    @Test
    public void testReAllocNullableFixedWidthVector() throws Exception {
        MaterializedField field = MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)NullableFloat4Holder.TYPE);
        try (NullableFloat4Vector vector = (NullableFloat4Vector)TypeHelper.getNewVector(field, this.allocator);){
            NullableFloat4Vector.Mutator m = vector.getMutator();
            vector.allocateNew(1024);
            Assert.assertEquals((long)1024L, (long)vector.getValueCapacity());
            m.setSafe(0, 100.1f);
            m.setSafe(100, 102.3f);
            m.setSafe(1023, 104.5f);
            m.setSafe(2000, 105.5f);
            Assert.assertEquals((long)2048L, (long)vector.getValueCapacity());
            Assert.assertEquals((float)100.1f, (float)vector.getAccessor().get(0), (float)0.0f);
            Assert.assertEquals((float)102.3f, (float)vector.getAccessor().get(100), (float)0.0f);
            Assert.assertEquals((float)104.5f, (float)vector.getAccessor().get(1023), (float)0.0f);
            Assert.assertEquals((float)105.5f, (float)vector.getAccessor().get(2000), (float)0.0f);
            m.setValueCount(vector.getValueCapacity() + 200);
        }
    }

    @Test
    public void testReAllocNullableVariableWidthVector() throws Exception {
        MaterializedField field = MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)NullableVarCharHolder.TYPE);
        try (NullableVarCharVector vector = (NullableVarCharVector)TypeHelper.getNewVector(field, this.allocator);){
            NullableVarCharVector.Mutator m = vector.getMutator();
            vector.allocateNew();
            int initialCapacity = vector.getValueCapacity();
            m.setSafe(0, STR1, 0, STR1.length);
            m.setSafe(initialCapacity - 1, STR2, 0, STR2.length);
            m.setSafe(initialCapacity + 200, STR3, 0, STR3.length);
            Assert.assertEquals((long)((initialCapacity + 1) * 2 - 1), (long)vector.getValueCapacity());
            Assert.assertArrayEquals((byte[])STR1, (byte[])vector.getAccessor().get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])vector.getAccessor().get(initialCapacity - 1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])vector.getAccessor().get(initialCapacity + 200));
            m.setValueCount(vector.getValueCapacity() + 200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVVInitialCapacity() throws Exception {
        MaterializedField[] fields = new MaterializedField[9];
        ValueVector[] valueVectors = new ValueVector[9];
        fields[0] = MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)BitHolder.TYPE);
        fields[1] = MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)IntHolder.TYPE);
        fields[2] = MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)VarCharHolder.TYPE);
        fields[3] = MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)NullableVar16CharHolder.TYPE);
        fields[4] = MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)RepeatedFloat4Holder.TYPE);
        fields[5] = MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)RepeatedVarBinaryHolder.TYPE);
        fields[6] = MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)MapVector.TYPE);
        fields[6].addChild(fields[0]);
        fields[6].addChild(fields[2]);
        fields[7] = MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)RepeatedMapVector.TYPE);
        fields[7].addChild(fields[1]);
        fields[7].addChild(fields[3]);
        fields[8] = MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)RepeatedListVector.TYPE);
        fields[8].addChild(fields[1]);
        int initialCapacity = 1024;
        try {
            int i;
            for (i = 0; i < valueVectors.length; ++i) {
                valueVectors[i] = TypeHelper.getNewVector(fields[i], this.allocator);
                valueVectors[i].setInitialCapacity(1024);
                valueVectors[i].allocateNew();
            }
            for (i = 0; i < valueVectors.length; ++i) {
                ValueVector vv = valueVectors[i];
                int vvCapacity = vv.getValueCapacity();
                Assert.assertEquals((String)String.format("Incorrect value capacity for %s [%d]", vv.getField(), vvCapacity), (long)1024L, (long)vvCapacity);
            }
        }
        finally {
            AutoCloseables.close((AutoCloseable[])valueVectors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testVectors(VectorVerifier test) throws Exception {
        MaterializedField[] fields = new MaterializedField[]{MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)UInt4Holder.TYPE), MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)BitHolder.TYPE), MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)VarCharHolder.TYPE), MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)NullableVarCharHolder.TYPE), MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)RepeatedListVector.TYPE), MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)MapVector.TYPE), MaterializedField.create((SchemaPath)EMPTY_SCHEMA_PATH, (TypeProtos.MajorType)RepeatedMapVector.TYPE)};
        ValueVector[] vectors = new ValueVector[]{new UInt4Vector(fields[0], this.allocator), new BitVector(fields[1], this.allocator), new VarCharVector(fields[2], this.allocator), new NullableVarCharVector(fields[3], this.allocator), new RepeatedListVector(fields[4], this.allocator, null), new MapVector(fields[5], this.allocator, null), new RepeatedMapVector(fields[6], this.allocator, null)};
        try {
            for (ValueVector vector : vectors) {
                test.verify(vector);
            }
        }
        finally {
            AutoCloseables.close((AutoCloseable[])vectors);
        }
    }

    @Test
    public void testVectorMetadataIsAccurate() throws Exception {
        ChildVerifier noChild = new ChildVerifier(new TypeProtos.MajorType[0]);
        ChildVerifier offsetChild = new ChildVerifier(UInt4Holder.TYPE);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(UInt4Vector.class, (Object)noChild);
        builder.put(BitVector.class, (Object)noChild);
        builder.put(VarCharVector.class, (Object)offsetChild);
        builder.put(NullableVarCharVector.class, (Object)new ChildVerifier(UInt1Holder.TYPE, Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR)));
        builder.put(RepeatedListVector.class, (Object)new ChildVerifier(UInt4Holder.TYPE, Types.LATE_BIND_TYPE));
        builder.put(MapVector.class, (Object)noChild);
        builder.put(RepeatedMapVector.class, (Object)offsetChild);
        final ImmutableMap children = builder.build();
        this.testVectors(new VectorVerifier(){

            @Override
            public void verify(ValueVector vector) throws Exception {
                Class<?> klazz = vector.getClass();
                VectorVerifier verifier = (VectorVerifier)children.get(klazz);
                verifier.verify(vector);
            }
        });
    }

    @Test
    public void testVectorCanLoadEmptyBuffer() throws Exception {
        final DrillBuf empty = this.allocator.getEmpty();
        this.testVectors(new VectorVerifier(){

            @Override
            public void verify(ValueVector vector) {
                String hint = String.format("%s failed the test case", vector.getClass().getSimpleName());
                UserBitShared.SerializedField metadata = vector.getMetadata();
                Assert.assertEquals((String)hint, (long)0L, (long)metadata.getBufferLength());
                Assert.assertEquals((String)hint, (long)0L, (long)metadata.getValueCount());
                vector.load(metadata, empty);
                Assert.assertEquals((String)hint, (long)0L, (long)vector.getValueCapacity());
                Assert.assertEquals((String)hint, (long)0L, (long)vector.getAccessor().getValueCount());
                vector.clear();
            }
        });
    }

    protected static class ChildVerifier
    implements VectorVerifier {
        public final TypeProtos.MajorType[] types;

        public ChildVerifier(TypeProtos.MajorType ... childTypes) {
            this.types = (TypeProtos.MajorType[])Preconditions.checkNotNull((Object)childTypes);
        }

        @Override
        public void verify(ValueVector vector) throws Exception {
            String hint = String.format("%s failed the test case", vector.getClass().getSimpleName());
            UserBitShared.SerializedField metadata = vector.getMetadata();
            int actual = metadata.getChildCount();
            Assert.assertEquals((String)hint, (long)this.types.length, (long)actual);
            for (int i = 0; i < this.types.length; ++i) {
                UserBitShared.SerializedField child = metadata.getChild(i);
                Assert.assertEquals((String)hint, (Object)this.types[i], (Object)child.getMajorType());
            }
        }
    }

    protected static interface VectorVerifier {
        public void verify(ValueVector var1) throws Exception;
    }
}

