/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.vector;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DrillBuf;
import java.util.ArrayList;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.WritableBatch;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.IntVector;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.junit.Assert;
import org.junit.Test;

public class TestLoad
extends ExecTest {
    private final DrillConfig drillConfig = DrillConfig.create();

    @Test
    public void testLoadValueVector() throws Exception {
        BufferAllocator allocator = RootAllocatorFactory.newRoot((DrillConfig)this.drillConfig);
        IntVector fixedV = new IntVector(MaterializedField.create((SchemaPath)new SchemaPath("ints", ExpressionPosition.UNKNOWN), (TypeProtos.MajorType)Types.required((TypeProtos.MinorType)TypeProtos.MinorType.INT)), allocator);
        VarCharVector varlenV = new VarCharVector(MaterializedField.create((SchemaPath)new SchemaPath("chars", ExpressionPosition.UNKNOWN), (TypeProtos.MajorType)Types.required((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR)), allocator);
        NullableVarCharVector nullableVarlenV = new NullableVarCharVector(MaterializedField.create((SchemaPath)new SchemaPath("chars", ExpressionPosition.UNKNOWN), (TypeProtos.MajorType)Types.optional((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR)), allocator);
        ArrayList vectors = Lists.newArrayList((Object[])new ValueVector[]{fixedV, varlenV, nullableVarlenV});
        for (ValueVector v : vectors) {
            AllocationHelper.allocate((ValueVector)v, (int)100, (int)50);
            v.getMutator().generateTestData(100);
        }
        WritableBatch writableBatch = WritableBatch.getBatchNoHV((int)100, (Iterable)vectors, (boolean)false);
        RecordBatchLoader batchLoader = new RecordBatchLoader(allocator);
        DrillBuf[] byteBufs = writableBatch.getBuffers();
        int bytes = 0;
        for (int i = 0; i < byteBufs.length; ++i) {
            bytes += byteBufs[i].writerIndex();
        }
        DrillBuf byteBuf = allocator.buffer(bytes);
        int index = 0;
        for (int i = 0; i < byteBufs.length; ++i) {
            byteBufs[i].readBytes((ByteBuf)byteBuf, index, byteBufs[i].writerIndex());
            index += byteBufs[i].writerIndex();
        }
        byteBuf.writerIndex(bytes);
        batchLoader.load(writableBatch.getDef(), byteBuf);
        boolean firstColumn = true;
        int recordCount = 0;
        for (VectorWrapper v : batchLoader) {
            if (firstColumn) {
                firstColumn = false;
            } else {
                System.out.print("\t");
            }
            System.out.print(v.getField().toExpr());
            System.out.print("[");
            System.out.print(v.getField().getType().getMinorType());
            System.out.print("]");
        }
        System.out.println();
        for (int r = 0; r < batchLoader.getRecordCount(); ++r) {
            boolean first = true;
            ++recordCount;
            for (VectorWrapper v : batchLoader) {
                if (first) {
                    first = false;
                } else {
                    System.out.print("\t");
                }
                ValueVector.Accessor accessor = v.getValueVector().getAccessor();
                if (v.getField().getType().getMinorType() == TypeProtos.MinorType.VARCHAR) {
                    Object obj = accessor.getObject(r);
                    if (obj != null) {
                        System.out.print(accessor.getObject(r));
                        continue;
                    }
                    System.out.print("NULL");
                    continue;
                }
                System.out.print(accessor.getObject(r));
            }
            if (first) continue;
            System.out.println();
        }
        Assert.assertEquals((long)100L, (long)recordCount);
        batchLoader.clear();
        writableBatch.clear();
    }
}

