/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.vector;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.pop.PopUnitTestBase;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.vector.ValueVector;
import org.junit.Assert;
import org.junit.Test;

public class TestDateTypes
extends PopUnitTestBase {
    @Test
    public void testDate() throws Exception {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/record/vector/test_date.json"), (Charset)Charsets.UTF_8).replace("#{TEST_FILE}", "/test_simple_date.json"));
            RecordBatchLoader batchLoader = new RecordBatchLoader(bit.getContext().getAllocator());
            QueryDataBatch batch = (QueryDataBatch)results.get(0);
            Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
            for (VectorWrapper v : batchLoader) {
                ValueVector.Accessor accessor = v.getValueVector().getAccessor();
                Assert.assertEquals((Object)accessor.getObject(0).toString(), (Object)"1970-01-02");
                Assert.assertEquals((Object)accessor.getObject(1).toString(), (Object)"2008-12-28");
                Assert.assertEquals((Object)accessor.getObject(2).toString(), (Object)"2000-02-27");
            }
            batchLoader.clear();
            for (QueryDataBatch b : results) {
                b.release();
            }
        }
    }

    @Test
    public void testSortDate() throws Exception {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/record/vector/test_sort_date.json"), (Charset)Charsets.UTF_8).replace("#{TEST_FILE}", "/test_simple_date.json"));
            RecordBatchLoader batchLoader = new RecordBatchLoader(bit.getContext().getAllocator());
            QueryDataBatch batch = (QueryDataBatch)results.get(1);
            Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
            for (VectorWrapper v : batchLoader) {
                ValueVector.Accessor accessor = v.getValueVector().getAccessor();
                Assert.assertEquals((Object)accessor.getObject(0).toString(), (Object)new String("1970-01-02"));
                Assert.assertEquals((Object)accessor.getObject(1).toString(), (Object)new String("2000-02-27"));
                Assert.assertEquals((Object)accessor.getObject(2).toString(), (Object)new String("2008-12-28"));
            }
            batchLoader.clear();
            for (QueryDataBatch b : results) {
                b.release();
            }
        }
    }

    @Test
    public void testTimeStamp() throws Exception {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/record/vector/test_timestamp.json"), (Charset)Charsets.UTF_8).replace("#{TEST_FILE}", "/test_simple_date.json"));
            RecordBatchLoader batchLoader = new RecordBatchLoader(bit.getContext().getAllocator());
            QueryDataBatch batch = (QueryDataBatch)results.get(0);
            Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
            for (VectorWrapper v : batchLoader) {
                ValueVector.Accessor accessor = v.getValueVector().getAccessor();
                Assert.assertEquals((Object)accessor.getObject(0).toString(), (Object)"1970-01-02 10:20:33.000");
                Assert.assertEquals((Object)accessor.getObject(1).toString(), (Object)"2008-12-28 11:34:00.129");
                Assert.assertEquals((Object)accessor.getObject(2).toString(), (Object)"2000-02-27 14:24:00.000");
            }
            batchLoader.clear();
            for (QueryDataBatch b : results) {
                b.release();
            }
        }
    }

    @Test
    public void testInterval() throws Exception {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/record/vector/test_interval.json"), (Charset)Charsets.UTF_8).replace("#{TEST_FILE}", "/test_simple_interval.json"));
            RecordBatchLoader batchLoader = new RecordBatchLoader(bit.getContext().getAllocator());
            QueryDataBatch batch = (QueryDataBatch)results.get(0);
            Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
            Iterator itr = batchLoader.iterator();
            ValueVector.Accessor accessor = ((VectorWrapper)itr.next()).getValueVector().getAccessor();
            Assert.assertEquals((Object)accessor.getObject(0).toString(), (Object)"2 years 2 months 1 day 1:20:35.0");
            Assert.assertEquals((Object)accessor.getObject(1).toString(), (Object)"2 years 2 months 0 days 0:0:0.0");
            Assert.assertEquals((Object)accessor.getObject(2).toString(), (Object)"0 years 0 months 0 days 1:20:35.0");
            Assert.assertEquals((Object)accessor.getObject(3).toString(), (Object)"2 years 2 months 1 day 1:20:35.897");
            Assert.assertEquals((Object)accessor.getObject(4).toString(), (Object)"0 years 0 months 0 days 0:0:35.4");
            Assert.assertEquals((Object)accessor.getObject(5).toString(), (Object)"1 year 10 months 1 day 0:-39:-25.0");
            accessor = ((VectorWrapper)itr.next()).getValueVector().getAccessor();
            Assert.assertEquals((Object)accessor.getObject(0).toString(), (Object)"2 years 2 months ");
            Assert.assertEquals((Object)accessor.getObject(1).toString(), (Object)"2 years 2 months ");
            Assert.assertEquals((Object)accessor.getObject(2).toString(), (Object)"0 years 0 months ");
            Assert.assertEquals((Object)accessor.getObject(3).toString(), (Object)"2 years 2 months ");
            Assert.assertEquals((Object)accessor.getObject(4).toString(), (Object)"0 years 0 months ");
            Assert.assertEquals((Object)accessor.getObject(5).toString(), (Object)"1 year 10 months ");
            accessor = ((VectorWrapper)itr.next()).getValueVector().getAccessor();
            Assert.assertEquals((Object)accessor.getObject(0).toString(), (Object)"1 day 1:20:35.0");
            Assert.assertEquals((Object)accessor.getObject(1).toString(), (Object)"0 days 0:0:0.0");
            Assert.assertEquals((Object)accessor.getObject(2).toString(), (Object)"0 days 1:20:35.0");
            Assert.assertEquals((Object)accessor.getObject(3).toString(), (Object)"1 day 1:20:35.897");
            Assert.assertEquals((Object)accessor.getObject(4).toString(), (Object)"0 days 0:0:35.4");
            Assert.assertEquals((Object)accessor.getObject(5).toString(), (Object)"1 day 0:-39:-25.0");
            batchLoader.clear();
            for (QueryDataBatch b : results) {
                b.release();
            }
        }
    }

    @Test
    public void testLiterals() throws Exception {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/record/vector/test_all_date_literals.json"), (Charset)Charsets.UTF_8).replace("#{TEST_FILE}", "/test_simple_date.json"));
            RecordBatchLoader batchLoader = new RecordBatchLoader(bit.getContext().getAllocator());
            QueryDataBatch batch = (QueryDataBatch)results.get(0);
            Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
            String[] result = new String[]{"2008-02-27", "2008-02-27 01:02:03.000", "10:11:13.999", "2 years 2 months 3 days 0:1:3.89"};
            int idx = 0;
            for (VectorWrapper v : batchLoader) {
                ValueVector.Accessor accessor = v.getValueVector().getAccessor();
                Assert.assertEquals((Object)accessor.getObject(0).toString(), (Object)result[idx++]);
            }
            batchLoader.clear();
            for (QueryDataBatch b : results) {
                b.release();
            }
        }
    }

    @Test
    public void testDateAdd() throws Exception {
        try (RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
             Drillbit bit = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/record/vector/test_date_add.json"), (Charset)Charsets.UTF_8).replace("#{TEST_FILE}", "/test_simple_date.json"));
            RecordBatchLoader batchLoader = new RecordBatchLoader(bit.getContext().getAllocator());
            QueryDataBatch batch = (QueryDataBatch)results.get(0);
            Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
            for (VectorWrapper v : batchLoader) {
                ValueVector.Accessor accessor = v.getValueVector().getAccessor();
                Assert.assertEquals((Object)accessor.getObject(0).toString(), (Object)"2008-03-27 00:00:00.000");
            }
            batchLoader.clear();
            for (QueryDataBatch b : results) {
                b.release();
            }
        }
    }
}

