/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record;

import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.record.MaterializedField;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMaterializedField {
    private static final String PARENT_NAME = "parent";
    private static final String PARENT_SECOND_NAME = "parent2";
    private static final String CHILD_NAME = "child";
    private static final String CHILD_SECOND_NAME = "child2";
    private static final TypeProtos.MajorType PARENT_TYPE = Types.repeated((TypeProtos.MinorType)TypeProtos.MinorType.MAP);
    private static final TypeProtos.MajorType PARENT_SECOND_TYPE = Types.repeated((TypeProtos.MinorType)TypeProtos.MinorType.LIST);
    private static final TypeProtos.MajorType CHILD_TYPE = Types.repeated((TypeProtos.MinorType)TypeProtos.MinorType.MAP);
    private static final TypeProtos.MajorType CHILD_SECOND_TYPE = Types.repeated((TypeProtos.MinorType)TypeProtos.MinorType.MAP);
    private static final Object[][] matrix = new Object[][]{{"parent2", PARENT_TYPE}, {"parent", PARENT_SECOND_TYPE}, {"child2", CHILD_TYPE}, {"child", CHILD_SECOND_TYPE}};
    private MaterializedField parent;
    private MaterializedField child;

    @Before
    public void initialize() {
        this.parent = MaterializedField.create((String)PARENT_NAME, (TypeProtos.MajorType)PARENT_TYPE);
        this.child = MaterializedField.create((String)CHILD_NAME, (TypeProtos.MajorType)CHILD_TYPE);
        this.parent.addChild(this.child);
    }

    @Test
    public void testClone() {
        MaterializedField cloneParent = this.parent.clone();
        boolean isParentEqual = this.parent.equals((Object)cloneParent);
        Assert.assertTrue((String)"Cloned parent does not match the original", (boolean)isParentEqual);
        MaterializedField cloneChild = this.child.clone();
        boolean isChildEqual = this.child.equals((Object)cloneChild);
        Assert.assertTrue((String)"Cloned child does not match the original", (boolean)isChildEqual);
        for (MaterializedField field : new MaterializedField[]{this.parent, this.child}) {
            for (Object[] args : matrix) {
                SchemaPath path = SchemaPath.getSimplePath((String)args[0].toString());
                TypeProtos.MajorType type = (TypeProtos.MajorType)TypeProtos.MajorType.class.cast(args[1]);
                MaterializedField clone = field.withPathAndType(path, type);
                boolean isPathEqual = path.equals((Object)clone.getPath());
                Assert.assertTrue((String)"Cloned path does not match the original", (boolean)isPathEqual);
                boolean isTypeEqual = type.equals((Object)clone.getType());
                Assert.assertTrue((String)"Cloned type does not match the original", (boolean)isTypeEqual);
                boolean isChildrenEqual = field.getChildren().equals(clone.getChildren());
                Assert.assertTrue((String)"Cloned children do not match the original", (boolean)isChildrenEqual);
            }
        }
    }
}

