/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record;

import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.ComplexHolder;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.Decimal18Holder;
import org.apache.drill.exec.expr.holders.Decimal28DenseHolder;
import org.apache.drill.exec.expr.holders.Decimal28SparseHolder;
import org.apache.drill.exec.expr.holders.Decimal38DenseHolder;
import org.apache.drill.exec.expr.holders.Decimal38SparseHolder;
import org.apache.drill.exec.expr.holders.Decimal9Holder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.IntervalDayHolder;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.IntervalYearHolder;
import org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.apache.drill.exec.expr.holders.NullableDateHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal18Holder;
import org.apache.drill.exec.expr.holders.NullableDecimal28DenseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal28SparseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal38DenseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal38SparseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal9Holder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalDayHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalYearHolder;
import org.apache.drill.exec.expr.holders.NullableSmallIntHolder;
import org.apache.drill.exec.expr.holders.NullableTimeHolder;
import org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import org.apache.drill.exec.expr.holders.NullableTinyIntHolder;
import org.apache.drill.exec.expr.holders.NullableUInt1Holder;
import org.apache.drill.exec.expr.holders.NullableUInt2Holder;
import org.apache.drill.exec.expr.holders.NullableUInt4Holder;
import org.apache.drill.exec.expr.holders.NullableUInt8Holder;
import org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.RepeatedBigIntHolder;
import org.apache.drill.exec.expr.holders.RepeatedBitHolder;
import org.apache.drill.exec.expr.holders.RepeatedDateHolder;
import org.apache.drill.exec.expr.holders.RepeatedDecimal18Holder;
import org.apache.drill.exec.expr.holders.RepeatedDecimal28DenseHolder;
import org.apache.drill.exec.expr.holders.RepeatedDecimal28SparseHolder;
import org.apache.drill.exec.expr.holders.RepeatedDecimal38DenseHolder;
import org.apache.drill.exec.expr.holders.RepeatedDecimal38SparseHolder;
import org.apache.drill.exec.expr.holders.RepeatedDecimal9Holder;
import org.apache.drill.exec.expr.holders.RepeatedFloat4Holder;
import org.apache.drill.exec.expr.holders.RepeatedFloat8Holder;
import org.apache.drill.exec.expr.holders.RepeatedIntHolder;
import org.apache.drill.exec.expr.holders.RepeatedIntervalDayHolder;
import org.apache.drill.exec.expr.holders.RepeatedIntervalHolder;
import org.apache.drill.exec.expr.holders.RepeatedIntervalYearHolder;
import org.apache.drill.exec.expr.holders.RepeatedSmallIntHolder;
import org.apache.drill.exec.expr.holders.RepeatedTimeHolder;
import org.apache.drill.exec.expr.holders.RepeatedTimeStampHolder;
import org.apache.drill.exec.expr.holders.RepeatedTinyIntHolder;
import org.apache.drill.exec.expr.holders.RepeatedUInt1Holder;
import org.apache.drill.exec.expr.holders.RepeatedUInt2Holder;
import org.apache.drill.exec.expr.holders.RepeatedUInt4Holder;
import org.apache.drill.exec.expr.holders.RepeatedUInt8Holder;
import org.apache.drill.exec.expr.holders.RepeatedVar16CharHolder;
import org.apache.drill.exec.expr.holders.RepeatedVarBinaryHolder;
import org.apache.drill.exec.expr.holders.RepeatedVarCharHolder;
import org.apache.drill.exec.expr.holders.SmallIntHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.expr.holders.TinyIntHolder;
import org.apache.drill.exec.expr.holders.UInt1Holder;
import org.apache.drill.exec.expr.holders.UInt2Holder;
import org.apache.drill.exec.expr.holders.UInt4Holder;
import org.apache.drill.exec.expr.holders.UInt8Holder;
import org.apache.drill.exec.expr.holders.Var16CharHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.vector.BigIntVector;
import org.apache.drill.exec.vector.BitVector;
import org.apache.drill.exec.vector.DateVector;
import org.apache.drill.exec.vector.Decimal18Vector;
import org.apache.drill.exec.vector.Decimal28DenseVector;
import org.apache.drill.exec.vector.Decimal28SparseVector;
import org.apache.drill.exec.vector.Decimal38DenseVector;
import org.apache.drill.exec.vector.Decimal38SparseVector;
import org.apache.drill.exec.vector.Decimal9Vector;
import org.apache.drill.exec.vector.Float4Vector;
import org.apache.drill.exec.vector.Float8Vector;
import org.apache.drill.exec.vector.IntVector;
import org.apache.drill.exec.vector.IntervalDayVector;
import org.apache.drill.exec.vector.IntervalVector;
import org.apache.drill.exec.vector.IntervalYearVector;
import org.apache.drill.exec.vector.NullableBigIntVector;
import org.apache.drill.exec.vector.NullableBitVector;
import org.apache.drill.exec.vector.NullableDateVector;
import org.apache.drill.exec.vector.NullableDecimal18Vector;
import org.apache.drill.exec.vector.NullableDecimal28DenseVector;
import org.apache.drill.exec.vector.NullableDecimal28SparseVector;
import org.apache.drill.exec.vector.NullableDecimal38DenseVector;
import org.apache.drill.exec.vector.NullableDecimal38SparseVector;
import org.apache.drill.exec.vector.NullableDecimal9Vector;
import org.apache.drill.exec.vector.NullableFloat4Vector;
import org.apache.drill.exec.vector.NullableFloat8Vector;
import org.apache.drill.exec.vector.NullableIntVector;
import org.apache.drill.exec.vector.NullableIntervalDayVector;
import org.apache.drill.exec.vector.NullableIntervalVector;
import org.apache.drill.exec.vector.NullableIntervalYearVector;
import org.apache.drill.exec.vector.NullableSmallIntVector;
import org.apache.drill.exec.vector.NullableTimeStampVector;
import org.apache.drill.exec.vector.NullableTimeVector;
import org.apache.drill.exec.vector.NullableTinyIntVector;
import org.apache.drill.exec.vector.NullableUInt1Vector;
import org.apache.drill.exec.vector.NullableUInt2Vector;
import org.apache.drill.exec.vector.NullableUInt4Vector;
import org.apache.drill.exec.vector.NullableUInt8Vector;
import org.apache.drill.exec.vector.NullableVar16CharVector;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.RepeatedBigIntVector;
import org.apache.drill.exec.vector.RepeatedBitVector;
import org.apache.drill.exec.vector.RepeatedDateVector;
import org.apache.drill.exec.vector.RepeatedDecimal18Vector;
import org.apache.drill.exec.vector.RepeatedDecimal28DenseVector;
import org.apache.drill.exec.vector.RepeatedDecimal28SparseVector;
import org.apache.drill.exec.vector.RepeatedDecimal38DenseVector;
import org.apache.drill.exec.vector.RepeatedDecimal38SparseVector;
import org.apache.drill.exec.vector.RepeatedDecimal9Vector;
import org.apache.drill.exec.vector.RepeatedFloat4Vector;
import org.apache.drill.exec.vector.RepeatedFloat8Vector;
import org.apache.drill.exec.vector.RepeatedIntVector;
import org.apache.drill.exec.vector.RepeatedIntervalDayVector;
import org.apache.drill.exec.vector.RepeatedIntervalVector;
import org.apache.drill.exec.vector.RepeatedIntervalYearVector;
import org.apache.drill.exec.vector.RepeatedSmallIntVector;
import org.apache.drill.exec.vector.RepeatedTimeStampVector;
import org.apache.drill.exec.vector.RepeatedTimeVector;
import org.apache.drill.exec.vector.RepeatedTinyIntVector;
import org.apache.drill.exec.vector.RepeatedUInt1Vector;
import org.apache.drill.exec.vector.RepeatedUInt2Vector;
import org.apache.drill.exec.vector.RepeatedUInt4Vector;
import org.apache.drill.exec.vector.RepeatedUInt8Vector;
import org.apache.drill.exec.vector.RepeatedVar16CharVector;
import org.apache.drill.exec.vector.RepeatedVarBinaryVector;
import org.apache.drill.exec.vector.RepeatedVarCharVector;
import org.apache.drill.exec.vector.SmallIntVector;
import org.apache.drill.exec.vector.TimeStampVector;
import org.apache.drill.exec.vector.TimeVector;
import org.apache.drill.exec.vector.TinyIntVector;
import org.apache.drill.exec.vector.UInt1Vector;
import org.apache.drill.exec.vector.UInt2Vector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.UInt8Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.Var16CharVector;
import org.apache.drill.exec.vector.VarBinaryVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordValueAccessor {
    static final Logger logger = LoggerFactory.getLogger(RecordValueAccessor.class);
    private VectorAccessible batch;
    private int currentIndex;
    private ValueVector[] vectors;

    public RecordValueAccessor(VectorAccessible batch) {
        this.batch = batch;
        this.resetIterator();
        this.initVectorWrappers();
    }

    public void resetIterator() {
        this.currentIndex = -1;
    }

    private void initVectorWrappers() {
        BatchSchema schema = this.batch.getSchema();
        this.vectors = new ValueVector[schema.getFieldCount()];
        int fieldId = 0;
        for (MaterializedField field : schema) {
            Class<?> vectorClass = TypeHelper.getValueVectorClass(field.getType().getMinorType(), field.getType().getMode());
            this.vectors[fieldId] = this.batch.getValueAccessorById(vectorClass, new int[]{fieldId}).getValueVector();
            ++fieldId;
        }
    }

    public boolean next() {
        return ++this.currentIndex < this.batch.getRecordCount();
    }

    public void getFieldById(int fieldId, ComplexHolder holder) {
        holder.isSet = this.vectors[fieldId].getAccessor().isNull(this.currentIndex) ? 1 : 0;
        holder.reader = this.vectors[fieldId].getReader();
        holder.reader.setPosition(this.currentIndex);
    }

    public void getFieldById(int fieldId, NullableTinyIntHolder holder) {
        ((NullableTinyIntVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, TinyIntHolder holder) {
        ((TinyIntVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedTinyIntHolder holder) {
        ((RepeatedTinyIntVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableUInt1Holder holder) {
        ((NullableUInt1Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, UInt1Holder holder) {
        ((UInt1Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedUInt1Holder holder) {
        ((RepeatedUInt1Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableUInt2Holder holder) {
        ((NullableUInt2Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, UInt2Holder holder) {
        ((UInt2Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedUInt2Holder holder) {
        ((RepeatedUInt2Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableSmallIntHolder holder) {
        ((NullableSmallIntVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, SmallIntHolder holder) {
        ((SmallIntVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedSmallIntHolder holder) {
        ((RepeatedSmallIntVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableIntHolder holder) {
        ((NullableIntVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, IntHolder holder) {
        ((IntVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedIntHolder holder) {
        ((RepeatedIntVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableUInt4Holder holder) {
        ((NullableUInt4Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, UInt4Holder holder) {
        ((UInt4Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedUInt4Holder holder) {
        ((RepeatedUInt4Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableFloat4Holder holder) {
        ((NullableFloat4Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, Float4Holder holder) {
        ((Float4Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedFloat4Holder holder) {
        ((RepeatedFloat4Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableTimeHolder holder) {
        ((NullableTimeVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, TimeHolder holder) {
        ((TimeVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedTimeHolder holder) {
        ((RepeatedTimeVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableIntervalYearHolder holder) {
        ((NullableIntervalYearVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, IntervalYearHolder holder) {
        ((IntervalYearVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedIntervalYearHolder holder) {
        ((RepeatedIntervalYearVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableDecimal9Holder holder) {
        ((NullableDecimal9Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, Decimal9Holder holder) {
        ((Decimal9Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedDecimal9Holder holder) {
        ((RepeatedDecimal9Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableBigIntHolder holder) {
        ((NullableBigIntVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, BigIntHolder holder) {
        ((BigIntVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedBigIntHolder holder) {
        ((RepeatedBigIntVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableUInt8Holder holder) {
        ((NullableUInt8Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, UInt8Holder holder) {
        ((UInt8Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedUInt8Holder holder) {
        ((RepeatedUInt8Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableFloat8Holder holder) {
        ((NullableFloat8Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, Float8Holder holder) {
        ((Float8Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedFloat8Holder holder) {
        ((RepeatedFloat8Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableDateHolder holder) {
        ((NullableDateVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, DateHolder holder) {
        ((DateVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedDateHolder holder) {
        ((RepeatedDateVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableTimeStampHolder holder) {
        ((NullableTimeStampVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, TimeStampHolder holder) {
        ((TimeStampVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedTimeStampHolder holder) {
        ((RepeatedTimeStampVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableDecimal18Holder holder) {
        ((NullableDecimal18Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, Decimal18Holder holder) {
        ((Decimal18Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedDecimal18Holder holder) {
        ((RepeatedDecimal18Vector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableIntervalDayHolder holder) {
        ((NullableIntervalDayVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, IntervalDayHolder holder) {
        ((IntervalDayVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedIntervalDayHolder holder) {
        ((RepeatedIntervalDayVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableIntervalHolder holder) {
        ((NullableIntervalVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, IntervalHolder holder) {
        ((IntervalVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedIntervalHolder holder) {
        ((RepeatedIntervalVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableDecimal28DenseHolder holder) {
        ((NullableDecimal28DenseVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, Decimal28DenseHolder holder) {
        ((Decimal28DenseVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedDecimal28DenseHolder holder) {
        ((RepeatedDecimal28DenseVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableDecimal38DenseHolder holder) {
        ((NullableDecimal38DenseVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, Decimal38DenseHolder holder) {
        ((Decimal38DenseVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedDecimal38DenseHolder holder) {
        ((RepeatedDecimal38DenseVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableDecimal38SparseHolder holder) {
        ((NullableDecimal38SparseVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, Decimal38SparseHolder holder) {
        ((Decimal38SparseVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedDecimal38SparseHolder holder) {
        ((RepeatedDecimal38SparseVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableDecimal28SparseHolder holder) {
        ((NullableDecimal28SparseVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, Decimal28SparseHolder holder) {
        ((Decimal28SparseVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedDecimal28SparseHolder holder) {
        ((RepeatedDecimal28SparseVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableVarBinaryHolder holder) {
        ((NullableVarBinaryVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, VarBinaryHolder holder) {
        ((VarBinaryVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedVarBinaryHolder holder) {
        ((RepeatedVarBinaryVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableVarCharHolder holder) {
        ((NullableVarCharVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, VarCharHolder holder) {
        ((VarCharVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedVarCharHolder holder) {
        ((RepeatedVarCharVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableVar16CharHolder holder) {
        ((NullableVar16CharVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, Var16CharHolder holder) {
        ((Var16CharVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedVar16CharHolder holder) {
        ((RepeatedVar16CharVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, NullableBitHolder holder) {
        ((NullableBitVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, BitHolder holder) {
        ((BitVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }

    public void getFieldById(int fieldId, RepeatedBitHolder holder) {
        ((RepeatedBitVector)this.vectors[fieldId]).getAccessor().get(this.currentIndex, holder);
    }
}

