/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.util.List;
import mockit.Injectable;
import mockit.NonStrictExpectations;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.expression.ErrorCollector;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.IfExpression;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.TypedNullConstant;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.expr.fn.FunctionLookupContext;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.SchemaBuilder;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorAccessible;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionTreeMaterializerTest
extends ExecTest {
    static final Logger logger = LoggerFactory.getLogger(ExpressionTreeMaterializerTest.class);
    final TypeProtos.MajorType boolConstant = TypeProtos.MajorType.newBuilder().setMode(TypeProtos.DataMode.REQUIRED).setMinorType(TypeProtos.MinorType.BIT).build();
    final TypeProtos.MajorType bigIntType = TypeProtos.MajorType.newBuilder().setMode(TypeProtos.DataMode.REQUIRED).setMinorType(TypeProtos.MinorType.BIGINT).build();
    final TypeProtos.MajorType intType = TypeProtos.MajorType.newBuilder().setMode(TypeProtos.DataMode.REQUIRED).setMinorType(TypeProtos.MinorType.INT).build();
    DrillConfig c = DrillConfig.create();
    FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);

    private MaterializedField getField(int fieldId, String name, TypeProtos.MajorType type) {
        return MaterializedField.create((SchemaPath)SchemaPath.getSimplePath((String)name), (TypeProtos.MajorType)type);
    }

    @Test
    public void testMaterializingConstantTree(@Injectable RecordBatch batch) throws SchemaChangeException {
        ErrorCollectorImpl ec = new ErrorCollectorImpl();
        LogicalExpression expr = ExpressionTreeMaterializer.materialize((LogicalExpression)new ValueExpressions.LongExpression(1L, ExpressionPosition.UNKNOWN), (VectorAccessible)batch, (ErrorCollector)ec, (FunctionLookupContext)this.registry);
        Assert.assertTrue((boolean)(expr instanceof ValueExpressions.LongExpression));
        Assert.assertEquals((long)1L, (long)((ValueExpressions.LongExpression)ValueExpressions.LongExpression.class.cast(expr)).getLong());
        Assert.assertFalse((boolean)ec.hasErrors());
    }

    @Test
    public void testMaterializingLateboundField(final @Injectable RecordBatch batch) throws SchemaChangeException {
        SchemaBuilder builder = BatchSchema.newBuilder();
        builder.addField(this.getField(2, "test", this.bigIntType));
        BatchSchema schema = builder.build();
        new NonStrictExpectations(){
            {
                batch.getValueVectorId(new SchemaPath("test", ExpressionPosition.UNKNOWN));
                result = new TypedFieldId(Types.required((TypeProtos.MinorType)TypeProtos.MinorType.BIGINT), new int[]{-5});
            }
        };
        ErrorCollectorImpl ec = new ErrorCollectorImpl();
        LogicalExpression expr = ExpressionTreeMaterializer.materialize((LogicalExpression)new FieldReference((CharSequence)"test", ExpressionPosition.UNKNOWN), (VectorAccessible)batch, (ErrorCollector)ec, (FunctionLookupContext)this.registry);
        Assert.assertEquals((Object)this.bigIntType, (Object)expr.getMajorType());
        Assert.assertFalse((boolean)ec.hasErrors());
    }

    @Test
    public void testMaterializingLateboundTree(final @Injectable RecordBatch batch) throws SchemaChangeException {
        new NonStrictExpectations(){
            {
                batch.getValueVectorId(SchemaPath.getSimplePath((String)"test"));
                result = new TypedFieldId(Types.required((TypeProtos.MinorType)TypeProtos.MinorType.BIT), new int[]{-4});
                batch.getValueVectorId(SchemaPath.getSimplePath((String)"test1"));
                result = new TypedFieldId(Types.required((TypeProtos.MinorType)TypeProtos.MinorType.BIGINT), new int[]{-5});
            }
        };
        ErrorCollectorImpl ec = new ErrorCollectorImpl();
        IfExpression elseExpression = new IfExpression.Builder().setElse((LogicalExpression)new ValueExpressions.LongExpression(1L, ExpressionPosition.UNKNOWN)).setIfCondition(new IfExpression.IfCondition((LogicalExpression)new ValueExpressions.BooleanExpression("true", ExpressionPosition.UNKNOWN), (LogicalExpression)new FieldReference((CharSequence)"test1", ExpressionPosition.UNKNOWN))).build();
        IfExpression expr = new IfExpression.Builder().setIfCondition(new IfExpression.IfCondition((LogicalExpression)new FieldReference((CharSequence)"test", ExpressionPosition.UNKNOWN), (LogicalExpression)new ValueExpressions.LongExpression(2L, ExpressionPosition.UNKNOWN))).setElse((LogicalExpression)elseExpression).build();
        LogicalExpression newExpr = ExpressionTreeMaterializer.materialize((LogicalExpression)expr, (VectorAccessible)batch, (ErrorCollector)ec, (FunctionLookupContext)this.registry);
        Assert.assertTrue((boolean)(newExpr instanceof IfExpression));
        IfExpression newIfExpr = (IfExpression)newExpr;
        IfExpression.IfCondition ifCondition = newIfExpr.ifCondition;
        Assert.assertTrue((boolean)(newIfExpr.elseExpression instanceof IfExpression));
        Assert.assertEquals((Object)this.bigIntType, (Object)ifCondition.expression.getMajorType());
        Assert.assertEquals((Object)true, (Object)((ValueExpressions.BooleanExpression)((IfExpression)newIfExpr.elseExpression).ifCondition.condition).value);
        if (ec.hasErrors()) {
            System.out.println(ec.toErrorString());
        }
        Assert.assertFalse((boolean)ec.hasErrors());
    }

    @Test
    public void testMaterializingLateboundTreeValidated(final @Injectable RecordBatch batch) throws SchemaChangeException {
        ErrorCollector ec = new ErrorCollector(){
            int errorCount = 0;

            public void addGeneralError(ExpressionPosition expr, String s) {
                ++this.errorCount;
            }

            public void addUnexpectedArgumentType(ExpressionPosition expr, String name, TypeProtos.MajorType actual, TypeProtos.MajorType[] expected, int argumentIndex) {
                ++this.errorCount;
            }

            public void addUnexpectedArgumentCount(ExpressionPosition expr, int actual, Range<Integer> expected) {
                ++this.errorCount;
            }

            public void addUnexpectedArgumentCount(ExpressionPosition expr, int actual, int expected) {
                ++this.errorCount;
            }

            public void addNonNumericType(ExpressionPosition expr, TypeProtos.MajorType actual) {
                ++this.errorCount;
            }

            public void addUnexpectedType(ExpressionPosition expr, int index, TypeProtos.MajorType actual) {
                ++this.errorCount;
            }

            public void addExpectedConstantValue(ExpressionPosition expr, int actual, String s) {
                ++this.errorCount;
            }

            public boolean hasErrors() {
                return this.errorCount > 0;
            }

            public String toErrorString() {
                return String.format("Found %s errors.", this.errorCount);
            }

            public int getErrorCount() {
                return this.errorCount;
            }
        };
        new NonStrictExpectations(){
            {
                batch.getValueVectorId(new SchemaPath("test", ExpressionPosition.UNKNOWN));
                result = new TypedFieldId(Types.required((TypeProtos.MinorType)TypeProtos.MinorType.BIGINT), new int[]{-5});
            }
        };
        FunctionCall functionCallExpr = new FunctionCall("testFunc", (List)ImmutableList.of((Object)new FieldReference((CharSequence)"test", ExpressionPosition.UNKNOWN)), ExpressionPosition.UNKNOWN);
        LogicalExpression newExpr = ExpressionTreeMaterializer.materialize((LogicalExpression)functionCallExpr, (VectorAccessible)batch, (ErrorCollector)ec, (FunctionLookupContext)this.registry);
        Assert.assertTrue((boolean)(newExpr instanceof TypedNullConstant));
        Assert.assertEquals((long)1L, (long)ec.getErrorCount());
        System.out.println(ec.toErrorString());
    }
}

