/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.pop;

import java.io.IOException;
import org.apache.drill.exec.exception.FragmentSetupException;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.planner.fragment.Fragment;
import org.apache.drill.exec.pop.PopUnitTestBase;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFragmenter
extends PopUnitTestBase {
    static final Logger logger = LoggerFactory.getLogger(TestFragmenter.class);

    @Test
    public void ensureOneFragment() throws FragmentSetupException, IOException, ForemanSetupException {
        PhysicalPlanReader ppr = new PhysicalPlanReader(CONFIG, CONFIG.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        Fragment b = TestFragmenter.getRootFragment(ppr, "/physical_test1.json");
        Assert.assertEquals((long)1L, (long)TestFragmenter.getFragmentCount(b));
        Assert.assertEquals((long)0L, (long)b.getReceivingExchangePairs().size());
        Assert.assertNull((Object)b.getSendingExchange());
    }

    @Test
    public void ensureThreeFragments() throws FragmentSetupException, IOException, ForemanSetupException {
        PhysicalPlanReader ppr = new PhysicalPlanReader(CONFIG, CONFIG.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        Fragment b = TestFragmenter.getRootFragment(ppr, "/physical_double_exchange.json");
        logger.debug("Fragment Node {}", (Object)b);
        Assert.assertEquals((long)3L, (long)TestFragmenter.getFragmentCount(b));
        Assert.assertEquals((long)1L, (long)b.getReceivingExchangePairs().size());
        Assert.assertNull((Object)b.getSendingExchange());
        b = ((Fragment.ExchangeFragmentPair)b.iterator().next()).getNode();
        Assert.assertEquals((long)1L, (long)b.getReceivingExchangePairs().size());
        Assert.assertNotNull((Object)b.getSendingExchange());
        b = ((Fragment.ExchangeFragmentPair)b.iterator().next()).getNode();
        Assert.assertEquals((long)0L, (long)b.getReceivingExchangePairs().size());
        Assert.assertNotNull((Object)b.getSendingExchange());
    }
}

