/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.pop;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.planner.fragment.Fragment;
import org.apache.drill.exec.planner.fragment.SimpleParallelizer;
import org.apache.drill.exec.pop.PopUnitTestBase;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.server.options.OptionList;
import org.apache.drill.exec.util.Utilities;
import org.apache.drill.exec.work.QueryWorkUnit;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFragmentChecker
extends PopUnitTestBase {
    static final Logger logger = LoggerFactory.getLogger(TestFragmentChecker.class);

    @Test
    public void checkSimpleExchangePlan() throws Exception {
        this.print("/physical_double_exchange.json", 2, 3);
    }

    private void print(String fragmentFile, int bitCount, int expectedFragmentCount) throws Exception {
        System.out.println(String.format("=================Building plan fragments for [%s].  Allowing %d total Drillbits.==================", fragmentFile, bitCount));
        PhysicalPlanReader ppr = new PhysicalPlanReader(CONFIG, CONFIG.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        Fragment fragmentRoot = TestFragmentChecker.getRootFragment(ppr, fragmentFile);
        SimpleParallelizer par = new SimpleParallelizer(1000000L, 5, 10, 1.2);
        ArrayList endpoints = Lists.newArrayList();
        CoordinationProtos.DrillbitEndpoint localBit = null;
        for (int i = 0; i < bitCount; ++i) {
            CoordinationProtos.DrillbitEndpoint b1 = CoordinationProtos.DrillbitEndpoint.newBuilder().setAddress("localhost").setControlPort(1234 + i).build();
            if (i == 0) {
                localBit = b1;
            }
            endpoints.add(b1);
        }
        BitControl.QueryContextInformation queryContextInfo = Utilities.createQueryContextInfo((String)"dummySchemaName");
        QueryWorkUnit qwu = par.getFragments(new OptionList(), localBit, UserBitShared.QueryId.getDefaultInstance(), (Collection)endpoints, ppr, fragmentRoot, UserSession.Builder.newBuilder().withCredentials(UserBitShared.UserCredentials.newBuilder().setUserName("foo").build()).build(), queryContextInfo);
        System.out.println(String.format("=========ROOT FRAGMENT [%d:%d] =========", qwu.getRootFragment().getHandle().getMajorFragmentId(), qwu.getRootFragment().getHandle().getMinorFragmentId()));
        System.out.print(qwu.getRootFragment().getFragmentJson());
        for (BitControl.PlanFragment f : qwu.getFragments()) {
            System.out.println(String.format("=========Fragment [%d:%d]=====", f.getHandle().getMajorFragmentId(), f.getHandle().getMinorFragmentId()));
            System.out.print(f.getFragmentJson());
        }
        Assert.assertEquals((long)expectedFragmentCount, (long)(qwu.getFragments().size() + 1));
    }

    @Test
    public void validateSingleExchangeFragment() throws Exception {
        this.print("/physical_single_exchange.json", 1, 2);
    }
}

