/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.pop;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.exception.FragmentSetupException;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.planner.fragment.Fragment;
import org.apache.drill.exec.planner.fragment.MakeFragmentsVisitor;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PopUnitTestBase
extends ExecTest {
    static final Logger logger = LoggerFactory.getLogger(PopUnitTestBase.class);
    protected static DrillConfig CONFIG;

    @BeforeClass
    public static void setup() {
        CONFIG = DrillConfig.create();
    }

    public static int getFragmentCount(Fragment b) {
        int i = 1;
        for (Fragment.ExchangeFragmentPair p : b) {
            i += PopUnitTestBase.getFragmentCount(p.getNode());
        }
        return i;
    }

    public static Fragment getRootFragment(PhysicalPlanReader reader, String file) throws FragmentSetupException, IOException, ForemanSetupException {
        return PopUnitTestBase.getRootFragmentFromPlanString(reader, Files.toString((File)FileUtils.getResourceAsFile((String)file), (Charset)Charsets.UTF_8));
    }

    public static Fragment getRootFragmentFromPlanString(PhysicalPlanReader reader, String planString) throws FragmentSetupException, IOException, ForemanSetupException {
        PhysicalPlan plan = reader.readPhysicalPlan(planString);
        PhysicalOperator o = (PhysicalOperator)plan.getSortedOperators(false).iterator().next();
        return (Fragment)o.accept((PhysicalVisitor)MakeFragmentsVisitor.INSTANCE, null);
    }
}

