/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.BitSet;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.exec.planner.logical.partition.FindPartitionConditions;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterSplitTest {
    static final Logger logger = LoggerFactory.getLogger(FilterSplitTest.class);
    final JavaTypeFactory t = new JavaTypeFactoryImpl();
    final RexBuilder builder = new RexBuilder((RelDataTypeFactory)this.t);
    final RelDataType intType = this.t.createSqlType(SqlTypeName.INTEGER);
    final RelDataType sType = this.t.createSqlType(SqlTypeName.VARCHAR, 20);

    @Test
    public void simpleCompound() {
        RexNode n = this.and(this.lt(this.c(0), this.lit(1)), this.or(this.eq(this.c(1), this.lit(2)), this.eq(this.c(1), this.lit(3))));
        BitSet bs = new BitSet();
        bs.set(1);
        FindPartitionConditions c = new FindPartitionConditions(bs, this.builder);
        c.analyze(n);
        RexNode partNode = c.getFinalCondition();
        Assert.assertEquals((Object)n.toString(), (Object)"AND(<($0, 1), OR(=($1, 2), =($1, 3)))");
        Assert.assertEquals((Object)partNode.toString(), (Object)"OR(=($1, 2), =($1, 3))");
    }

    @Test
    public void twoLevelDir() {
        RexNode n = this.or(this.and(this.eq(this.c(1), this.lit(1)), this.eq(this.c(2), this.lit(2))), this.and(this.eq(this.c(1), this.lit(3)), this.eq(this.c(2), this.lit(4))));
        BitSet bs = new BitSet();
        bs.set(1);
        bs.set(2);
        FindPartitionConditions c = new FindPartitionConditions(bs, this.builder);
        c.analyze(n);
        RexNode partNode = c.getFinalCondition();
        Assert.assertEquals((Object)"OR(AND(=($1, 1), =($2, 2)), AND(=($1, 3), =($2, 4)))", (Object)n.toString());
        Assert.assertEquals((Object)"OR(AND(=($1, 1), =($2, 2)), AND(=($1, 3), =($2, 4)))", (Object)partNode.toString());
    }

    @Test
    public void badOr() {
        RexNode n = this.or(this.and(this.eq(this.c(1), this.lit(1)), this.eq(this.c(2), this.lit(2))), this.lt(this.c(0), this.lit(5)));
        BitSet bs = new BitSet();
        bs.set(1);
        bs.set(2);
        FindPartitionConditions c = new FindPartitionConditions(bs, this.builder);
        c.analyze(n);
        RexNode partNode = c.getFinalCondition();
        Assert.assertEquals((Object)"OR(AND(=($1, 1), =($2, 2)), <($0, 5))", (Object)n.toString());
        Assert.assertTrue((partNode == null ? 1 : 0) != 0);
    }

    @Test
    public void badFunc() {
        RexNode n = this.fn(this.cs(0), this.cs(1));
        BitSet bs = new BitSet();
        bs.set(1);
        bs.set(2);
        FindPartitionConditions c = new FindPartitionConditions(bs, this.builder);
        c.analyze(n);
        RexNode partNode = c.getFinalCondition();
        Assert.assertEquals((Object)"||($0, $1)", (Object)n.toString());
        Assert.assertTrue((partNode == null ? 1 : 0) != 0);
    }

    private RexNode and(RexNode ... nodes) {
        return this.builder.makeCall((SqlOperator)SqlStdOperatorTable.AND, nodes);
    }

    private RexNode fn(RexNode ... nodes) {
        return this.builder.makeCall((SqlOperator)SqlStdOperatorTable.CONCAT, nodes);
    }

    private RexNode or(RexNode ... nodes) {
        return this.builder.makeCall((SqlOperator)SqlStdOperatorTable.OR, nodes);
    }

    private RexNode lt(RexNode left, RexNode right) {
        return this.builder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{left, right});
    }

    private RexNode eq(RexNode left, RexNode right) {
        return this.builder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{left, right});
    }

    private RexNode lit(int value) {
        return this.builder.makeLiteral((Object)value, this.intType, true);
    }

    private RexNode c(int index) {
        return this.builder.makeInputRef(this.intType, index);
    }

    private RexNode cs(int index) {
        return this.builder.makeInputRef(this.sType, index);
    }

    private RexNode str(String s) {
        return this.builder.makeLiteral(s);
    }
}

