/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.drill.PlanTestBase;
import org.apache.drill.exec.fn.interp.TestConstantFolding;
import org.apache.drill.exec.util.JsonStringArrayList;
import org.apache.hadoop.io.Text;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestDirectoryExplorerUDFs
extends PlanTestBase {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testConstExprFolding_maxDir0() throws Exception {
        new TestConstantFolding.SmallFileCreator(this.folder).createFiles(1, 1000);
        String path = this.folder.getRoot().toPath().toString();
        TestDirectoryExplorerUDFs.test("use dfs.root");
        ImmutableList tests = ImmutableList.builder().add((Object)new ConstantFoldingTestConfig("maxdir", "smallfile")).add((Object)new ConstantFoldingTestConfig("imaxdir", "SMALLFILE_2")).add((Object)new ConstantFoldingTestConfig("mindir", "BIGFILE_2")).add((Object)new ConstantFoldingTestConfig("imindir", "bigfile")).build();
        ImmutableList allFiles = ImmutableList.builder().add((Object)"smallfile").add((Object)"SMALLFILE_2").add((Object)"bigfile").add((Object)"BIGFILE_2").build();
        String query = "select * from dfs.`" + path + "/*/*.csv` where dir0 = %s('dfs.root','" + path + "')";
        for (ConstantFoldingTestConfig config : tests) {
            ArrayList excludedPatterns = Lists.newArrayList();
            excludedPatterns.addAll(allFiles);
            excludedPatterns.remove(config.expectedFolderName);
            String[] excludedArray = new String[excludedPatterns.size()];
            TestDirectoryExplorerUDFs.testPlanMatchingPatterns(String.format(query, config.funcName), new String[]{config.expectedFolderName}, excludedPatterns.toArray(excludedArray));
        }
        JsonStringArrayList list = new JsonStringArrayList();
        list.add((Object)new Text("1"));
        list.add((Object)new Text("2"));
        list.add((Object)new Text("3"));
        TestDirectoryExplorerUDFs.testBuilder().sqlQuery(String.format(query, ((ConstantFoldingTestConfig)tests.get((int)0)).funcName)).unOrdered().baselineColumns("columns", "dir0").baselineValues(list, ((ConstantFoldingTestConfig)tests.get((int)0)).expectedFolderName).go();
    }

    private class ConstantFoldingTestConfig {
        String funcName;
        String expectedFolderName;

        public ConstantFoldingTestConfig(String funcName, String expectedFolderName) {
            this.funcName = funcName;
            this.expectedFolderName = expectedFolderName;
        }
    }
}

