/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.xsort;

import java.io.IOException;
import java.util.Properties;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.UserRemoteException;
import org.apache.drill.common.util.TestTools;
import org.apache.drill.exec.physical.impl.xsort.ExternalSortBatch;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.testing.Controls;
import org.apache.drill.exec.testing.ControlsInjectionUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSortSpillWithException
extends BaseTestQuery {
    private static final String TEST_RES_PATH = TestTools.getWorkingPath() + "/src/test/resources";

    @BeforeClass
    public static void initCluster() {
        Properties props = TestSortSpillWithException.cloneDefaultTestConfigProperties();
        props.put("drill.exec.sort.external.spill.threshold", "1");
        props.put("drill.exec.sort.external.spill.group.size", "1");
        TestSortSpillWithException.updateTestCluster(1, DrillConfig.create((Properties)props));
    }

    @Test
    public void testSpilLeak() throws Exception {
        String controls = Controls.newBuilder().addExceptionOnBit(ExternalSortBatch.class, "spilling", IOException.class, bits[0].getContext().getEndpoint()).build();
        ControlsInjectionUtil.setControls(client, controls);
        try {
            TestSortSpillWithException.test("select employee_id from dfs_test.`%s/xsort/2batches` order by employee_id", TEST_RES_PATH);
            Assert.fail((String)"Query should have failed!");
        }
        catch (UserRemoteException e) {
            Assert.assertEquals((Object)UserBitShared.DrillPBError.ErrorType.RESOURCE, (Object)e.getErrorType());
            Assert.assertTrue((String)"Incorrect error message", (boolean)e.getMessage().contains("External Sort encountered an error while spilling to disk"));
        }
    }
}

