/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.xsort;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.common.util.TestTools;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.vector.BigIntVector;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class TestSimpleExternalSort
extends BaseTestQuery {
    static final Logger logger = LoggerFactory.getLogger(TestSimpleExternalSort.class);
    DrillConfig c = DrillConfig.create();
    @Rule
    public final TestRule TIMEOUT = TestTools.getTimeoutRule((int)80000);

    @Test
    public void mergeSortWithSv2() throws Exception {
        List<QueryDataBatch> results = TestSimpleExternalSort.testPhysicalFromFileWithResults("xsort/one_key_sort_descending_sv2.json");
        int count = 0;
        for (QueryDataBatch b : results) {
            if (b.getHeader().getRowCount() == 0) continue;
            count += b.getHeader().getRowCount();
        }
        Assert.assertEquals((long)500000L, (long)count);
        long previousBigInt = Long.MAX_VALUE;
        int recordCount = 0;
        int batchCount = 0;
        for (QueryDataBatch b : results) {
            if (b.getHeader().getRowCount() == 0) break;
            ++batchCount;
            RecordBatchLoader loader = new RecordBatchLoader(allocator);
            loader.load(b.getHeader().getDef(), b.getData());
            BigIntVector c1 = (BigIntVector)loader.getValueAccessorById(BigIntVector.class, loader.getValueVectorId(new SchemaPath("blue", ExpressionPosition.UNKNOWN)).getFieldIds()).getValueVector();
            BigIntVector.Accessor a1 = c1.getAccessor();
            for (int i = 0; i < c1.getAccessor().getValueCount(); ++i) {
                ++recordCount;
                Assert.assertTrue((String)String.format("%d > %d", previousBigInt, a1.get(i)), (previousBigInt >= a1.get(i) ? 1 : 0) != 0);
                previousBigInt = a1.get(i);
            }
            loader.clear();
            b.release();
        }
        System.out.println(String.format("Sorted %,d records in %d batches.", recordCount, batchCount));
    }

    @Test
    public void sortOneKeyDescendingMergeSort() throws Throwable {
        List<QueryDataBatch> results = TestSimpleExternalSort.testPhysicalFromFileWithResults("xsort/one_key_sort_descending.json");
        int count = 0;
        for (QueryDataBatch b : results) {
            if (b.getHeader().getRowCount() == 0) continue;
            count += b.getHeader().getRowCount();
        }
        Assert.assertEquals((long)1000000L, (long)count);
        long previousBigInt = Long.MAX_VALUE;
        int recordCount = 0;
        int batchCount = 0;
        for (QueryDataBatch b : results) {
            if (b.getHeader().getRowCount() == 0) break;
            ++batchCount;
            RecordBatchLoader loader = new RecordBatchLoader(allocator);
            loader.load(b.getHeader().getDef(), b.getData());
            BigIntVector c1 = (BigIntVector)loader.getValueAccessorById(BigIntVector.class, loader.getValueVectorId(new SchemaPath("blue", ExpressionPosition.UNKNOWN)).getFieldIds()).getValueVector();
            BigIntVector.Accessor a1 = c1.getAccessor();
            for (int i = 0; i < c1.getAccessor().getValueCount(); ++i) {
                ++recordCount;
                Assert.assertTrue((String)String.format("%d > %d", previousBigInt, a1.get(i)), (previousBigInt >= a1.get(i) ? 1 : 0) != 0);
                previousBigInt = a1.get(i);
            }
            loader.clear();
            b.release();
        }
        System.out.println(String.format("Sorted %,d records in %d batches.", recordCount, batchCount));
    }

    @Test
    public void sortOneKeyDescendingExternalSort() throws Throwable {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        DrillConfig config = DrillConfig.create((String)"drill-external-sort.conf");
        try (Drillbit bit1 = new Drillbit(config, serviceSet);
             Drillbit bit2 = new Drillbit(config, serviceSet);
             DrillClient client = new DrillClient(config, serviceSet.getCoordinator());){
            QueryDataBatch b;
            bit1.run();
            bit2.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/xsort/one_key_sort_descending.json"), (Charset)Charsets.UTF_8));
            int count = 0;
            for (QueryDataBatch b2 : results) {
                if (b2.getHeader().getRowCount() == 0) continue;
                count += b2.getHeader().getRowCount();
            }
            Assert.assertEquals((long)1000000L, (long)count);
            long previousBigInt = Long.MAX_VALUE;
            int recordCount = 0;
            int batchCount = 0;
            Iterator i$ = results.iterator();
            while (i$.hasNext() && (b = (QueryDataBatch)i$.next()).getHeader().getRowCount() != 0) {
                ++batchCount;
                RecordBatchLoader loader = new RecordBatchLoader(bit1.getContext().getAllocator());
                loader.load(b.getHeader().getDef(), b.getData());
                BigIntVector c1 = (BigIntVector)loader.getValueAccessorById(BigIntVector.class, loader.getValueVectorId(new SchemaPath("blue", ExpressionPosition.UNKNOWN)).getFieldIds()).getValueVector();
                BigIntVector.Accessor a1 = c1.getAccessor();
                for (int i = 0; i < c1.getAccessor().getValueCount(); ++i) {
                    ++recordCount;
                    Assert.assertTrue((String)String.format("%d < %d", previousBigInt, a1.get(i)), (previousBigInt >= a1.get(i) ? 1 : 0) != 0);
                    previousBigInt = a1.get(i);
                }
                loader.clear();
                b.release();
            }
            System.out.println(String.format("Sorted %,d records in %d batches.", recordCount, batchCount));
        }
    }

    @Test
    public void outOfMemoryExternalSort() throws Throwable {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        DrillConfig config = DrillConfig.create((String)"drill-oom-xsort.conf");
        try (Drillbit bit1 = new Drillbit(config, serviceSet);
             DrillClient client = new DrillClient(config, serviceSet.getCoordinator());){
            QueryDataBatch b;
            bit1.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/xsort/oom_sort_test.json"), (Charset)Charsets.UTF_8));
            int count = 0;
            for (QueryDataBatch b2 : results) {
                if (b2.getHeader().getRowCount() == 0) continue;
                count += b2.getHeader().getRowCount();
            }
            Assert.assertEquals((long)10000000L, (long)count);
            long previousBigInt = Long.MAX_VALUE;
            int recordCount = 0;
            int batchCount = 0;
            Iterator i$ = results.iterator();
            while (i$.hasNext() && (b = (QueryDataBatch)i$.next()).getHeader().getRowCount() != 0) {
                ++batchCount;
                RecordBatchLoader loader = new RecordBatchLoader(bit1.getContext().getAllocator());
                loader.load(b.getHeader().getDef(), b.getData());
                BigIntVector c1 = (BigIntVector)loader.getValueAccessorById(BigIntVector.class, loader.getValueVectorId(new SchemaPath("blue", ExpressionPosition.UNKNOWN)).getFieldIds()).getValueVector();
                BigIntVector.Accessor a1 = c1.getAccessor();
                for (int i = 0; i < c1.getAccessor().getValueCount(); ++i) {
                    ++recordCount;
                    Assert.assertTrue((String)String.format("%d < %d", previousBigInt, a1.get(i)), (previousBigInt >= a1.get(i) ? 1 : 0) != 0);
                    previousBigInt = a1.get(i);
                }
                Assert.assertTrue((String)String.format("%d == %d", a1.get(0), a1.get(a1.getValueCount() - 1)), (a1.get(0) != a1.get(a1.getValueCount() - 1) ? 1 : 0) != 0);
                loader.clear();
                b.release();
            }
            System.out.println(String.format("Sorted %,d records in %d batches.", recordCount, batchCount));
        }
    }
}

