/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.writer;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.vector.BigIntVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWriter
extends BaseTestQuery {
    private static final Logger logger = LoggerFactory.getLogger(TestWriter.class);
    static FileSystem fs;
    static String ALTER_SESSION;

    @BeforeClass
    public static void initFs() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "local");
        fs = FileSystem.get((Configuration)conf);
    }

    @Test
    public void simpleCsv() throws Exception {
        Path path = new Path("/tmp/csvtest");
        if (fs.exists(path)) {
            fs.delete(path, true);
        }
        String plan = Files.toString((File)FileUtils.getResourceAsFile((String)"/writer/simple_csv_writer.json"), (Charset)Charsets.UTF_8);
        List<QueryDataBatch> results = TestWriter.testPhysicalWithResults(plan);
        RecordBatchLoader batchLoader = new RecordBatchLoader(TestWriter.getAllocator());
        QueryDataBatch batch = results.get(0);
        Assert.assertTrue((boolean)batchLoader.load(batch.getHeader().getDef(), batch.getData()));
        VarCharVector fragmentIdV = (VarCharVector)batchLoader.getValueAccessorById(VarCharVector.class, new int[]{0}).getValueVector();
        BigIntVector recordWrittenV = (BigIntVector)batchLoader.getValueAccessorById(BigIntVector.class, new int[]{1}).getValueVector();
        Assert.assertEquals((long)1L, (long)batchLoader.getRecordCount());
        Assert.assertEquals((Object)"0_0", (Object)fragmentIdV.getAccessor().getObject(0).toString());
        Assert.assertEquals((long)132000L, (long)recordWrittenV.getAccessor().get(0));
        Assert.assertTrue((boolean)fs.exists(path));
        FileStatus[] fileStatuses = fs.globStatus(new Path(path.toString(), "*.csv"));
        Assert.assertTrue((2 == fileStatuses.length ? 1 : 0) != 0);
        for (QueryDataBatch b : results) {
            b.release();
        }
        batchLoader.clear();
    }

    @Test
    public void simpleCTAS() throws Exception {
        String tableName = "simplectas";
        TestWriter.runSQL("Use dfs_test.tmp");
        TestWriter.runSQL(ALTER_SESSION);
        String testQuery = String.format("CREATE TABLE %s AS SELECT * FROM cp.`employee.json`", "simplectas");
        this.testCTASQueryHelper("simplectas", testQuery, 1155);
    }

    @Test
    public void complex1CTAS() throws Exception {
        String tableName = "complex1ctas";
        TestWriter.runSQL("Use dfs_test.tmp");
        TestWriter.runSQL(ALTER_SESSION);
        String testQuery = String.format("CREATE TABLE %s AS SELECT first_name, last_name, position_id FROM cp.`employee.json`", "complex1ctas");
        this.testCTASQueryHelper("complex1ctas", testQuery, 1155);
    }

    @Test
    public void complex2CTAS() throws Exception {
        String tableName = "complex1ctas";
        TestWriter.runSQL("Use dfs_test.tmp");
        TestWriter.runSQL(ALTER_SESSION);
        String testQuery = String.format("CREATE TABLE %s AS SELECT CAST(`birth_date` as Timestamp) FROM cp.`employee.json` GROUP BY birth_date", "complex1ctas");
        this.testCTASQueryHelper("complex1ctas", testQuery, 52);
    }

    @Test
    public void simpleCTASWithSchemaInTableName() throws Exception {
        String tableName = "/test/simplectas2";
        TestWriter.runSQL(ALTER_SESSION);
        String testQuery = String.format("CREATE TABLE dfs_test.tmp.`%s` AS SELECT * FROM cp.`employee.json`", "/test/simplectas2");
        this.testCTASQueryHelper("/test/simplectas2", testQuery, 1155);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void simpleParquetDecimal() throws Exception {
        try {
            String tableName = "simpleparquetdecimal";
            String testQuery = String.format("CREATE TABLE dfs_test.tmp.`%s` AS SELECT cast(salary as decimal(30,2)) * -1 as salary FROM cp.`employee.json`", "simpleparquetdecimal");
            TestWriter.test(String.format("alter session set `%s` = true", "planner.enable_decimal_data_type"));
            this.testCTASQueryHelper("simpleparquetdecimal", testQuery, 1155);
        }
        catch (Throwable throwable) {
            TestWriter.test(String.format("alter session set `%s` = false", "planner.enable_decimal_data_type"));
            throw throwable;
        }
        TestWriter.test(String.format("alter session set `%s` = false", "planner.enable_decimal_data_type"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCTASQueryHelper(String tableName, String testQuery, int expectedOutputCount) throws Exception {
        try {
            List<QueryDataBatch> results = TestWriter.testSqlWithResults(testQuery);
            RecordBatchLoader batchLoader = new RecordBatchLoader(TestWriter.getAllocator());
            int recordsWritten = 0;
            for (QueryDataBatch batch : results) {
                batchLoader.load(batch.getHeader().getDef(), batch.getData());
                if (batchLoader.getRecordCount() <= 0) continue;
                BigIntVector recordWrittenV = (BigIntVector)batchLoader.getValueAccessorById(BigIntVector.class, new int[]{1}).getValueVector();
                for (int i = 0; i < batchLoader.getRecordCount(); ++i) {
                    recordsWritten = (int)((long)recordsWritten + recordWrittenV.getAccessor().get(i));
                }
                batchLoader.clear();
                batch.release();
            }
            Assert.assertEquals((long)expectedOutputCount, (long)recordsWritten);
        }
        finally {
            try {
                Path path = new Path(TestWriter.getDfsTestTmpSchemaLocation(), tableName);
                if (fs.exists(path)) {
                    fs.delete(path, true);
                }
            }
            catch (Exception e) {
                logger.warn("Failed to delete the table [{}, {}] created as part of the test", (Object)TestWriter.getDfsTestTmpSchemaLocation(), (Object)tableName);
            }
        }
    }

    static {
        ALTER_SESSION = String.format("ALTER SESSION SET `%s` = 'csv'", "store.format");
    }
}

