/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.writer;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.exec.ExecConstants;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestParquetWriterEmptyFiles
extends BaseTestQuery {
    private static FileSystem fs;

    @BeforeClass
    public static void initFs() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "local");
        fs = FileSystem.get((Configuration)conf);
        TestParquetWriterEmptyFiles.updateTestCluster(3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteEmptyFile() throws Exception {
        String outputFile = "testparquetwriteremptyfiles_testwriteemptyfile";
        try {
            TestParquetWriterEmptyFiles.test("CREATE TABLE dfs_test.tmp.%s AS SELECT * FROM cp.`employee.json` WHERE 1=0", "testparquetwriteremptyfiles_testwriteemptyfile");
            Path path = new Path(TestParquetWriterEmptyFiles.getDfsTestTmpSchemaLocation(), "testparquetwriteremptyfiles_testwriteemptyfile");
            Assert.assertFalse((boolean)fs.exists(path));
        }
        finally {
            TestParquetWriterEmptyFiles.deleteTableIfExists("testparquetwriteremptyfiles_testwriteemptyfile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleWriters() throws Exception {
        String outputFile = "testparquetwriteremptyfiles_testmultiplewriters";
        TestParquetWriterEmptyFiles.runSQL("alter session set `planner.slice_target` = 1");
        try {
            String query = "SELECT position_id FROM cp.`employee.json` WHERE position_id IN (15, 16) GROUP BY position_id";
            TestParquetWriterEmptyFiles.test("CREATE TABLE dfs_test.tmp.%s AS %s", "testparquetwriteremptyfiles_testmultiplewriters", "SELECT position_id FROM cp.`employee.json` WHERE position_id IN (15, 16) GROUP BY position_id");
            TestParquetWriterEmptyFiles.testBuilder().unOrdered().sqlQuery("SELECT * FROM dfs_test.tmp.%s", "testparquetwriteremptyfiles_testmultiplewriters").sqlBaselineQuery("SELECT position_id FROM cp.`employee.json` WHERE position_id IN (15, 16) GROUP BY position_id").go();
        }
        finally {
            TestParquetWriterEmptyFiles.runSQL("alter session set `planner.slice_target` = 100000");
            TestParquetWriterEmptyFiles.deleteTableIfExists("testparquetwriteremptyfiles_testmultiplewriters");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteEmptyFileAfterFlush() throws Exception {
        String outputFile = "testparquetwriteremptyfiles_test_write_empty_file_after_flush";
        TestParquetWriterEmptyFiles.deleteTableIfExists("testparquetwriteremptyfiles_test_write_empty_file_after_flush");
        try {
            TestParquetWriterEmptyFiles.test("ALTER SESSION SET `store.parquet.block-size` = 19926");
            String query = "SELECT * FROM cp.`employee.json` LIMIT 100";
            TestParquetWriterEmptyFiles.test("CREATE TABLE dfs_test.tmp.%s AS %s", "testparquetwriteremptyfiles_test_write_empty_file_after_flush", "SELECT * FROM cp.`employee.json` LIMIT 100");
            TestParquetWriterEmptyFiles.testBuilder().unOrdered().sqlQuery("SELECT * FROM dfs_test.tmp.%s", "testparquetwriteremptyfiles_test_write_empty_file_after_flush").sqlBaselineQuery("SELECT * FROM cp.`employee.json` LIMIT 100").go();
        }
        catch (Throwable throwable) {
            TestParquetWriterEmptyFiles.test("ALTER SESSION SET `store.parquet.block-size` = %d", ExecConstants.PARQUET_BLOCK_SIZE_VALIDATOR.getDefault().num_val);
            TestParquetWriterEmptyFiles.deleteTableIfExists("testparquetwriteremptyfiles_test_write_empty_file_after_flush");
            throw throwable;
        }
        TestParquetWriterEmptyFiles.test("ALTER SESSION SET `store.parquet.block-size` = %d", ExecConstants.PARQUET_BLOCK_SIZE_VALIDATOR.getDefault().num_val);
        TestParquetWriterEmptyFiles.deleteTableIfExists("testparquetwriteremptyfiles_test_write_empty_file_after_flush");
    }

    private static boolean deleteTableIfExists(String tableName) {
        try {
            Path path = new Path(TestParquetWriterEmptyFiles.getDfsTestTmpSchemaLocation(), tableName);
            if (fs.exists(path)) {
                return fs.delete(path, true);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

