/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.writer;

import java.math.BigDecimal;
import java.sql.Date;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.fn.interp.TestConstantFolding;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestParquetWriter
extends BaseTestQuery {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    static FileSystem fs;

    @BeforeClass
    public static void initFs() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "local");
        fs = FileSystem.get((Configuration)conf);
        TestParquetWriter.test(String.format("alter session set `%s` = true", "planner.enable_decimal_data_type"));
    }

    @AfterClass
    public static void disableDecimalDataType() throws Exception {
        TestParquetWriter.test(String.format("alter session set `%s` = false", "planner.enable_decimal_data_type"));
    }

    @Test
    public void testSimple() throws Exception {
        String selection = "*";
        String inputTable = "cp.`employee.json`";
        this.runTestAndValidate(selection, selection, inputTable, "employee_parquet");
    }

    @Test
    public void testLargeFooter() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        int numCols = 1000;
        String[] colNames = new String[1000];
        Object[] values = new Object[1000];
        for (int i = 0; i < 999; ++i) {
            sb.append(String.format("\"col_%d\" : 100,", i));
            colNames[i] = "col_" + i;
            values[i] = 100L;
        }
        sb.append(String.format("\"col_%d\" : 100", 999));
        sb.append("}");
        colNames[999] = "col_999";
        values[999] = 100L;
        new TestConstantFolding.SmallFileCreator(this.folder).setRecord(sb.toString()).createFiles(1, 1, "json");
        String path = this.folder.getRoot().toPath().toString();
        TestParquetWriter.test("use dfs_test.tmp");
        TestParquetWriter.test("create table WIDE_PARQUET_TABLE_TestParquetWriter_testLargeFooter as select * from dfs.`" + path + "/smallfile/smallfile.json`");
        TestParquetWriter.testBuilder().sqlQuery("select * from dfs_test.tmp.WIDE_PARQUET_TABLE_TestParquetWriter_testLargeFooter").unOrdered().baselineColumns(colNames).baselineValues(values).build().run();
    }

    @Test
    public void testComplex() throws Exception {
        String selection = "*";
        String inputTable = "cp.`donuts.json`";
        this.runTestAndValidate(selection, selection, inputTable, "donuts_json");
    }

    @Test
    public void testComplexRepeated() throws Exception {
        String selection = "*";
        String inputTable = "cp.`testRepeatedWrite.json`";
        this.runTestAndValidate(selection, selection, inputTable, "repeated_json");
    }

    @Test
    public void testCastProjectBug_Drill_929() throws Exception {
        String selection = "L_ORDERKEY, L_PARTKEY, L_SUPPKEY, L_LINENUMBER, L_QUANTITY, L_EXTENDEDPRICE, L_DISCOUNT, L_TAX, L_RETURNFLAG, L_LINESTATUS, L_SHIPDATE, cast(L_COMMITDATE as DATE) as COMMITDATE, cast(L_RECEIPTDATE as DATE) AS RECEIPTDATE, L_SHIPINSTRUCT, L_SHIPMODE, L_COMMENT";
        String validationSelection = "L_ORDERKEY, L_PARTKEY, L_SUPPKEY, L_LINENUMBER, L_QUANTITY, L_EXTENDEDPRICE, L_DISCOUNT, L_TAX, L_RETURNFLAG, L_LINESTATUS, L_SHIPDATE,COMMITDATE ,RECEIPTDATE, L_SHIPINSTRUCT, L_SHIPMODE, L_COMMENT";
        String inputTable = "cp.`tpch/lineitem.parquet`";
        this.runTestAndValidate(selection, validationSelection, inputTable, "drill_929");
    }

    @Test
    public void testTPCHReadWrite1() throws Exception {
        String inputTable = "cp.`tpch/lineitem.parquet`";
        this.runTestAndValidate("*", "*", inputTable, "lineitem_parquet_all");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTPCHReadWrite1_date_convertedType() throws Exception {
        try {
            TestParquetWriter.test("alter session set `%s` = false", "store.parquet.enable_dictionary_encoding");
            String selection = "L_ORDERKEY, L_PARTKEY, L_SUPPKEY, L_LINENUMBER, L_QUANTITY, L_EXTENDEDPRICE, L_DISCOUNT, L_TAX, L_RETURNFLAG, L_LINESTATUS, L_SHIPDATE, cast(L_COMMITDATE as DATE) as L_COMMITDATE, cast(L_RECEIPTDATE as DATE) AS L_RECEIPTDATE, L_SHIPINSTRUCT, L_SHIPMODE, L_COMMENT";
            String validationSelection = "L_ORDERKEY, L_PARTKEY, L_SUPPKEY, L_LINENUMBER, L_QUANTITY, L_EXTENDEDPRICE, L_DISCOUNT, L_TAX, L_RETURNFLAG, L_LINESTATUS, L_SHIPDATE,L_COMMITDATE ,L_RECEIPTDATE, L_SHIPINSTRUCT, L_SHIPMODE, L_COMMENT";
            String inputTable = "cp.`tpch/lineitem.parquet`";
            this.runTestAndValidate(selection, validationSelection, inputTable, "lineitem_parquet_converted");
        }
        catch (Throwable throwable) {
            TestParquetWriter.test("alter session set `%s` = %b", "store.parquet.enable_dictionary_encoding", ExecConstants.PARQUET_WRITER_ENABLE_DICTIONARY_ENCODING_VALIDATOR.getDefault().bool_val);
            throw throwable;
        }
        TestParquetWriter.test("alter session set `%s` = %b", "store.parquet.enable_dictionary_encoding", ExecConstants.PARQUET_WRITER_ENABLE_DICTIONARY_ENCODING_VALIDATOR.getDefault().bool_val);
    }

    @Test
    public void testTPCHReadWrite2() throws Exception {
        String inputTable = "cp.`tpch/customer.parquet`";
        this.runTestAndValidate("*", "*", inputTable, "customer_parquet");
    }

    @Test
    public void testTPCHReadWrite3() throws Exception {
        String inputTable = "cp.`tpch/nation.parquet`";
        this.runTestAndValidate("*", "*", inputTable, "nation_parquet");
    }

    @Test
    public void testTPCHReadWrite4() throws Exception {
        String inputTable = "cp.`tpch/orders.parquet`";
        this.runTestAndValidate("*", "*", inputTable, "orders_parquet");
    }

    @Test
    public void testTPCHReadWrite5() throws Exception {
        String inputTable = "cp.`tpch/part.parquet`";
        this.runTestAndValidate("*", "*", inputTable, "part_parquet");
    }

    @Test
    public void testTPCHReadWrite6() throws Exception {
        String inputTable = "cp.`tpch/partsupp.parquet`";
        this.runTestAndValidate("*", "*", inputTable, "partsupp_parquet");
    }

    @Test
    public void testTPCHReadWrite7() throws Exception {
        String inputTable = "cp.`tpch/region.parquet`";
        this.runTestAndValidate("*", "*", inputTable, "region_parquet");
    }

    @Test
    public void testTPCHReadWrite8() throws Exception {
        String inputTable = "cp.`tpch/supplier.parquet`";
        this.runTestAndValidate("*", "*", inputTable, "supplier_parquet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTPCHReadWriteNoDictUncompressed() throws Exception {
        try {
            TestParquetWriter.test(String.format("alter session set `%s` = false", "store.parquet.enable_dictionary_encoding"));
            TestParquetWriter.test(String.format("alter session set `%s` = 'none'", "store.parquet.compression"));
            String inputTable = "cp.`tpch/supplier.parquet`";
            this.runTestAndValidate("*", "*", inputTable, "supplier_parquet_no_dict_uncompressed");
        }
        catch (Throwable throwable) {
            TestParquetWriter.test(String.format("alter session set `%s` = %b", "store.parquet.enable_dictionary_encoding", ExecConstants.PARQUET_WRITER_ENABLE_DICTIONARY_ENCODING_VALIDATOR.getDefault().bool_val));
            TestParquetWriter.test(String.format("alter session set `%s` = '%s'", "store.parquet.compression", ExecConstants.PARQUET_WRITER_COMPRESSION_TYPE_VALIDATOR.getDefault().string_val));
            throw throwable;
        }
        TestParquetWriter.test(String.format("alter session set `%s` = %b", "store.parquet.enable_dictionary_encoding", ExecConstants.PARQUET_WRITER_ENABLE_DICTIONARY_ENCODING_VALIDATOR.getDefault().bool_val));
        TestParquetWriter.test(String.format("alter session set `%s` = '%s'", "store.parquet.compression", ExecConstants.PARQUET_WRITER_COMPRESSION_TYPE_VALIDATOR.getDefault().string_val));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTPCHReadWriteDictGzip() throws Exception {
        try {
            TestParquetWriter.test(String.format("alter session set `%s` = 'gzip'", "store.parquet.compression"));
            String inputTable = "cp.`tpch/supplier.parquet`";
            this.runTestAndValidate("*", "*", inputTable, "supplier_parquet_dict_gzip");
        }
        catch (Throwable throwable) {
            TestParquetWriter.test(String.format("alter session set `%s` = '%s'", "store.parquet.compression", ExecConstants.PARQUET_WRITER_COMPRESSION_TYPE_VALIDATOR.getDefault().string_val));
            throw throwable;
        }
        TestParquetWriter.test(String.format("alter session set `%s` = '%s'", "store.parquet.compression", ExecConstants.PARQUET_WRITER_COMPRESSION_TYPE_VALIDATOR.getDefault().string_val));
    }

    @Test
    public void testRepeated() throws Exception {
        String inputTable = "cp.`parquet/basic_repeated.json`";
        this.runTestAndValidate("*", "*", inputTable, "basic_repeated");
    }

    @Test
    public void testRepeatedDouble() throws Exception {
        String inputTable = "cp.`parquet/repeated_double_data.json`";
        this.runTestAndValidate("*", "*", inputTable, "repeated_double_parquet");
    }

    @Test
    public void testRepeatedLong() throws Exception {
        String inputTable = "cp.`parquet/repeated_integer_data.json`";
        this.runTestAndValidate("*", "*", inputTable, "repeated_int_parquet");
    }

    @Test
    public void testRepeatedBool() throws Exception {
        String inputTable = "cp.`parquet/repeated_bool_data.json`";
        this.runTestAndValidate("*", "*", inputTable, "repeated_bool_parquet");
    }

    @Test
    public void testNullReadWrite() throws Exception {
        String inputTable = "cp.`parquet/null_test_data.json`";
        this.runTestAndValidate("*", "*", inputTable, "nullable_test");
    }

    @Ignore(value="Binary file too large for version control, TODO - make available on S3 bucket or similar service")
    @Test
    public void testBitError_Drill_2031() throws Exception {
        this.compareParquetReadersHyperVector("*", "dfs.`/tmp/wide2/0_0_3.parquet`");
    }

    @Test
    public void testDecimal() throws Exception {
        String selection = "cast(salary as decimal(8,2)) as decimal8, cast(salary as decimal(15,2)) as decimal15, cast(salary as decimal(24,2)) as decimal24, cast(salary as decimal(38,2)) as decimal38";
        String validateSelection = "decimal8, decimal15, decimal24, decimal38";
        String inputTable = "cp.`employee.json`";
        this.runTestAndValidate(selection, validateSelection, inputTable, "parquet_decimal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMulipleRowGroups() throws Exception {
        try {
            TestParquetWriter.test(String.format("ALTER SESSION SET `%s` = %d", "store.parquet.block-size", 0x100000));
            String selection = "mi";
            String inputTable = "cp.`customer.json`";
            this.runTestAndValidate(selection, selection, inputTable, "foodmart_customer_parquet");
        }
        catch (Throwable throwable) {
            TestParquetWriter.test(String.format("ALTER SESSION SET `%s` = %d", "store.parquet.block-size", 0x20000000));
            throw throwable;
        }
        TestParquetWriter.test(String.format("ALTER SESSION SET `%s` = %d", "store.parquet.block-size", 0x20000000));
    }

    @Test
    public void testDate() throws Exception {
        String selection = "cast(hire_date as DATE) as hire_date";
        String validateSelection = "hire_date";
        String inputTable = "cp.`employee.json`";
        this.runTestAndValidate(selection, validateSelection, inputTable, "foodmart_employee_parquet");
    }

    @Test
    public void testBoolean() throws Exception {
        String selection = "true as x, false as y";
        String validateSelection = "x, y";
        String inputTable = "cp.`tpch/region.parquet`";
        this.runTestAndValidate(selection, validateSelection, inputTable, "region_boolean_parquet");
    }

    @Test
    public void testWriterWithStarAndExp() throws Exception {
        String selection = " *, r_regionkey + 1 r_regionkey2";
        String validateSelection = "r_regionkey, r_name, r_comment, r_regionkey + 1 r_regionkey2";
        String inputTable = "cp.`tpch/region.parquet`";
        this.runTestAndValidate(selection, validateSelection, inputTable, "region_star_exp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriterWithStarAndRegluarCol() throws Exception {
        String outputFile = "region_sort";
        String ctasStmt = "create table " + outputFile + " as select *, r_regionkey + 1 as key1 from cp.`tpch/region.parquet` order by r_name";
        String query = "select r_regionkey, r_name, r_comment, r_regionkey +1 as key1 from cp.`tpch/region.parquet` order by r_name";
        String queryFromWriteOut = "select * from " + outputFile;
        try {
            TestParquetWriter.test("use dfs_test.tmp");
            TestParquetWriter.test(ctasStmt);
            TestParquetWriter.testBuilder().ordered().sqlQuery(queryFromWriteOut).sqlBaselineQuery(query).build().run();
        }
        finally {
            TestParquetWriter.deleteTableIfExists(outputFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compareParquetReadersColumnar(String selection, String table) throws Exception {
        String query = "select " + selection + " from " + table;
        try {
            TestParquetWriter.testBuilder().ordered().sqlQuery(query).optionSettingQueriesForTestQuery("alter system set `store.parquet.use_new_reader` = false").sqlBaselineQuery(query).optionSettingQueriesForBaseline("alter system set `store.parquet.use_new_reader` = true").build().run();
        }
        catch (Throwable throwable) {
            TestParquetWriter.test("alter system set `%s` = %b", "store.parquet.use_new_reader", ExecConstants.PARQUET_RECORD_READER_IMPLEMENTATION_VALIDATOR.getDefault().bool_val);
            throw throwable;
        }
        TestParquetWriter.test("alter system set `%s` = %b", "store.parquet.use_new_reader", ExecConstants.PARQUET_RECORD_READER_IMPLEMENTATION_VALIDATOR.getDefault().bool_val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compareParquetReadersHyperVector(String selection, String table) throws Exception {
        String query = "select " + selection + " from " + table;
        try {
            TestParquetWriter.testBuilder().ordered().highPerformanceComparison().sqlQuery(query).optionSettingQueriesForTestQuery("alter system set `store.parquet.use_new_reader` = false").sqlBaselineQuery(query).optionSettingQueriesForBaseline("alter system set `store.parquet.use_new_reader` = true").build().run();
        }
        catch (Throwable throwable) {
            TestParquetWriter.test("alter system set `%s` = %b", "store.parquet.use_new_reader", ExecConstants.PARQUET_RECORD_READER_IMPLEMENTATION_VALIDATOR.getDefault().bool_val);
            throw throwable;
        }
        TestParquetWriter.test("alter system set `%s` = %b", "store.parquet.use_new_reader", ExecConstants.PARQUET_RECORD_READER_IMPLEMENTATION_VALIDATOR.getDefault().bool_val);
    }

    @Ignore
    @Test
    public void testReadVoter() throws Exception {
        this.compareParquetReadersHyperVector("*", "dfs.`/tmp/voter.parquet`");
    }

    @Ignore
    @Test
    public void testReadSf_100_supplier() throws Exception {
        this.compareParquetReadersHyperVector("*", "dfs.`/tmp/sf100_supplier.parquet`");
    }

    @Ignore
    @Test
    public void testParquetRead_checkNulls_NullsFirst() throws Exception {
        this.compareParquetReadersColumnar("*", "dfs.`/tmp/parquet_with_nulls_should_sum_100000_nulls_first.parquet`");
    }

    @Ignore
    @Test
    public void testParquetRead_checkNulls() throws Exception {
        this.compareParquetReadersColumnar("*", "dfs.`/tmp/parquet_with_nulls_should_sum_100000.parquet`");
    }

    @Ignore
    @Test
    public void test958_sql() throws Exception {
        this.compareParquetReadersHyperVector("ss_ext_sales_price", "dfs.`/tmp/store_sales`");
    }

    @Ignore
    @Test
    public void testReadSf_1_supplier() throws Exception {
        this.compareParquetReadersHyperVector("*", "dfs.`/tmp/orders_part-m-00001.parquet`");
    }

    @Ignore
    @Test
    public void test958_sql_all_columns() throws Exception {
        this.compareParquetReadersHyperVector("*", "dfs.`/tmp/store_sales`");
        this.compareParquetReadersHyperVector("ss_addr_sk, ss_hdemo_sk", "dfs.`/tmp/store_sales`");
    }

    @Ignore
    @Test
    public void testDrill_1314() throws Exception {
        this.compareParquetReadersColumnar("l_partkey ", "dfs.`/tmp/drill_1314.parquet`");
    }

    @Ignore
    @Test
    public void testDrill_1314_all_columns() throws Exception {
        this.compareParquetReadersHyperVector("*", "dfs.`/tmp/drill_1314.parquet`");
        this.compareParquetReadersColumnar("l_orderkey,l_partkey,l_suppkey,l_linenumber, l_quantity, l_extendedprice,l_discount,l_tax", "dfs.`/tmp/drill_1314.parquet`");
    }

    @Ignore
    @Test
    public void testParquetRead_checkShortNullLists() throws Exception {
        this.compareParquetReadersColumnar("*", "dfs.`/tmp/short_null_lists.parquet`");
    }

    @Ignore
    @Test
    public void testParquetRead_checkStartWithNull() throws Exception {
        this.compareParquetReadersColumnar("*", "dfs.`/tmp/start_with_null.parquet`");
    }

    @Ignore
    @Test
    public void testParquetReadWebReturns() throws Exception {
        this.compareParquetReadersColumnar("wr_returning_customer_sk", "dfs.`/tmp/web_returns`");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteDecimal() throws Exception {
        String outputTable = "decimal_test";
        try {
            String ctas = String.format("use dfs_test.tmp; create table %s as select cast('1.2' as decimal(38, 2)) col1, cast('1.2' as decimal(28, 2)) col2 from cp.`employee.json` limit 1", outputTable);
            TestParquetWriter.test(ctas);
            BigDecimal result = new BigDecimal("1.20");
            TestParquetWriter.testBuilder().unOrdered().sqlQuery(String.format("select col1, col2 from %s ", outputTable)).baselineColumns("col1", "col2").baselineValues(result, result).go();
        }
        finally {
            TestParquetWriter.deleteTableIfExists(outputTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void tableSchemaWhenSelectFieldsInDef_SelectFieldsInView() throws Exception {
        String newTblName = "testTableOutputSchema";
        try {
            String ctas = String.format("CREATE TABLE dfs_test.tmp.%s(id, name, bday) AS SELECT cast(`employee_id` as integer), cast(`full_name` as varchar(100)), cast(`birth_date` as date) FROM cp.`employee.json` ORDER BY `employee_id` LIMIT 1", "testTableOutputSchema");
            TestParquetWriter.test(ctas);
            TestParquetWriter.testBuilder().unOrdered().sqlQuery(String.format("SELECT * FROM dfs_test.tmp.`%s`", "testTableOutputSchema")).baselineColumns("id", "name", "bday").baselineValues(1, "Sheri Nowmer", new DateTime(Date.valueOf("1961-08-26").getTime())).go();
        }
        finally {
            TestParquetWriter.deleteTableIfExists("testTableOutputSchema");
        }
    }

    @Test
    public void testCTASWithIntervalTypes() throws Exception {
        TestParquetWriter.test("use dfs_test.tmp");
        String tableName = "drill_1980_t1";
        TestParquetWriter.test(String.format("create table %s as select interval '10 20:30:40.123' day to second col1, interval '-1000000000 20:12:23.999' day(10) to second col2 from cp.`employee.json` limit 2", tableName));
        Period row1Col1 = new Period(0, 0, 0, 10, 0, 0, 0, 73840123);
        Period row1Col2 = new Period(0, 0, 0, -1000000000, 0, 0, 0, -72743999);
        this.testParquetReaderHelper(tableName, row1Col1, row1Col2, row1Col1, row1Col2);
        tableName = "drill_1980_2";
        TestParquetWriter.test(String.format("create table %s as select interval '10-2' year to month col1, interval '-100-8' year(3) to month col2 from cp.`employee.json` limit 2", tableName));
        row1Col1 = new Period(0, 122, 0, 0, 0, 0, 0, 0);
        row1Col2 = new Period(0, -1208, 0, 0, 0, 0, 0, 0);
        this.testParquetReaderHelper(tableName, row1Col1, row1Col2, row1Col1, row1Col2);
        tableName = "drill_1980_t3";
        TestParquetWriter.test(String.format("create table %s as select cast (intervalyear_col as interval year) col1,cast(intervalyear_col as interval year) + interval '2' year col2 from cp.`parquet/alltypes.json` where tinyint_col = 1 or tinyint_col = 2", tableName));
        row1Col1 = new Period(0, 12, 0, 0, 0, 0, 0, 0);
        row1Col2 = new Period(0, 36, 0, 0, 0, 0, 0, 0);
        Period row2Col1 = new Period(0, 24, 0, 0, 0, 0, 0, 0);
        Period row2Col2 = new Period(0, 48, 0, 0, 0, 0, 0, 0);
        this.testParquetReaderHelper(tableName, row1Col1, row1Col2, row2Col1, row2Col2);
        tableName = "drill_1980_t4";
        TestParquetWriter.test(String.format("create table %s as select cast(intervalday_col as interval day) col1, cast(intervalday_col as interval day) + interval '1' day col2 from cp.`parquet/alltypes.json` where tinyint_col = 1 or tinyint_col = 2", tableName));
        row1Col1 = new Period(0, 0, 0, 1, 0, 0, 0, 0);
        row1Col2 = new Period(0, 0, 0, 2, 0, 0, 0, 0);
        row2Col1 = new Period(0, 0, 0, 2, 0, 0, 0, 0);
        row2Col2 = new Period(0, 0, 0, 3, 0, 0, 0, 0);
        this.testParquetReaderHelper(tableName, row1Col1, row1Col2, row2Col1, row2Col2);
    }

    private void testParquetReaderHelper(String tableName, Period row1Col1, Period row1Col2, Period row2Col1, Period row2Col2) throws Exception {
        String switchReader = "alter session set `store.parquet.use_new_reader` = %s; ";
        String enableVectorizedReader = String.format("alter session set `store.parquet.use_new_reader` = %s; ", true);
        String disableVectorizedReader = String.format("alter session set `store.parquet.use_new_reader` = %s; ", false);
        String query = String.format("select * from %s", tableName);
        TestParquetWriter.testBuilder().sqlQuery(query).unOrdered().optionSettingQueriesForTestQuery(enableVectorizedReader).baselineColumns("col1", "col2").baselineValues(row1Col1, row1Col2).baselineValues(row2Col1, row2Col2).go();
        TestParquetWriter.testBuilder().sqlQuery(query).unOrdered().optionSettingQueriesForTestQuery(disableVectorizedReader).baselineColumns("col1", "col2").baselineValues(row1Col1, row1Col2).baselineValues(row2Col1, row2Col2).go();
    }

    private static void deleteTableIfExists(String tableName) {
        try {
            Path path = new Path(TestParquetWriter.getDfsTestTmpSchemaLocation(), tableName);
            if (fs.exists(path)) {
                fs.delete(path, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestAndValidate(String selection, String validationSelection, String inputTable, String outputFile) throws Exception {
        try {
            TestParquetWriter.test("use dfs_test.tmp");
            String query = String.format("SELECT %s FROM %s", selection, inputTable);
            String create = "CREATE TABLE " + outputFile + " AS " + query;
            String validateQuery = String.format("SELECT %s FROM " + outputFile, validationSelection);
            TestParquetWriter.test(create);
            TestParquetWriter.testBuilder().unOrdered().sqlQuery(query).sqlBaselineQuery(validateQuery).go();
        }
        finally {
            TestParquetWriter.deleteTableIfExists(outputFile);
        }
    }

    @Test
    public void testImpalaParquetInt96() throws Exception {
        this.compareParquetReadersColumnar("field_impala_ts", "cp.`parquet/int96_impala_1.parquet`");
    }

    @Test
    public void testImpalaParquetVarBinary_DictChange() throws Exception {
        this.compareParquetReadersColumnar("field_impala_ts", "cp.`parquet/int96_dict_change.parquet`");
    }

    @Test
    public void testImpalaParquetTimestampAsInt96() throws Exception {
        this.compareParquetReadersColumnar("convert_from(field_impala_ts, 'TIMESTAMP_IMPALA')", "cp.`parquet/int96_impala_1.parquet`");
    }

    @Test
    public void testImpalaParquetInt96Partitioned() throws Exception {
        this.compareParquetReadersColumnar("timestamp_field", "cp.`parquet/part1/hive_all_types.parquet`");
    }

    @Test
    public void testHiveParquetTimestampAsInt96_compare() throws Exception {
        this.compareParquetReadersColumnar("convert_from(timestamp_field, 'TIMESTAMP_IMPALA')", "cp.`parquet/part1/hive_all_types.parquet`");
    }

    @Test
    @Ignore(value="relies on particular time zone")
    public void testHiveParquetTimestampAsInt96_basic() throws Exception {
        String q = "SELECT cast(convert_from(timestamp_field, 'TIMESTAMP_IMPALA') as varchar(19))  as timestamp_field from cp.`parquet/part1/hive_all_types.parquet` ";
        TestParquetWriter.testBuilder().unOrdered().sqlQuery("SELECT cast(convert_from(timestamp_field, 'TIMESTAMP_IMPALA') as varchar(19))  as timestamp_field from cp.`parquet/part1/hive_all_types.parquet` ").baselineColumns("timestamp_field").baselineValues("2013-07-05 17:01:00").baselineValues(new Object[]{null}).go();
    }
}

