/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.window;

import java.util.Properties;
import org.apache.drill.BaseTestQuery;
import org.apache.drill.DrillTestWrapper;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.UserRemoteException;
import org.apache.drill.common.util.TestTools;
import org.apache.drill.exec.physical.impl.window.Partition;
import org.apache.drill.exec.proto.UserBitShared;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestWindowFrame
extends BaseTestQuery {
    private static final String TEST_RES_PATH = TestTools.getWorkingPath() + "/src/test/resources";

    @BeforeClass
    public static void setupMSortBatchSize() {
        Properties props = TestWindowFrame.cloneDefaultTestConfigProperties();
        props.put("drill.exec.sort.external.msort.batch.maxsize", Integer.toString(20));
        TestWindowFrame.updateTestCluster(1, DrillConfig.create((Properties)props));
    }

    private DrillTestWrapper buildWindowQuery(String tableName, boolean withPartitionBy, int numBatches) throws Exception {
        return TestWindowFrame.testBuilder().sqlQuery(String.format(TestWindowFrame.getFile("window/q1.sql"), TEST_RES_PATH, tableName, withPartitionBy ? "(partition by position_id)" : "()")).ordered().csvBaselineFile("window/" + tableName + (withPartitionBy ? ".pby" : "") + ".tsv").baselineColumns("count", "sum").expectsNumBatches(numBatches).build();
    }

    private DrillTestWrapper buildWindowWithOrderByQuery(String tableName, boolean withPartitionBy, int numBatches) throws Exception {
        return TestWindowFrame.testBuilder().sqlQuery(String.format(TestWindowFrame.getFile("window/q2.sql"), TEST_RES_PATH, tableName, withPartitionBy ? "(partition by position_id order by sub)" : "(order by sub)")).ordered().csvBaselineFile("window/" + tableName + (withPartitionBy ? ".pby" : "") + ".oby.tsv").baselineColumns("count", "sum", "row_number", "rank", "dense_rank", "cume_dist", "percent_rank").expectsNumBatches(numBatches).build();
    }

    private void runTest(String tableName, boolean withPartitionBy, boolean withOrderBy, int numBatches) throws Exception {
        DrillTestWrapper testWrapper = withOrderBy ? this.buildWindowWithOrderByQuery(tableName, withPartitionBy, numBatches) : this.buildWindowQuery(tableName, withPartitionBy, numBatches);
        testWrapper.run();
    }

    private void runTest(String tableName, int numBatches) throws Exception {
        this.runTest(tableName, true, true, numBatches + 1);
        this.runTest(tableName, true, false, numBatches + 1);
        this.runTest(tableName, false, true, numBatches + 1);
        this.runTest(tableName, false, false, numBatches + 1);
    }

    @Test
    public void testB1P1() throws Exception {
        this.runTest("b1.p1", 1);
    }

    @Test
    public void testB1P2() throws Exception {
        this.runTest("b1.p2", 1);
    }

    @Test
    public void testB2P2() throws Exception {
        this.runTest("b2.p2", 2);
    }

    @Test
    public void testB2P4() throws Exception {
        this.runTest("b2.p4", 2);
    }

    @Test
    public void testB3P2() throws Exception {
        this.runTest("b3.p2", 3);
    }

    @Test
    public void testB4P4() throws Exception {
        this.runTest("b4.p4", 4);
    }

    @Test
    public void testEmptyPartitionBy() throws Exception {
        TestWindowFrame.test("SELECT employee_id, position_id, salary, SUM(salary) OVER(ORDER BY position_id) FROM cp.`employee.json` LIMIT 10");
    }

    @Test
    public void testEmptyOverClause() throws Exception {
        TestWindowFrame.test("SELECT employee_id, position_id, salary, SUM(salary) OVER() FROM cp.`employee.json` LIMIT 10");
    }

    @Test
    public void testMaxVarChar() throws Exception {
        TestWindowFrame.test(TestWindowFrame.getFile("window/q3218.sql"), TEST_RES_PATH);
    }

    @Test
    public void testCountConst() throws Exception {
        TestWindowFrame.test(TestWindowFrame.getFile("window/q3220.sql"), TEST_RES_PATH);
    }

    @Test
    public void testFix3604() throws Exception {
        TestWindowFrame.test(TestWindowFrame.getFile("window/3604.sql"), TEST_RES_PATH);
    }

    @Test
    public void testFix3605() throws Exception {
        TestWindowFrame.testBuilder().sqlQuery(TestWindowFrame.getFile("window/3605.sql"), TEST_RES_PATH).ordered().csvBaselineFile("window/3605.tsv").baselineColumns("col2", "lead_col2").build().run();
    }

    @Test
    public void testFix3606() throws Exception {
        TestWindowFrame.testBuilder().sqlQuery(TestWindowFrame.getFile("window/3606.sql"), TEST_RES_PATH).ordered().csvBaselineFile("window/3606.tsv").baselineColumns("col2", "lead_col2").build().run();
    }

    @Test
    public void testLead() throws Exception {
        TestWindowFrame.testBuilder().sqlQuery(TestWindowFrame.getFile("window/lead.oby.sql"), TEST_RES_PATH).ordered().csvBaselineFile("window/b4.p4.lead.oby.tsv").baselineColumns("lead").build().run();
    }

    @Test
    public void testLagWithPby() throws Exception {
        TestWindowFrame.testBuilder().sqlQuery(TestWindowFrame.getFile("window/lag.pby.oby.sql"), TEST_RES_PATH).ordered().csvBaselineFile("window/b4.p4.lag.pby.oby.tsv").baselineColumns("lag").build().run();
    }

    @Test
    public void testLag() throws Exception {
        TestWindowFrame.testBuilder().sqlQuery(TestWindowFrame.getFile("window/lag.oby.sql"), TEST_RES_PATH).ordered().csvBaselineFile("window/b4.p4.lag.oby.tsv").baselineColumns("lag").build().run();
    }

    @Test
    public void testLeadWithPby() throws Exception {
        TestWindowFrame.testBuilder().sqlQuery(TestWindowFrame.getFile("window/lead.pby.oby.sql"), TEST_RES_PATH).ordered().csvBaselineFile("window/b4.p4.lead.pby.oby.tsv").baselineColumns("lead").build().run();
    }

    @Test
    public void testFirstValue() throws Exception {
        TestWindowFrame.testBuilder().sqlQuery(TestWindowFrame.getFile("window/fval.pby.sql"), TEST_RES_PATH).ordered().csvBaselineFile("window/b4.p4.fval.pby.tsv").baselineColumns("first_value").build().run();
    }

    @Test
    public void testLastValue() throws Exception {
        TestWindowFrame.testBuilder().sqlQuery(TestWindowFrame.getFile("window/lval.pby.oby.sql"), TEST_RES_PATH).ordered().csvBaselineFile("window/b4.p4.lval.pby.oby.tsv").baselineColumns("last_value").build().run();
    }

    @Test
    public void testFirstValueAllTypes() throws Exception {
        TestWindowFrame.test(TestWindowFrame.getFile("window/fval.alltypes.sql"), TEST_RES_PATH);
    }

    @Test
    public void testLastValueAllTypes() throws Exception {
        TestWindowFrame.test(TestWindowFrame.getFile("window/fval.alltypes.sql"), TEST_RES_PATH);
    }

    @Test
    public void testNtile() throws Exception {
        TestWindowFrame.testBuilder().sqlQuery(TestWindowFrame.getFile("window/ntile.sql"), TEST_RES_PATH).ordered().csvBaselineFile("window/b2.p4.ntile.tsv").baselineColumns("ntile").build().run();
    }

    @Test
    public void test3648Fix() throws Exception {
        TestWindowFrame.testBuilder().sqlQuery(TestWindowFrame.getFile("window/3648.sql"), TEST_RES_PATH).ordered().csvBaselineFile("window/3648.tsv").baselineColumns("ntile").build().run();
    }

    @Test
    public void test3654Fix() throws Exception {
        TestWindowFrame.test("SELECT FIRST_VALUE(col8) OVER(PARTITION BY col7 ORDER BY col8) FROM dfs_test.`%s/window/3648.parquet`", TEST_RES_PATH);
    }

    @Test
    public void test3643Fix() throws Exception {
        try {
            TestWindowFrame.test("SELECT NTILE(0) OVER(PARTITION BY col7 ORDER BY col8) FROM dfs_test.`%s/window/3648.parquet`", TEST_RES_PATH);
            Assert.fail((String)"Query should have failed");
        }
        catch (UserRemoteException e) {
            Assert.assertEquals((Object)UserBitShared.DrillPBError.ErrorType.FUNCTION, (Object)e.getErrorType());
        }
    }

    @Test
    public void test3668Fix() throws Exception {
        TestWindowFrame.testBuilder().sqlQuery(TestWindowFrame.getFile("window/3668.sql"), TEST_RES_PATH).ordered().baselineColumns("cnt").baselineValues(2L).build().run();
    }

    @Test
    public void testLeadParams() throws Exception {
        String query = "SELECT %s OVER(PARTITION BY col7 ORDER BY col8) FROM dfs_test.`%s/window/3648.parquet`";
        TestWindowFrame.test("SELECT %s OVER(PARTITION BY col7 ORDER BY col8) FROM dfs_test.`%s/window/3648.parquet`", "LEAD(col8, 1)", TEST_RES_PATH);
        TestWindowFrame.test("SELECT %s OVER(PARTITION BY col7 ORDER BY col8) FROM dfs_test.`%s/window/3648.parquet`", "LAG(col8, 1)", TEST_RES_PATH);
        try {
            TestWindowFrame.test("SELECT %s OVER(PARTITION BY col7 ORDER BY col8) FROM dfs_test.`%s/window/3648.parquet`", "LEAD(col8, 2)", TEST_RES_PATH);
            Assert.fail((String)"query should fail");
        }
        catch (UserRemoteException e) {
            Assert.assertEquals((Object)UserBitShared.DrillPBError.ErrorType.UNSUPPORTED_OPERATION, (Object)e.getErrorType());
        }
        try {
            TestWindowFrame.test("SELECT %s OVER(PARTITION BY col7 ORDER BY col8) FROM dfs_test.`%s/window/3648.parquet`", "LAG(col8, 2)", TEST_RES_PATH);
            Assert.fail((String)"query should fail");
        }
        catch (UserRemoteException e) {
            Assert.assertEquals((Object)UserBitShared.DrillPBError.ErrorType.UNSUPPORTED_OPERATION, (Object)e.getErrorType());
        }
    }

    @Test
    public void testPartitionNtile() {
        Partition partition = new Partition(12L);
        Assert.assertEquals((long)1L, (long)partition.ntile(5));
        partition.rowAggregated();
        Assert.assertEquals((long)1L, (long)partition.ntile(5));
        partition.rowAggregated();
        Assert.assertEquals((long)1L, (long)partition.ntile(5));
        partition.rowAggregated();
        Assert.assertEquals((long)2L, (long)partition.ntile(5));
        partition.rowAggregated();
        Assert.assertEquals((long)2L, (long)partition.ntile(5));
        partition.rowAggregated();
        Assert.assertEquals((long)2L, (long)partition.ntile(5));
        partition.rowAggregated();
        Assert.assertEquals((long)3L, (long)partition.ntile(5));
        partition.rowAggregated();
        Assert.assertEquals((long)3L, (long)partition.ntile(5));
        partition.rowAggregated();
        Assert.assertEquals((long)4L, (long)partition.ntile(5));
        partition.rowAggregated();
        Assert.assertEquals((long)4L, (long)partition.ntile(5));
        partition.rowAggregated();
        Assert.assertEquals((long)5L, (long)partition.ntile(5));
        partition.rowAggregated();
        Assert.assertEquals((long)5L, (long)partition.ntile(5));
    }
}

