/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.window;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.common.util.TestTools;

public class GenerateTestData {
    private static final int BATCH_SIZE = 20;

    private static Partition[] dataB1P1() {
        return new Builder().partition(20).sub(1).sub(2).sub(3).sub(4).sub(5).sub(6).build();
    }

    private static Partition[] dataB1P2(boolean pby) {
        if (pby) {
            return new Builder().partition(10).sub(1).sub(2).sub(3).sub(4).partition(10).sub(4).sub(5).sub(6).build();
        }
        return new Builder().partition(20).sub(1).sub(2).sub(3).sub(4, 8).sub(5).sub(6).build();
    }

    private static Partition[] dataB2P2(boolean pby) {
        if (pby) {
            return new Builder().partition(20).sub(3).sub(5).sub(9).partition(20).sub(9).sub(10).build();
        }
        return new Builder().partition(40).sub(3).sub(5).sub(9, 21).sub(10).build();
    }

    private static Partition[] dataB2P4(boolean pby) {
        if (pby) {
            return new Builder().partition(5).sub(1).sub(2).sub(3).partition(10).sub(3).sub(4).sub(5).partition(15).sub(5).sub(6).sub(7).partition(10).sub(7).sub(8).build();
        }
        return new Builder().partition(40).sub(1).sub(2).sub(3, 5).sub(4).sub(5, 8).sub(6).sub(7, 11).sub(8).build();
    }

    private static Partition[] dataB3P2(boolean pby) {
        if (pby) {
            return new Builder().partition(5).sub(1).sub(2).sub(3).partition(55).sub(4).sub(5).sub(7).sub(8).sub(9).sub(10).sub(11).sub(12).build();
        }
        return new Builder().partition(60).sub(1).sub(2).sub(3, 2).sub(4).sub(5).sub(7).sub(8).sub(9).sub(10).sub(11).sub(12).build();
    }

    private static Partition[] dataB4P4(boolean pby) {
        if (pby) {
            return new Builder().partition(10).sub(1).sub(2).sub(3).partition(30).sub(3).sub(4).sub(5).sub(6).sub(7).sub(8).partition(20).sub(8).sub(9).sub(10).partition(20).sub(10).sub(11).build();
        }
        return new Builder().partition(80).sub(1).sub(2).sub(3, 10).sub(4).sub(5).sub(6).sub(7).sub(8, 13).sub(9).sub(10, 13).sub(11, 10).build();
    }

    private static void writeData(String path, Partition[] partitions, boolean addLineNo) throws FileNotFoundException {
        int total = partitions[partitions.length - 1].cumulLength();
        ArrayList<Integer> emp_ids = new ArrayList<Integer>(total);
        for (int i = 0; i < total; ++i) {
            emp_ids.add(i);
        }
        Collections.shuffle(emp_ids);
        int fileId = 0;
        PrintStream dataStream = new PrintStream(path + "/" + fileId + ".data.json");
        int emp_idx = 0;
        int lineNo = 0;
        Iterator i$ = emp_ids.iterator();
        while (i$.hasNext()) {
            int id = (Integer)i$.next();
            int p = 0;
            while (!partitions[p].isPartOf(id)) {
                ++p;
            }
            int sub = partitions[p].getSubId(id);
            int salary = 10 + sub;
            if (addLineNo) {
                dataStream.printf("{ \"employee_id\":%d, \"position_id\":%d, \"sub\":%d, \"salary\":%d, \"line_no\":%d }%n", id, p + 1, sub, salary, lineNo);
            } else {
                dataStream.printf("{ \"employee_id\":%d, \"position_id\":%d, \"sub\":%d, \"salary\":%d }%n", id, p + 1, sub, salary);
            }
            if (++emp_idx % 20 == 0 && emp_idx < total) {
                System.out.printf("total: %d, emp_idx: %d, fileID: %d%n", total, emp_idx, fileId);
                dataStream.close();
                dataStream = new PrintStream(path + "/" + ++fileId + ".data.json");
            }
            ++lineNo;
        }
        dataStream.close();
    }

    private static void writeResults(String path, String prefix, Partition[] partitions) throws FileNotFoundException {
        PrintStream resultStream = new PrintStream(path + prefix + ".tsv");
        PrintStream resultOrderStream = new PrintStream(path + prefix + ".oby.tsv");
        int idx = 0;
        for (Partition partition : partitions) {
            int i = 0;
            while (i < partition.length) {
                int sub = partition.getSubId(idx);
                int rowNumber = i + 1;
                int rank = 1 + partition.subRunningCount(sub) - partition.getSubSize(sub);
                int denseRank = partition.getSubIndex(sub) + 1;
                double cumeDist = (double)partition.subRunningCount(sub) / (double)partition.length;
                double percentRank = partition.length == 1 ? 0.0 : (double)(rank - 1) / (double)(partition.length - 1);
                resultOrderStream.printf("%d\t%d\t%d\t%d\t%d\t%s\t%s%n", partition.subRunningCount(sub), partition.subRunningSum(sub), rowNumber, rank, denseRank, Double.toString(cumeDist), Double.toString(percentRank));
                resultStream.printf("%d\t%d%n", partition.length, partition.totalSalary());
                ++i;
                ++idx;
            }
        }
        resultStream.close();
        resultOrderStream.close();
    }

    private static void generateData(String tableName, Partition[] pby_data, Partition[] nopby_data) throws FileNotFoundException {
        GenerateTestData.generateData(tableName, pby_data, nopby_data, false);
    }

    private static void generateData(String tableName, Partition[] pby_data, Partition[] nopby_data, boolean addLineNo) throws FileNotFoundException {
        String WORKING_PATH = TestTools.getWorkingPath();
        String TEST_RES_PATH = WORKING_PATH + "/src/test/resources";
        String path = TEST_RES_PATH + "/window/" + tableName;
        File pathFolder = new File(path);
        if (!pathFolder.exists() && !pathFolder.mkdirs()) {
            System.err.printf("Couldn't create folder %s, exiting%n", path);
        }
        GenerateTestData.writeData(path, pby_data, addLineNo);
        GenerateTestData.writeResults(path, "", nopby_data);
        GenerateTestData.writeResults(path, ".pby", pby_data);
    }

    public static void main(String[] args) throws FileNotFoundException {
        GenerateTestData.generateData("b1.p1", GenerateTestData.dataB1P1(), GenerateTestData.dataB1P1());
        GenerateTestData.generateData("b1.p2", GenerateTestData.dataB1P2(true), GenerateTestData.dataB1P2(false));
        GenerateTestData.generateData("b2.p2", GenerateTestData.dataB2P2(true), GenerateTestData.dataB2P2(false));
        GenerateTestData.generateData("b2.p4", GenerateTestData.dataB2P4(true), GenerateTestData.dataB2P4(false));
        GenerateTestData.generateData("b3.p2", GenerateTestData.dataB3P2(true), GenerateTestData.dataB3P2(false));
        GenerateTestData.generateData("b4.p4", GenerateTestData.dataB4P4(true), GenerateTestData.dataB4P4(false), true);
    }

    private static class Partition {
        Partition previous;
        final int length;
        final Integer[] subs;
        final Integer[] subs_sizes;

        public Partition(int length, Integer[] subs, Integer[] sub_sizes) {
            this.length = length;
            this.subs = subs;
            this.subs_sizes = sub_sizes;
        }

        public int cumulLength() {
            int prevLength = this.previous != null ? this.previous.cumulLength() : 0;
            return this.length + prevLength;
        }

        public boolean isPartOf(int rowNumber) {
            int prevLength = this.previous != null ? this.previous.cumulLength() : 0;
            return rowNumber >= prevLength && rowNumber < this.cumulLength();
        }

        public int getSubIndex(int sub) {
            return Arrays.binarySearch((Object[])this.subs, (Object)sub);
        }

        public int getSubSize(int sub) {
            if (sub != this.subs[this.subs.length - 1]) {
                return this.subs_sizes[this.getSubIndex(sub)];
            }
            int size = this.length;
            for (int i = 0; i < this.subs.length - 1; ++i) {
                size -= this.subs_sizes[i].intValue();
            }
            return size;
        }

        public int getSubId(int rowNumber) {
            assert (this.isPartOf(rowNumber)) : "row " + rowNumber + " isn't part of this partition";
            int prevLength = this.previous != null ? this.previous.cumulLength() : 0;
            rowNumber -= prevLength;
            Integer[] arr$ = this.subs;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int s = arr$[i$];
                if (rowNumber >= this.subRunningCount(s)) continue;
                return s;
            }
            throw new RuntimeException("should never happen!");
        }

        public int subRunningCount(int sub) {
            int count = 0;
            Integer[] arr$ = this.subs;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int s = arr$[i$];
                count += this.getSubSize(s);
                if (s == sub) break;
            }
            return count;
        }

        public int subRunningSum(int sub) {
            int sum = 0;
            Integer[] arr$ = this.subs;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int s = arr$[i$];
                sum += (s + 10) * this.getSubSize(s);
                if (s == sub) break;
            }
            return sum;
        }

        public int totalSalary() {
            return this.subRunningSum(this.subs[this.subs.length - 1]);
        }
    }

    private static class Builder {
        List<Partition> partitions = new ArrayList<Partition>();
        int cur_length;
        List<Integer> cur_subs = new ArrayList<Integer>();
        List<Integer> cur_subs_size = new ArrayList<Integer>();

        private Builder() {
        }

        Builder partition(int length) {
            if (this.cur_length > 0) {
                this.addPartition();
            }
            this.cur_length = length;
            this.cur_subs.clear();
            this.cur_subs_size.clear();
            return this;
        }

        Builder sub(int subId) {
            return this.sub(subId, subId);
        }

        Builder sub(int subId, int num) {
            this.cur_subs.add(subId);
            this.cur_subs_size.add(num);
            return this;
        }

        void addPartition() {
            this.partitions.add(new Partition(this.cur_length, this.cur_subs.toArray(new Integer[this.cur_subs.size()]), this.cur_subs_size.toArray(new Integer[this.cur_subs_size.size()])));
        }

        Partition[] build() {
            if (this.cur_length > 0) {
                this.addPartition();
            }
            for (int i = 1; i < this.partitions.size(); ++i) {
                this.partitions.get((int)i).previous = this.partitions.get(i - 1);
            }
            return this.partitions.toArray(new Partition[this.partitions.size()]);
        }
    }
}

