/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.sort;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import mockit.Injectable;
import mockit.NonStrictExpectations;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.compile.CodeCompiler;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.impl.ImplCreator;
import org.apache.drill.exec.physical.impl.OperatorCreatorRegistry;
import org.apache.drill.exec.physical.impl.SimpleRootExec;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.vector.BigIntVector;
import org.apache.drill.exec.vector.IntVector;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class TestSimpleSort
extends ExecTest {
    private final DrillConfig c = DrillConfig.create();

    @Test
    public void sortOneKeyAscending(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)TestSimpleSort.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestSimpleSort.this.c);
                bitContext.getConfig();
                result = TestSimpleSort.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestSimpleSort.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)"/sort/one_key_sort.json"), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        int previousInt = Integer.MIN_VALUE;
        int recordCount = 0;
        int batchCount = 0;
        while (exec.next()) {
            ++batchCount;
            IntVector c1 = (IntVector)((Object)exec.getValueVectorById(new SchemaPath("blue", ExpressionPosition.UNKNOWN), IntVector.class));
            IntVector c2 = (IntVector)((Object)exec.getValueVectorById(new SchemaPath("green", ExpressionPosition.UNKNOWN), IntVector.class));
            IntVector.Accessor a1 = c1.getAccessor();
            IntVector.Accessor a2 = c2.getAccessor();
            for (int i = 0; i < c1.getAccessor().getValueCount(); ++i) {
                ++recordCount;
                Assert.assertTrue((previousInt <= a1.get(i) ? 1 : 0) != 0);
                previousInt = a1.get(i);
                Assert.assertEquals((long)previousInt, (long)a2.get(i));
            }
        }
        System.out.println(String.format("Sorted %,d records in %d batches.", recordCount, batchCount));
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
    }

    @Test
    public void sortTwoKeysOneAscendingOneDescending(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)TestSimpleSort.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestSimpleSort.this.c);
                bitContext.getConfig();
                result = TestSimpleSort.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestSimpleSort.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)"/sort/two_key_sort.json"), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        int previousInt = Integer.MIN_VALUE;
        long previousLong = Long.MAX_VALUE;
        int recordCount = 0;
        int batchCount = 0;
        while (exec.next()) {
            ++batchCount;
            IntVector c1 = (IntVector)((Object)exec.getValueVectorById(new SchemaPath("blue", ExpressionPosition.UNKNOWN), IntVector.class));
            BigIntVector c2 = (BigIntVector)((Object)exec.getValueVectorById(new SchemaPath("alt", ExpressionPosition.UNKNOWN), BigIntVector.class));
            IntVector.Accessor a1 = c1.getAccessor();
            BigIntVector.Accessor a2 = c2.getAccessor();
            for (int i = 0; i < c1.getAccessor().getValueCount(); ++i) {
                ++recordCount;
                Assert.assertTrue((previousInt <= a1.get(i) ? 1 : 0) != 0);
                if (previousInt != a1.get(i)) {
                    previousLong = Long.MAX_VALUE;
                    previousInt = a1.get(i);
                }
                Assert.assertTrue((previousLong >= a2.get(i) ? 1 : 0) != 0);
            }
        }
        System.out.println(String.format("Sorted %,d records in %d batches.", recordCount, batchCount));
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
    }
}

