/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.project;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import mockit.Injectable;
import mockit.NonStrictExpectations;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.compile.CodeCompiler;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.memory.RootAllocatorFactory;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.impl.ImplCreator;
import org.apache.drill.exec.physical.impl.OperatorCreatorRegistry;
import org.apache.drill.exec.physical.impl.SimpleRootExec;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.util.VectorUtil;
import org.apache.drill.exec.vector.NullableBigIntVector;
import org.junit.Assert;
import org.junit.Test;

public class TestSimpleProjection
extends ExecTest {
    private final DrillConfig c = DrillConfig.create();

    @Test
    public void project(final @Injectable DrillbitContext bitContext, @Injectable UserServer.UserClientConnection connection) throws Throwable {
        new NonStrictExpectations(){
            {
                bitContext.getMetrics();
                result = new MetricRegistry();
                bitContext.getAllocator();
                result = RootAllocatorFactory.newRoot((DrillConfig)TestSimpleProjection.this.c);
                bitContext.getOperatorCreatorRegistry();
                result = new OperatorCreatorRegistry(TestSimpleProjection.this.c);
                bitContext.getConfig();
                result = TestSimpleProjection.this.c;
                bitContext.getCompiler();
                result = CodeCompiler.getTestCompiler((DrillConfig)TestSimpleProjection.this.c);
            }
        };
        PhysicalPlanReader reader = new PhysicalPlanReader(this.c, this.c.getMapper(), CoordinationProtos.DrillbitEndpoint.getDefaultInstance());
        PhysicalPlan plan = reader.readPhysicalPlan(Files.toString((File)FileUtils.getResourceAsFile((String)"/project/test1.json"), (Charset)Charsets.UTF_8));
        FunctionImplementationRegistry registry = new FunctionImplementationRegistry(this.c);
        FragmentContext context = new FragmentContext(bitContext, BitControl.PlanFragment.getDefaultInstance(), connection, registry);
        SimpleRootExec exec = new SimpleRootExec(ImplCreator.getExec((FragmentContext)context, (FragmentRoot)((FragmentRoot)plan.getSortedOperators(false).iterator().next())));
        while (exec.next()) {
            VectorUtil.showVectorAccessibleContent((VectorAccessible)exec.getIncoming(), (String)"\t");
            NullableBigIntVector c1 = (NullableBigIntVector)((Object)exec.getValueVectorById(new SchemaPath("col1", ExpressionPosition.UNKNOWN), NullableBigIntVector.class));
            NullableBigIntVector c2 = (NullableBigIntVector)((Object)exec.getValueVectorById(new SchemaPath("col2", ExpressionPosition.UNKNOWN), NullableBigIntVector.class));
            int x = 0;
            NullableBigIntVector.Accessor a1 = c1.getAccessor();
            NullableBigIntVector.Accessor a2 = c2.getAccessor();
            for (int i = 0; i < c1.getAccessor().getValueCount(); ++i) {
                if (!a1.isNull(i)) {
                    Assert.assertEquals((long)(a1.get(i) + 1L), (long)a2.get(i));
                }
                x = (int)((long)x + (a1.isNull(i) ? 0L : a1.get(i)));
            }
        }
        if (context.getFailureCause() != null) {
            throw context.getFailureCause();
        }
        Assert.assertTrue((!context.isFailed() ? 1 : 0) != 0);
    }
}

