/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.mergereceiver;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.pop.PopUnitTestBase;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.junit.Assert;
import org.junit.Test;

public class TestMergingReceiver
extends PopUnitTestBase {
    @Test
    public void twoBitTwoExchange() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(CONFIG, serviceSet);
             Drillbit bit2 = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit1.run();
            bit2.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/mergerecv/merging_receiver.json"), (Charset)Charsets.UTF_8));
            int count = 0;
            RecordBatchLoader batchLoader = new RecordBatchLoader(client.getAllocator());
            for (QueryDataBatch b : results) {
                count += b.getHeader().getRowCount();
                for (int valueIdx = 0; valueIdx < b.getHeader().getRowCount(); ++valueIdx) {
                    ArrayList row = Lists.newArrayList();
                    batchLoader.load(b.getHeader().getDef(), b.getData());
                    for (VectorWrapper vw : batchLoader) {
                        row.add(vw.getValueVector().getField().toExpr() + ":" + vw.getValueVector().getAccessor().getObject(valueIdx));
                    }
                    for (Object cell : row) {
                        if (cell == null) continue;
                        int len = cell.toString().length();
                        for (int i = 0; i < 30 - len; ++i) {
                        }
                    }
                }
                b.release();
                batchLoader.clear();
            }
            Assert.assertEquals((long)200000L, (long)count);
        }
    }

    @Test
    public void testMultipleProvidersMixedSizes() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(CONFIG, serviceSet);
             Drillbit bit2 = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit1.run();
            bit2.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/mergerecv/multiple_providers.json"), (Charset)Charsets.UTF_8));
            int count = 0;
            RecordBatchLoader batchLoader = new RecordBatchLoader(client.getAllocator());
            Long lastBlueValue = null;
            for (QueryDataBatch b : results) {
                count += b.getHeader().getRowCount();
                for (int valueIdx = 0; valueIdx < b.getHeader().getRowCount(); ++valueIdx) {
                    ArrayList row = Lists.newArrayList();
                    batchLoader.load(b.getHeader().getDef(), b.getData());
                    for (VectorWrapper vw : batchLoader) {
                        row.add(vw.getValueVector().getField().toExpr() + ":" + vw.getValueVector().getAccessor().getObject(valueIdx));
                        if (!vw.getValueVector().getField().getAsSchemaPath().getRootSegment().getPath().equals("blue") || (Long)vw.getValueVector().getAccessor().getObject(valueIdx) == 0L) continue;
                        if (lastBlueValue != null) {
                            Assert.assertTrue(((Long)vw.getValueVector().getAccessor().getObject(valueIdx) >= lastBlueValue ? 1 : 0) != 0);
                        }
                        lastBlueValue = (Long)vw.getValueVector().getAccessor().getObject(valueIdx);
                    }
                    for (Object cell : row) {
                        int len = cell.toString().length();
                        for (int i = 0; i < 30 - len; ++i) {
                        }
                    }
                }
                b.release();
                batchLoader.clear();
            }
            Assert.assertEquals((long)400000L, (long)count);
        }
    }

    @Test
    public void handleEmptyBatch() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(CONFIG, serviceSet);
             Drillbit bit2 = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit1.run();
            bit2.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/mergerecv/empty_batch.json"), (Charset)Charsets.UTF_8));
            int count = 0;
            RecordBatchLoader batchLoader = new RecordBatchLoader(client.getAllocator());
            for (QueryDataBatch b : results) {
                count += b.getHeader().getRowCount();
                for (int valueIdx = 0; valueIdx < b.getHeader().getRowCount(); ++valueIdx) {
                    ArrayList row = Lists.newArrayList();
                    batchLoader.load(b.getHeader().getDef(), b.getData());
                    for (VectorWrapper vw : batchLoader) {
                        row.add(vw.getValueVector().getField().toExpr() + ":" + vw.getValueVector().getAccessor().getObject(valueIdx));
                    }
                    for (Object cell : row) {
                        if (cell == null) continue;
                        int len = cell.toString().length();
                        for (int i = 0; i < 30 - len; ++i) {
                        }
                    }
                }
                b.release();
                batchLoader.clear();
            }
            Assert.assertEquals((long)100000L, (long)count);
        }
    }
}

