/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.limit;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.PlanTestBase;
import org.apache.drill.common.util.TestTools;
import org.apache.drill.exec.ExecConstants;
import org.junit.Assert;
import org.junit.Test;

public class TestLimitWithExchanges
extends BaseTestQuery {
    @Test
    public void testLimitWithExchanges() throws Exception {
        TestLimitWithExchanges.testPhysicalFromFile("limit/limit_exchanges.json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPushLimitPastUnionExchange() throws Exception {
        String WORKING_PATH = TestTools.getWorkingPath();
        String TEST_RES_PATH = WORKING_PATH + "/src/test/resources";
        try {
            TestLimitWithExchanges.test("alter session set `planner.slice_target` = 1");
            String[] excludedPlan = new String[]{};
            String sql = String.format("select * from dfs_test.`%s/tpchmulti/region` limit 1 offset 2", TEST_RES_PATH);
            String[] expectedPlan = new String[]{"(?s)Limit\\(offset=\\[2\\], fetch=\\[1\\].*UnionExchange.*Limit\\(fetch=\\[3\\]\\).*Scan"};
            this.testLimitHelper(sql, expectedPlan, excludedPlan, 1);
            String sql2 = String.format("select * from dfs_test.`%s/tpchmulti/region` limit 1 offset 0", TEST_RES_PATH);
            String[] expectedPlan2 = new String[]{"(?s)Limit\\(offset=\\[0\\], fetch=\\[1\\].*UnionExchange.*Limit\\(fetch=\\[1\\]\\).*Scan"};
            this.testLimitHelper(sql2, expectedPlan2, excludedPlan, 1);
            String sql3 = String.format("select * from dfs_test.`%s/tpchmulti/region` limit 1", TEST_RES_PATH);
            String[] expectedPlan3 = new String[]{"(?s)Limit\\(fetch=\\[1\\].*UnionExchange.*Limit\\(fetch=\\[1\\]\\).*Scan"};
            this.testLimitHelper(sql3, expectedPlan3, excludedPlan, 1);
            String sql4 = String.format("select * from dfs_test.`%s/tpchmulti/region` r,  dfs_test.`%s/tpchmulti/nation` n where r.r_regionkey = n.n_regionkey limit 1 offset 2", TEST_RES_PATH, TEST_RES_PATH);
            String[] expectedPlan4 = new String[]{"(?s)Limit\\(offset=\\[2\\], fetch=\\[1\\].*UnionExchange.*Limit\\(fetch=\\[3\\]\\).*Join"};
            this.testLimitHelper(sql4, expectedPlan4, excludedPlan, 1);
            String sql5 = String.format("select * from dfs_test.`%s/tpchmulti/region` r,  dfs_test.`%s/tpchmulti/nation` n where r.r_regionkey = n.n_regionkey limit 1", TEST_RES_PATH, TEST_RES_PATH);
            String[] expectedPlan5 = new String[]{"(?s)Limit\\(fetch=\\[1\\].*UnionExchange.*Limit\\(fetch=\\[1\\]\\).*Join"};
            this.testLimitHelper(sql5, expectedPlan5, excludedPlan, 1);
        }
        finally {
            TestLimitWithExchanges.test("alter session set `planner.slice_target` = " + ExecConstants.SLICE_TARGET_OPTION.getDefault().getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNegPushLimitPastUnionExchange() throws Exception {
        String WORKING_PATH = TestTools.getWorkingPath();
        String TEST_RES_PATH = WORKING_PATH + "/src/test/resources";
        try {
            TestLimitWithExchanges.test("alter session set `planner.slice_target` = 1");
            String[] expectedPlan = new String[]{};
            String sql = String.format("select * from dfs_test.`%s/tpchmulti/region` offset 2", TEST_RES_PATH);
            String[] excludedPlan = new String[]{"(?s)Limit\\(offset=\\[2\\].*UnionExchange.*Limit.*Scan"};
            String sql2 = String.format("select * from dfs_test.`%s/tpchmulti/region` limit 100", TEST_RES_PATH);
            String[] excludedPlan2 = new String[]{"(?s)Limit\\(fetch=\\[100\\].*UnionExchange.*Limit.*Scan"};
            this.testLimitHelper(sql2, expectedPlan, excludedPlan2, 5);
        }
        finally {
            TestLimitWithExchanges.test("alter session set `planner.slice_target` = " + ExecConstants.SLICE_TARGET_OPTION.getDefault().getValue());
        }
    }

    private void testLimitHelper(String sql, String[] expectedPlan, String[] excludedPattern, int expectedRecordCount) throws Exception {
        PlanTestBase.testPlanMatchingPatterns(sql, expectedPlan, excludedPattern);
        int actualRecordCount = TestLimitWithExchanges.testSql(sql);
        Assert.assertEquals((String)String.format("Received unexpected number of rows in output: expected=%d, received=%s", expectedRecordCount, actualRecordCount), (long)expectedRecordCount, (long)actualRecordCount);
    }
}

