/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.drill.common.util.FileUtils;
import org.apache.drill.common.util.TestTools;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.pop.PopUnitTestBase;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMergeJoinMulCondition
extends PopUnitTestBase {
    static final Logger logger = LoggerFactory.getLogger(TestMergeJoinMulCondition.class);
    @Rule
    public final TestRule TIMEOUT = TestTools.getTimeoutRule((int)200000);

    @Test
    public void testMergeJoinMultiKeys() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit1.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/join/mj_multi_condition.json"), (Charset)Charsets.UTF_8));
            int count = 0;
            for (QueryDataBatch b : results) {
                if (b.getHeader().getRowCount() != 0) {
                    count += b.getHeader().getRowCount();
                }
                b.release();
            }
            Assert.assertEquals((long)60175L, (long)count);
        }
    }

    @Test
    public void testMergeJoinInnerNullKey() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit1.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/join/merge_join_nullkey.json"), (Charset)Charsets.UTF_8).replace("${JOIN_TYPE}", "INNER"));
            int count = 0;
            for (QueryDataBatch b : results) {
                if (b.getHeader().getRowCount() != 0) {
                    count += b.getHeader().getRowCount();
                }
                b.release();
            }
            Assert.assertEquals((long)0L, (long)count);
        }
    }

    @Test
    public void testMergeJoinLeftOuterNullKey() throws Exception {
        RemoteServiceSet serviceSet = RemoteServiceSet.getLocalServiceSet();
        try (Drillbit bit1 = new Drillbit(CONFIG, serviceSet);
             DrillClient client = new DrillClient(CONFIG, serviceSet.getCoordinator());){
            bit1.run();
            client.connect();
            List results = client.runQuery(UserBitShared.QueryType.PHYSICAL, Files.toString((File)FileUtils.getResourceAsFile((String)"/join/merge_join_nullkey.json"), (Charset)Charsets.UTF_8).replace("${JOIN_TYPE}", "LEFT"));
            int count = 0;
            for (QueryDataBatch b : results) {
                if (b.getHeader().getRowCount() != 0) {
                    count += b.getHeader().getRowCount();
                }
                b.release();
            }
            Assert.assertEquals((long)110L, (long)count);
        }
    }
}

