/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import org.apache.drill.BaseTestQuery;
import org.apache.drill.common.util.TestTools;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestMergeJoinAdvanced
extends BaseTestQuery {
    @BeforeClass
    public static void disableMergeJoin() throws Exception {
        TestMergeJoinAdvanced.test("alter session set `planner.enable_hashjoin` = false");
    }

    @AfterClass
    public static void enableMergeJoin() throws Exception {
        TestMergeJoinAdvanced.test("alter session set `planner.enable_hashjoin` = true");
    }

    @Test
    public void testJoinWithDifferentTypesInCondition() throws Exception {
        String query = "select t1.full_name from cp.`employee.json` t1, cp.`department.json` t2 where cast(t1.department_id as double) = t2.department_id and t1.employee_id = 1";
        TestMergeJoinAdvanced.testBuilder().sqlQuery(query).optionSettingQueriesForTestQuery("alter session set `planner.enable_hashjoin` = true").unOrdered().baselineColumns("full_name").baselineValues("Sheri Nowmer").go();
        query = "select t1.bigint_col from cp.`jsoninput/implicit_cast_join_1.json` t1, cp.`jsoninput/implicit_cast_join_1.json` t2  where t1.bigint_col = cast(t2.bigint_col as int) and t1.double_col  = cast(t2.double_col as float) and t1.bigint_col = cast(t2.bigint_col as double)";
        TestMergeJoinAdvanced.testBuilder().sqlQuery(query).optionSettingQueriesForTestQuery("alter session set `planner.enable_hashjoin` = true").unOrdered().baselineColumns("bigint_col").baselineValues(1L).go();
        query = "select count(*) col1 from (select t1.date_opt from cp.`parquet/date_dictionary.parquet` t1, cp.`parquet/timestamp_table.parquet` t2 where t1.date_opt = t2.timestamp_col)";
        TestMergeJoinAdvanced.testBuilder().sqlQuery(query).unOrdered().baselineColumns("col1").baselineValues(4L).go();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFix2967() throws Exception {
        TestMergeJoinAdvanced.setSessionOption(PlannerSettings.BROADCAST.getOptionName(), "false");
        TestMergeJoinAdvanced.setSessionOption(PlannerSettings.HASHJOIN.getOptionName(), "false");
        TestMergeJoinAdvanced.setSessionOption("planner.slice_target", "1");
        TestMergeJoinAdvanced.setSessionOption("planner.width.max_per_node", "23");
        String TEST_RES_PATH = TestTools.getWorkingPath() + "/src/test/resources";
        try {
            TestMergeJoinAdvanced.test("select * from dfs_test.`%s/join/j1` j1 left outer join dfs_test.`%s/join/j2` j2 on (j1.c_varchar = j2.c_varchar)", TEST_RES_PATH, TEST_RES_PATH);
        }
        finally {
            TestMergeJoinAdvanced.setSessionOption(PlannerSettings.BROADCAST.getOptionName(), String.valueOf(PlannerSettings.BROADCAST.getDefault().bool_val));
            TestMergeJoinAdvanced.setSessionOption(PlannerSettings.HASHJOIN.getOptionName(), String.valueOf(PlannerSettings.HASHJOIN.getDefault().bool_val));
            TestMergeJoinAdvanced.setSessionOption("planner.slice_target", String.valueOf(100000L));
            TestMergeJoinAdvanced.setSessionOption("planner.width.max_per_node", String.valueOf(ExecConstants.MAX_WIDTH_PER_NODE.getDefault().num_val));
        }
    }
}

